/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.applovin;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import androidx.annotation.NonNull;
import com.applovin.adview.AppLovinAdView;
import com.applovin.adview.AppLovinAdViewDisplayErrorCode;
import com.applovin.adview.AppLovinAdViewEventListener;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdSize;
import com.yodo1.mas.banner.Yodo1MasBannerAdSize;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasBannerAdapterBase;

public class Yodo1MasAppLovinBannerAdapter
extends Yodo1MasBannerAdapterBase {
    private final AppLovinAdLoadListener bannerLoadListener = new AppLovinAdLoadListener(){

        public void adReceived(AppLovinAd appLovinAd) {
            String message = "method: adReceived, banner: " + appLovinAd.getAdIdNumber();
            Log.d((String)Yodo1MasAppLovinBannerAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinBannerAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.LOADED;
            Yodo1MasAppLovinBannerAdapter.this.trackAdRequestSuccessed();
            Yodo1MasAppLovinBannerAdapter.this.callback(1003, Yodo1MasAppLovinBannerAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAppLovinBannerAdapter.this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.LOADED;
            Yodo1MasAppLovinBannerAdapter.this.callbackAdapterState();
        }

        public void failedToReceiveAd(int i) {
            String message = "method: failedToReceiveAd, error: " + i;
            Log.d((String)Yodo1MasAppLovinBannerAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinBannerAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            Yodo1MasAppLovinBannerAdapter.this.trackAdRequestFailed(i, null);
            if (Yodo1MasAppLovinBannerAdapter.this.isLastPlacement()) {
                Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasAppLovinBannerAdapter.this.TAG + ":{" + message + "}");
                Yodo1MasAppLovinBannerAdapter.this.callback(error);
                Yodo1MasAppLovinBannerAdapter.this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.FAILED;
                Yodo1MasAppLovinBannerAdapter.this.callbackAdapterState();
            } else {
                Yodo1MasAppLovinBannerAdapter.this.nextBanner();
                Yodo1MasAppLovinBannerAdapter.this.loadBannerAdvertDelayed();
            }
        }
    };
    private final AppLovinAdViewEventListener bannerPlayListener = new AppLovinAdViewEventListener(){

        public void adOpenedFullscreen(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView) {
            String message = "method: adOpenedFullscreen, banner: " + appLovinAd.getAdIdNumber();
            Log.d((String)Yodo1MasAppLovinBannerAdapter.this.TAG, (String)message);
        }

        public void adClosedFullscreen(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView) {
            String message = "method: adClosedFullscreen, banner: " + appLovinAd.getAdIdNumber();
            Log.d((String)Yodo1MasAppLovinBannerAdapter.this.TAG, (String)message);
        }

        public void adLeftApplication(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView) {
            String message = "method: adLeftApplication, banner: " + appLovinAd.getAdIdNumber();
            Log.d((String)Yodo1MasAppLovinBannerAdapter.this.TAG, (String)message);
        }

        public void adFailedToDisplay(AppLovinAd appLovinAd, AppLovinAdView appLovinAdView, AppLovinAdViewDisplayErrorCode appLovinAdViewDisplayErrorCode) {
            String message = "method: adFailedToDisplay, banner: " + appLovinAd.getAdIdNumber() + ", error:" + appLovinAdViewDisplayErrorCode;
            Log.d((String)Yodo1MasAppLovinBannerAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600201, Yodo1MasAppLovinBannerAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAppLovinBannerAdapter.this.callbackDisplayError(error, appLovinAdViewDisplayErrorCode.toString(), null);
            if (Yodo1MasAppLovinBannerAdapter.this.isLastPlacement()) {
                Yodo1MasAppLovinBannerAdapter.this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.FAILED;
                Yodo1MasAppLovinBannerAdapter.this.callbackAdapterState();
            }
        }
    };
    private final AppLovinAdDisplayListener bannerDisplayListener = new AppLovinAdDisplayListener(){

        public void adDisplayed(AppLovinAd appLovinAd) {
            String message = "method: adDisplayed, banner: " + appLovinAd.getAdIdNumber();
            Log.d((String)Yodo1MasAppLovinBannerAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinBannerAdapter.this.callback(1001, Yodo1MasAppLovinBannerAdapter.this.TAG + ":{" + message + "}");
        }

        public void adHidden(AppLovinAd appLovinAd) {
            String message = "method: adHidden, banner: " + appLovinAd.getAdIdNumber();
            Log.d((String)Yodo1MasAppLovinBannerAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinBannerAdapter.this.callback(1002, Yodo1MasAppLovinBannerAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAppLovinBannerAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            Yodo1MasAppLovinBannerAdapter.this.loadBannerAdvert();
        }
    };
    private final AppLovinAdClickListener bannerClickListener = appLovinAd -> {
        String message = "method: adClicked, banner: " + appLovinAd.getAdIdNumber();
        Log.d((String)this.TAG, (String)message);
    };
    private AppLovinAdView bannerAd;
    private String currBannerUnitId;

    public boolean isBannerAdvertLoaded() {
        return this.bannerAd != null && this.bannerState == Yodo1MasAdapterBase.AdvertState.LOADED;
    }

    public void loadBannerAdvert(@NonNull Activity activity) {
        super.loadBannerAdvert(activity);
        if (this.relateAdapter != null && !this.relateAdapter.isInitSDK()) {
            return;
        }
        Yodo1MasAdapterBase.AdId adId = this.getBannerAdId();
        if (adId != null && adId.object != null && !this.isPriceValuable(adId)) {
            this.handlePricyNotAbaliable();
            return;
        }
        if (!(adId == null || TextUtils.isEmpty((CharSequence)adId.adId) || !TextUtils.isEmpty((CharSequence)this.currBannerUnitId) && adId.adId.equals(this.currBannerUnitId))) {
            AppLovinAdSize bannerSize = this.getBannerSize();
            this.bannerAd = new AppLovinAdView(bannerSize, adId.adId, (Context)activity);
            this.bannerAd.setAdLoadListener(this.bannerLoadListener);
            this.bannerAd.setAdDisplayListener(this.bannerDisplayListener);
            this.bannerAd.setAdViewEventListener(this.bannerPlayListener);
            this.bannerAd.setAdClickListener(this.bannerClickListener);
            this.currBannerUnitId = adId.adId;
        }
        if (this.bannerAd != null && this.bannerState != Yodo1MasAdapterBase.AdvertState.LOADING) {
            String message = "method: loadBannerAdvert, load banner ad...";
            Log.d((String)this.TAG, (String)message);
            this.bannerAd.loadNextAd();
            this.bannerState = Yodo1MasAdapterBase.AdvertState.LOADING;
            this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.LOADING;
            this.logAdIdInfo(adId);
        }
    }

    private AppLovinAdSize getBannerSize() {
        Yodo1MasBannerAdSize size = this.bannerConfig.size;
        Log.d((String)this.TAG, (String)("setBannerSize: size: " + size.name()));
        if (Yodo1MasBannerAdSize.Banner == size) {
            return AppLovinAdSize.BANNER;
        }
        if (Yodo1MasBannerAdSize.IABMediumRectangle == size) {
            return AppLovinAdSize.MREC;
        }
        return AppLovinAdSize.BANNER;
    }

    public View getBannerView() {
        return this.bannerAd;
    }

    public void dismissBannerAdvert(boolean destroy) {
        super.dismissBannerAdvert(destroy);
        if (this.bannerAd != null && destroy) {
            this.bannerAd.destroy();
            this.bannerAd = null;
            this.currBannerUnitId = null;
            this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.NONE;
        }
    }

    public boolean isSupportMultipleInstance() {
        return true;
    }
}

