/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.applovin;

import android.app.Activity;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxError;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.MaxRewardedAdListener;
import com.applovin.mediation.ads.MaxRewardedAd;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import java.util.List;

public class Yodo1MasAppLovinMaxRewardAdapter
extends Yodo1MasRewardAdapterBase {
    private MaxRewardedAd rewardAd;
    private final MaxRewardedAdListener rewardListener = new MaxRewardedAdListener(){

        public void onAdLoaded(MaxAd ad) {
            String message = "method: onAdLoaded, reward, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Log.d((String)Yodo1MasAppLovinMaxRewardAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinMaxRewardAdapter.this.callbackLoad();
        }

        public void onAdLoadFailed(String adUnitId, MaxError adError) {
            String message = "method: onAdLoadFailed, reward, AdUnitId: " + adUnitId + ", error: " + adError.getWaterfall();
            Log.d((String)Yodo1MasAppLovinMaxRewardAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasAppLovinMaxRewardAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAppLovinMaxRewardAdapter.this.callbackError(error, adError.getCode(), adError.getMessage());
        }

        public void onAdDisplayed(MaxAd ad) {
            String message = "method: onAdDisplayed, reward, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Log.d((String)Yodo1MasAppLovinMaxRewardAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinMaxRewardAdapter.this.callbackOpen();
        }

        public void onAdDisplayFailed(MaxAd ad, MaxError adError) {
            String message = "method: onAdDisplayFailed, reward, AdUnitId: " + ad.getAdUnitId() + ", error: " + adError.getWaterfall();
            Log.d((String)Yodo1MasAppLovinMaxRewardAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600201, Yodo1MasAppLovinMaxRewardAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAppLovinMaxRewardAdapter.this.callbackError(error, adError.getCode(), adError.getMessage());
        }

        public void onAdHidden(MaxAd ad) {
            String message = "method: onAdHidden, reward, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Log.d((String)Yodo1MasAppLovinMaxRewardAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinMaxRewardAdapter.this.callbackClose();
        }

        public void onAdClicked(MaxAd ad) {
            String message = "method: onAdClicked, reward, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Log.d((String)Yodo1MasAppLovinMaxRewardAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinMaxRewardAdapter.this.callbackClick();
        }

        public void onRewardedVideoStarted(MaxAd ad) {
            String message = "method: onRewardedVideoStarted, reward, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Log.d((String)Yodo1MasAppLovinMaxRewardAdapter.this.TAG, (String)message);
        }

        public void onRewardedVideoCompleted(MaxAd ad) {
            String message = "method: onRewardedVideoCompleted, reward, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Log.d((String)Yodo1MasAppLovinMaxRewardAdapter.this.TAG, (String)message);
        }

        public void onUserRewarded(MaxAd ad, MaxReward reward) {
            String message = "method: onUserRewarded, reward, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Log.d((String)Yodo1MasAppLovinMaxRewardAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinMaxRewardAdapter.this.callbackEarned();
        }
    };

    public Yodo1MasAppLovinMaxRewardAdapter(List<Yodo1MasAdapterBase.AdId> unitIds) {
        super(unitIds);
    }

    public boolean isRewardAdLoaded() {
        return this.rewardAd != null && this.rewardAd.isReady();
    }

    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);
        String adId = this.getAdUnitId(false);
        if (TextUtils.isEmpty((CharSequence)adId)) {
            return;
        }
        if (this.rewardStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) {
            return;
        }
        String message = "method: loadRewardAdvert, loading reward ad...";
        Log.d((String)this.TAG, (String)message);
        this.rewardStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        this.rewardAd = MaxRewardedAd.getInstance((String)adId, (Activity)activity);
        this.rewardAd.setListener(this.rewardListener);
        this.rewardAd.loadAd();
    }

    public void showRewardAdvertFromActivity(@NonNull Activity activity) {
        super.showRewardAdvertFromActivity(activity);
        if (this.isRewardAdLoaded()) {
            String message = "method: showRewardAdvert, show reward ad...";
            Log.d((String)this.TAG, (String)message);
            if (!TextUtils.isEmpty((CharSequence)this.rewardPlacement)) {
                this.rewardAd.showAd(this.rewardPlacement);
            } else {
                this.rewardAd.showAd();
            }
        }
    }

    public void destroy() {
        super.destroy();
        if (this.rewardAd != null) {
            this.rewardAd.destroy();
        }
        this.rewardAd = null;
    }
}

