/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.applovin;

import android.app.Activity;
import android.text.TextUtils;
import android.util.Log;
import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxAdListener;
import com.applovin.mediation.MaxError;
import com.applovin.mediation.ads.MaxInterstitialAd;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import java.util.List;

public class Yodo1MasAppLovinMaxInterstitialAdapter
extends Yodo1MasInterstitialAdapterBase {
    private MaxInterstitialAd interstitialAd;
    private final MaxAdListener interstitialListener = new MaxAdListener(){

        public void onAdLoaded(MaxAd ad) {
            String message = "method: onAdLoaded, interstitial, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Log.d((String)Yodo1MasAppLovinMaxInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinMaxInterstitialAdapter.this.callbackLoad();
        }

        public void onAdLoadFailed(String adUnitId, MaxError adError) {
            String message = "method: onAdLoadFailed, interstitial, AdUnitId: " + adUnitId + ", error: " + adError.getWaterfall();
            Log.d((String)Yodo1MasAppLovinMaxInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasAppLovinMaxInterstitialAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAppLovinMaxInterstitialAdapter.this.callbackError(error, adError.getCode(), adError.getMessage());
        }

        public void onAdDisplayed(MaxAd ad) {
            String message = "method: onAdDisplayed, interstitial, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Log.d((String)Yodo1MasAppLovinMaxInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinMaxInterstitialAdapter.this.callbackOpen();
        }

        public void onAdDisplayFailed(MaxAd ad, MaxError adError) {
            String message = "method: onAdDisplayFailed, interstitial, AdUnitId: " + ad.getAdUnitId() + ", error: " + adError.getWaterfall();
            Log.d((String)Yodo1MasAppLovinMaxInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600201, Yodo1MasAppLovinMaxInterstitialAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAppLovinMaxInterstitialAdapter.this.callbackError(error, adError.getCode(), adError.getMessage());
        }

        public void onAdHidden(MaxAd ad) {
            String message = "method: onAdHidden, interstitial, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Log.d((String)Yodo1MasAppLovinMaxInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinMaxInterstitialAdapter.this.callbackClose();
        }

        public void onAdClicked(MaxAd ad) {
            String message = "method: onAdClicked, interstitial, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Log.d((String)Yodo1MasAppLovinMaxInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinMaxInterstitialAdapter.this.callbackClick();
        }
    };

    public Yodo1MasAppLovinMaxInterstitialAdapter(List<Yodo1MasAdapterBase.AdId> unitIds) {
        super(unitIds);
    }

    public boolean isInterstitialAdLoaded() {
        return this.interstitialAd != null && this.interstitialAd.isReady();
    }

    public void loadInterstitialAdvert(Activity activity) {
        super.loadInterstitialAdvert(activity);
        String adId = this.getAdUnitId(false);
        if (TextUtils.isEmpty((CharSequence)adId)) {
            return;
        }
        if (this.interstitialStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) {
            return;
        }
        String message = "method: loadInterstitialAdvert, loading interstitial ad...";
        Log.d((String)this.TAG, (String)message);
        this.interstitialStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        this.interstitialAd = new MaxInterstitialAd(adId, activity);
        this.interstitialAd.setListener(this.interstitialListener);
        this.interstitialAd.loadAd();
    }

    public void destroy() {
        super.destroy();
        if (this.interstitialAd != null) {
            this.interstitialAd.destroy();
        }
        this.interstitialAd = null;
    }

    public void showInterstitialAdvertFromActivity(Activity activity) {
        super.showInterstitialAdvertFromActivity(activity);
        if (this.isInterstitialAdLoaded()) {
            String message = "method: showInterstitialAdvert, show interstitial ad...";
            Log.d((String)this.TAG, (String)message);
            if (!TextUtils.isEmpty((CharSequence)this.interstitialPlacement)) {
                this.interstitialAd.showAd(this.interstitialPlacement);
            } else {
                this.interstitialAd.showAd();
            }
        }
    }
}

