package com.yodo1.mas.mediation.applovin;

import android.app.Activity;
import android.util.Log;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.applovin.sdk.AppLovinPrivacySettings;
import com.applovin.sdk.AppLovinSdk;

import com.yodo1.mas.helper.Yodo1MasHelper;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.nativeads.Yodo1MasNativeAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;

public class Yodo1MasAppLovinAdapter extends Yodo1MasAdapterBase {

    public static void setAppLoinPrivacy(Activity activity) {
        if (activity == null) {
            return;
        }
        AppLovinPrivacySettings.setHasUserConsent(Yodo1MasHelper.getInstance().isGDPRUserConsent(), activity);
        AppLovinPrivacySettings.setIsAgeRestrictedUser(Yodo1MasHelper.getInstance().isCOPPAAgeRestricted(), activity);
        AppLovinPrivacySettings.setDoNotSell(Yodo1MasHelper.getInstance().isCCPADoNotSell(), activity);
    }

    @Override
    public String getAdvertCode() {
        return "applovin";
    }

    @Override
    public String getSDKVersion() {
        return AppLovinSdk.VERSION;
    }

    @Override
    public String getMediationVersion() {
        return BuildConfig.MAS_VERSION_NAME;
    }

    @Override
    public void initSDK(@NonNull Activity activity, @NonNull Config config, @Nullable InitCallback callback) {
        super.initSDK(activity, config, callback);
        if (!isInitSDK()) {
            init = true;
            AppLovinSdk.initializeSdk(currentActivity, configuration -> {
                String message = "method: onSdkInitialized, configuration: " + configuration.getConsentDialogState();
                Log.d(TAG, message);

                updatePrivacy();
                if (callback != null) {
                    callback.onAdapterInitSuccessful(getAdvertCode());
                }
            });
        } else {
            if (callback != null) {
                callback.onAdapterInitSuccessful(getAdvertCode());
            }
        }
    }

    @Override
    public void updatePrivacy() {
        super.updatePrivacy();
        setAppLoinPrivacy(currentActivity);
    }

    // Reward
    @Override
    protected Class<? extends Yodo1MasRewardAdapterBase> rewardAdapterClass() {
        return Yodo1MasAppLovinRewardAdapter.class;
    }


    // Interstitial
    @Override
    protected Class<? extends Yodo1MasInterstitialAdapterBase> interstitialAdapterClass() {
        return Yodo1MasAppLovinInterstitialAdapter.class;
    }

    // Native
    @Override
    public Class<? extends Yodo1MasNativeAdapterBase> nativeAdapterClass() {
        return null;
    }

    // Banner
    @Override
    public Class<? extends Yodo1MasBannerAdapterBase> bannerAdapterClass() {
        return Yodo1MasAppLovinBannerAdapter.class;
    }
}
