/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.applovin;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.applovin.sdk.AppLovinPrivacySettings;
import com.applovin.sdk.AppLovinSdk;
import com.yodo1.mas.appopenad.Yodo1MasAppOpenAdapterBase;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.helper.Yodo1MasHelper;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.mediation.applovin.Yodo1MasAppLovinMaxBannerAdapter;
import com.yodo1.mas.mediation.applovin.Yodo1MasAppLovinMaxInterstitialAdapter;
import com.yodo1.mas.mediation.applovin.Yodo1MasAppLovinMaxNativeAdapter;
import com.yodo1.mas.mediation.applovin.Yodo1MasAppLovinMaxRewardAdapter;
import com.yodo1.mas.nativeads.Yodo1MasNativeAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import com.yodo1.mas.rewardedinterstitial.Yodo1MasRewardedInterstitialAdapterBase;
import com.yodo1.mas.utils.Yodo1MasUtils;

public class Yodo1MasAppLovinMaxAdapter
extends Yodo1MasAdapterBase {
    public String getAdvertCode() {
        return "APPLOVIN";
    }

    public String getSDKVersion() {
        return AppLovinSdk.VERSION;
    }

    public String getMediationVersion() {
        return "4.8.0";
    }

    public void initSDK(@NonNull Activity activity, @NonNull Yodo1MasAdapterBase.Config config, @Nullable Yodo1MasAdapterBase.InitCallback callback) {
        super.initSDK(activity, config, callback);
        if (!this.isInitSDK()) {
            this.init = true;
            if (this.isMax()) {
                AppLovinSdk.getInstance((Context)this.currentActivity).setMediationProvider("max");
            }
            AppLovinSdk.initializeSdk((Context)this.currentActivity, configuration -> {
                String message = "method: onSdkInitialized, configuration: " + configuration.getConsentDialogState();
                Log.d((String)this.TAG, (String)message);
                this.updatePrivacy();
                if (callback != null) {
                    callback.onAdapterInitSuccessful(this.getAdvertCode());
                }
                if (Yodo1MasUtils.getMetaData((Context)activity, (String)"com.yodo1.mas.EnableAppLovinMediationDebugger", (boolean)false)) {
                    AppLovinSdk.getInstance((Context)activity).showMediationDebugger();
                }
            });
        } else if (callback != null) {
            callback.onAdapterInitSuccessful(this.getAdvertCode());
        }
    }

    public void updatePrivacy() {
        super.updatePrivacy();
        if (this.currentActivity != null) {
            AppLovinPrivacySettings.setHasUserConsent((boolean)Yodo1MasHelper.getInstance().isGDPRUserConsent(), (Context)this.currentActivity);
            AppLovinPrivacySettings.setIsAgeRestrictedUser((boolean)Yodo1MasHelper.getInstance().isCOPPAAgeRestricted(), (Context)this.currentActivity);
            AppLovinPrivacySettings.setDoNotSell((boolean)Yodo1MasHelper.getInstance().isCCPADoNotSell(), (Context)this.currentActivity);
        }
    }

    public boolean isMax() {
        return true;
    }

    protected Class<? extends Yodo1MasRewardAdapterBase> rewardAdapterClass() {
        return Yodo1MasAppLovinMaxRewardAdapter.class;
    }

    protected Class<? extends Yodo1MasInterstitialAdapterBase> interstitialAdapterClass() {
        return Yodo1MasAppLovinMaxInterstitialAdapter.class;
    }

    public Class<? extends Yodo1MasNativeAdapterBase> nativeAdapterClass() {
        return Yodo1MasAppLovinMaxNativeAdapter.class;
    }

    public Class<? extends Yodo1MasBannerAdapterBase> bannerAdapterClass() {
        return Yodo1MasAppLovinMaxBannerAdapter.class;
    }

    protected Class<? extends Yodo1MasRewardedInterstitialAdapterBase> rewardedInterstitialAdapterClass() {
        return null;
    }

    protected Class<? extends Yodo1MasAppOpenAdapterBase> appOpenAdapterClass() {
        return null;
    }
}

