package com.yodo1.mas.mediation.applovin;

import android.app.Activity;
import android.text.TextUtils;

import androidx.annotation.NonNull;

import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxAdRevenueListener;
import com.applovin.mediation.MaxError;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.MaxRewardedAdListener;
import com.applovin.mediation.ads.MaxRewardedAd;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;

import java.util.List;

public class Yodo1MasAppLovinMaxRewardAdapter extends Yodo1MasRewardAdapterBase {
    private final MaxRewardedAdListener rewardListener = new MaxRewardedAdListener() {

        @Override
        public void onAdLoaded(MaxAd ad) {
            String message = "method: onAdLoaded, reward, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.v(TAG, message);
            adSource = ad.getNetworkName();
            callbackLoad();
        }

        @Override
        public void onAdLoadFailed(String adUnitId, MaxError adError) {
            String message = "method: onAdLoadFailed, reward, AdUnitId: " + adUnitId + ", error: " + adError.getWaterfall();
            Yodo1MasLog.v(TAG, message);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            callbackError(error, adError.getCode(), adError.getMessage());
        }

        @Override
        public void onAdDisplayed(MaxAd ad) {
            String message = "method: onAdDisplayed, reward, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.v(TAG, message);
            adSource = ad.getNetworkName();
            callbackOpen();
        }

        @Override
        public void onAdDisplayFailed(MaxAd ad, MaxError adError) {
            String message = "method: onAdDisplayFailed, reward, AdUnitId: " + ad.getAdUnitId() + ", error: " + adError.getWaterfall();
            Yodo1MasLog.v(TAG, message);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_SHOW_FAIL, TAG + ":{" + message + "}");
            callbackError(error, adError.getCode(), adError.getMessage());
        }

        @Override
        public void onAdHidden(MaxAd ad) {
            String message = "method: onAdHidden, reward, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.v(TAG, message);
            adSource = ad.getNetworkName();
            callbackClose();
        }

        @Override
        public void onAdClicked(MaxAd ad) {
            String message = "method: onAdClicked, reward, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.v(TAG, message);
            adSource = ad.getNetworkName();
            callbackClick();
        }

        @Override
        public void onRewardedVideoStarted(MaxAd ad) {
            String message = "method: onRewardedVideoStarted, reward, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.v(TAG, message);
        }

        @Override
        public void onRewardedVideoCompleted(MaxAd ad) {
            String message = "method: onRewardedVideoCompleted, reward, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.v(TAG, message);
        }

        @Override
        public void onUserRewarded(MaxAd ad, MaxReward reward) {
            String message = "method: onUserRewarded, reward, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.v(TAG, message);
            adSource = ad.getNetworkName();
            callbackEarned();
        }
    };
    private MaxRewardedAd rewardAd;
    private MaxAdRevenueListener revenueListener;

    public Yodo1MasAppLovinMaxRewardAdapter(List<Yodo1MasAdapterBase.AdId> unitIds) {
        super(unitIds);
    }

    @Override
    public boolean isRewardAdLoaded() {
        return rewardAd != null && rewardAd.isReady();
    }

    @Override
    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);
        String adId = getAdUnitId(false);
        if (TextUtils.isEmpty(adId)) return;
        if (rewardStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) return;
        String message = "method: loadRewardAdvert, loading reward ad...";
        Yodo1MasLog.v(TAG, message);

        rewardStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        rewardAd = MaxRewardedAd.getInstance(adId, activity);
        rewardAd.setListener(rewardListener);
        if (this.revenueListener != null) {
            rewardAd.setRevenueListener(revenueListener);
        }
        rewardAd.loadAd();
    }

    @Override
    public void showRewardAdvertFromActivity(@NonNull Activity activity) {
        super.showRewardAdvertFromActivity(activity);
        if (isRewardAdLoaded()) {
            String message = "method: showRewardAdvert, show reward ad...";
            Yodo1MasLog.v(TAG, message);

            if (!TextUtils.isEmpty(rewardPlacement)) {
                rewardAd.showAd(rewardPlacement);
            } else {
                rewardAd.showAd();
            }
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (rewardAd != null) {
            rewardAd.destroy();
        }
        rewardAd = null;
    }

    public void setRevenueListener(MaxAdRevenueListener revenueListener) {
        this.revenueListener = revenueListener;
    }
}
