/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.applovin;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxAdRevenueListener;
import com.applovin.mediation.MaxError;
import com.applovin.mediation.nativeAds.MaxNativeAdListener;
import com.applovin.mediation.nativeAds.MaxNativeAdLoader;
import com.applovin.mediation.nativeAds.MaxNativeAdView;
import com.applovin.mediation.nativeAds.MaxNativeAdViewBinder;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.nativeads.Yodo1MasNativeAdapterBase;
import java.util.List;

public class Yodo1MasAppLovinMaxNativeAdapter
extends Yodo1MasNativeAdapterBase {
    private MaxAdRevenueListener revenueListener;
    private MaxNativeAdLoader loader;
    private MaxNativeAdView adView;
    private MaxAd ad;
    private final MaxNativeAdListener listener = new MaxNativeAdListener(){

        private void setViewBackground(ViewGroup group) {
            if (group == null || group.getChildCount() == 0) {
                return;
            }
            for (int i = 0; i < group.getChildCount(); ++i) {
                View childView = group.getChildAt(i);
                if (!(childView instanceof TextView) && !(childView instanceof ImageView)) {
                    childView.setBackgroundColor(0);
                }
                if (!(childView instanceof ViewGroup)) continue;
                this.setViewBackground((ViewGroup)childView);
            }
        }

        public void onNativeAdLoaded(MaxNativeAdView maxNativeAdView, MaxAd maxAd) {
            String message = "method: onNativeAdLoaded, AdUnitId: " + maxAd.getAdUnitId() + ", NetworkName: " + maxAd.getNetworkName() + ", maxNativeAdView: " + maxNativeAdView;
            Yodo1MasLog.v((String)Yodo1MasAppLovinMaxNativeAdapter.this.TAG, (String)message);
            this.setViewBackground((ViewGroup)maxNativeAdView);
            Yodo1MasAppLovinMaxNativeAdapter.this.adView = maxNativeAdView;
            Yodo1MasAppLovinMaxNativeAdapter.this.ad = maxAd;
            Yodo1MasAppLovinMaxNativeAdapter.this.adSource = Yodo1MasAppLovinMaxNativeAdapter.this.ad.getNetworkName();
            Yodo1MasAppLovinMaxNativeAdapter.this.callbackLoad();
        }

        public void onNativeAdLoadFailed(String adUnitId, MaxError maxError) {
            String message = "method: onNativeAdLoadFailed, AdUnitId: " + adUnitId + ", error: " + maxError.getWaterfall();
            Yodo1MasLog.v((String)Yodo1MasAppLovinMaxNativeAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600202, adUnitId);
            Yodo1MasAppLovinMaxNativeAdapter.this.callbackError(error, maxError.getCode() + "", maxError.getMessage());
        }

        public void onNativeAdClicked(MaxAd maxAd) {
            String message = "method: onNativeAdClicked, AdUnitId: " + Yodo1MasAppLovinMaxNativeAdapter.this.ad.getAdUnitId() + ", NetworkName: " + Yodo1MasAppLovinMaxNativeAdapter.this.ad.getNetworkName();
            Yodo1MasLog.v((String)Yodo1MasAppLovinMaxNativeAdapter.this.TAG, (String)message);
            Yodo1MasAppLovinMaxNativeAdapter.this.adSource = Yodo1MasAppLovinMaxNativeAdapter.this.ad.getNetworkName();
            Yodo1MasAppLovinMaxNativeAdapter.this.callbackClick();
        }
    };
    private Activity activity;

    public Yodo1MasAppLovinMaxNativeAdapter(List<Yodo1MasAdapterBase.AdId> unitIds) {
        super(unitIds);
    }

    public View getNativeAdView() {
        return this.adView;
    }

    private void loadNativeAd(Activity activity, MaxNativeAdViewBinder.Builder builder) {
        if (activity == null) {
            return;
        }
        String unitId = this.getAdUniId(false);
        if (TextUtils.isEmpty((CharSequence)unitId)) {
            return;
        }
        MaxNativeAdView maxAdView = null;
        if (this.builder != null && builder != null) {
            MaxNativeAdViewBinder binder = builder.setTitleTextViewId(this.builder.getTitleTextViewId()).setBodyTextViewId(this.builder.getBodyTextViewId()).setAdvertiserTextViewId(this.builder.getAdvertiserTextViewId()).setIconImageViewId(this.builder.getIconImageViewId()).setMediaContentViewGroupId(this.builder.getMediaContentViewGroupId()).setOptionsContentViewGroupId(this.builder.getOptionsContentViewGroupId()).setCallToActionButtonId(this.builder.getCallToActionButtonId()).build();
            maxAdView = new MaxNativeAdView(binder, (Context)activity);
        }
        this.nativeState = Yodo1MasAdapterBase.AdvertState.LOADING;
        this.activity = activity;
        this.loader = new MaxNativeAdLoader(unitId, (Context)activity);
        this.loader.setNativeAdListener(this.listener);
        if (this.revenueListener != null) {
            this.loader.setRevenueListener(this.revenueListener);
        }
        this.loader.setPlacement(this.nativePlacement);
        if (maxAdView != null) {
            this.loader.loadAd(maxAdView);
        } else {
            this.loader.loadAd();
        }
    }

    public void loadNativeAd(Activity activity) {
        super.loadNativeAd(activity);
        this.loadNativeAd(activity, (MaxNativeAdViewBinder.Builder)null);
    }

    public void loadNativeAd(Activity activity, int layoutId) {
        super.loadNativeAd(activity, layoutId);
        MaxNativeAdViewBinder.Builder builder = new MaxNativeAdViewBinder.Builder(layoutId);
        this.loadNativeAd(activity, builder);
    }

    public void loadNativeAd(Activity activity, Class<? extends View> layoutView) {
        super.loadNativeAd(activity, layoutView);
        MaxNativeAdViewBinder.Builder builder = new MaxNativeAdViewBinder.Builder(this.generateView(layoutView, (Context)activity));
        this.loadNativeAd(activity, builder);
    }

    public void loadNextNativeAd() {
        super.loadNextNativeAd();
        if (this.activity == null) {
            return;
        }
        String unitId = this.getAdUniId(true);
        if (this.loader.getAdUnitId().equals(unitId)) {
            return;
        }
        this.nativeState = Yodo1MasAdapterBase.AdvertState.LOADING;
        this.loader = new MaxNativeAdLoader(unitId, (Context)this.activity);
        this.loader.setNativeAdListener(this.listener);
        if (this.revenueListener != null) {
            this.loader.setRevenueListener(this.revenueListener);
        }
        this.loader.setPlacement(this.nativePlacement);
        this.loader.loadAd();
    }

    public void destroyNative() {
        super.destroyNative();
        if (this.loader != null && this.ad != null) {
            this.loader.destroy(this.ad);
        }
        this.loader = null;
    }

    public void setRevenueListener(MaxAdRevenueListener revenueListener) {
        this.revenueListener = revenueListener;
    }
}

