package com.yodo1.mas.mediation.applovin;

import android.app.Activity;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxAdRevenueListener;
import com.applovin.sdk.AppLovinPrivacySettings;
import com.applovin.sdk.AppLovinSdk;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.analytics.Yodo1MasDataAnalytics;
import com.yodo1.mas.appopenad.Yodo1MasAppOpenAdapterBase;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.helper.Yodo1MasHelper;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.nativeads.Yodo1MasNativeAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import com.yodo1.mas.rewardedinterstitial.Yodo1MasRewardedInterstitialAdapterBase;
import com.yodo1.mas.utils.Yodo1MasUtils;

public class Yodo1MasAppLovinMaxAdapter extends Yodo1MasAdapterBase {

    private final MaxAdRevenueListener revenueListener = new MaxAdRevenueListener() {
        @Override
        public void onAdRevenuePaid(MaxAd impressionData) {
            Yodo1MasDataAnalytics.trackAdRevenue("appLovin",
                    impressionData.getNetworkName(),
                    impressionData.getFormat().getDisplayName(),
                    impressionData.getAdUnitId(),
                    impressionData.getRevenue(), "USD");
        }
    };

    @Override
    public String getAdvertCode() {
        return "APPLOVIN";
    }

    @Override
    public String getSDKVersion() {
        return AppLovinSdk.VERSION;
    }

    @Override
    public String getMediationVersion() {
        return BuildConfig.MAS_VERSION_NAME;
    }

    @Override
    public void initSDK(@NonNull Activity activity, @NonNull Config config, @Nullable InitCallback callback) {
        super.initSDK(activity, config, callback);
        if (!isInitSDK()) {
            init = true;
            if (isMax()) {
                AppLovinSdk.getInstance(currentActivity).setMediationProvider("max");
            }
            AppLovinSdk.initializeSdk(currentActivity, configuration -> {
                String message = "method: onSdkInitialized, configuration: " + configuration.getConsentDialogState();
                Yodo1MasLog.v(TAG, message);

                updatePrivacy();

                if (callback != null) {
                    callback.onAdapterInitSuccessful(getAdvertCode());
                }
                if (Yodo1MasUtils.getMetaData(activity, "com.yodo1.mas.EnableAppLovinMediationDebugger", false)) {
                    AppLovinSdk.getInstance(activity).showMediationDebugger();
                }
            });
        } else {
            if (callback != null) {
                callback.onAdapterInitSuccessful(getAdvertCode());
            }
        }
    }

    @Override
    public void updatePrivacy() {
        super.updatePrivacy();
        if (currentActivity != null) {
            AppLovinPrivacySettings.setHasUserConsent(Yodo1MasHelper.getInstance().isGDPRUserConsent(), currentActivity);
            AppLovinPrivacySettings.setIsAgeRestrictedUser(Yodo1MasHelper.getInstance().isCOPPAAgeRestricted(), currentActivity);
            AppLovinPrivacySettings.setDoNotSell(Yodo1MasHelper.getInstance().isCCPADoNotSell(), currentActivity);
        }
    }

    public boolean isMax() {
        return true;
    }

    // Reward
    @Override
    protected Class<? extends Yodo1MasRewardAdapterBase> rewardAdapterClass() {
        return Yodo1MasAppLovinMaxRewardAdapter.class;
    }

    @Override
    public Yodo1MasRewardAdapterBase getRewardAdapter() {
        Yodo1MasAppLovinMaxRewardAdapter adapter = (Yodo1MasAppLovinMaxRewardAdapter) super.getRewardAdapter();
        adapter.setRevenueListener(revenueListener);
        return adapter;
    }

    // Interstitial
    @Override
    protected Class<? extends Yodo1MasInterstitialAdapterBase> interstitialAdapterClass() {
        return Yodo1MasAppLovinMaxInterstitialAdapter.class;
    }

    @Override
    public Yodo1MasInterstitialAdapterBase getInterstitialAdapter() {
        Yodo1MasAppLovinMaxInterstitialAdapter adapter = (Yodo1MasAppLovinMaxInterstitialAdapter) super.getInterstitialAdapter();
        adapter.setRevenueListener(revenueListener);
        return adapter;
    }

    // Native
    @Override
    public Class<? extends Yodo1MasNativeAdapterBase> nativeAdapterClass() {
        return Yodo1MasAppLovinMaxNativeAdapter.class;
    }

    @Override
    public Yodo1MasNativeAdapterBase getNativeAdapter() {
        Yodo1MasAppLovinMaxNativeAdapter adapter = (Yodo1MasAppLovinMaxNativeAdapter) super.getNativeAdapter();
        adapter.setRevenueListener(revenueListener);
        return adapter;
    }

    // Banner
    @Override
    public Class<? extends Yodo1MasBannerAdapterBase> bannerAdapterClass() {
        return Yodo1MasAppLovinMaxBannerAdapter.class;
    }

    @Override
    public Yodo1MasBannerAdapterBase getBannerAdapter() {
        Yodo1MasAppLovinMaxBannerAdapter adapter = (Yodo1MasAppLovinMaxBannerAdapter) super.getBannerAdapter();
        adapter.setRevenueListener(revenueListener);
        return adapter;
    }

    // Rewarded Interstitial
    @Override
    protected Class<? extends Yodo1MasRewardedInterstitialAdapterBase> rewardedInterstitialAdapterClass() {
        return null;
    }

    // App Open
    @Override
    protected Class<? extends Yodo1MasAppOpenAdapterBase> appOpenAdapterClass() {
        return null;
    }

}
