package com.yodo1.mas.mediation.applovin;

import android.app.Activity;

import androidx.annotation.NonNull;

import com.applovin.adview.AppLovinIncentivizedInterstitial;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdRewardListener;
import com.applovin.sdk.AppLovinAdVideoPlaybackListener;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;

import java.util.List;
import java.util.Map;

public class Yodo1MasAppLovinRewardAdapter extends Yodo1MasRewardAdapterBase {
    private final AppLovinAdLoadListener rewardLoadListener = new AppLovinAdLoadListener() {

        @Override
        public void adReceived(AppLovinAd appLovinAd) {
            String message = "method: adReceived, reward: " + appLovinAd.getAdIdNumber();
            Yodo1MasLog.v(TAG, message);
            callbackLoad();
        }

        @Override
        public void failedToReceiveAd(int code) {
            String message = "method: failedToReceiveAd, error: " + code;
            Yodo1MasLog.v(TAG, message);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            callbackError(error, code, message);
        }
    };
    private final AppLovinAdVideoPlaybackListener rewardPlayListener = new AppLovinAdVideoPlaybackListener() {
        @Override
        public void videoPlaybackBegan(AppLovinAd appLovinAd) {
            String message = "method: videoPlaybackBegan, reward: " + appLovinAd.getAdIdNumber();
            Yodo1MasLog.v(TAG, message);
        }

        @Override
        public void videoPlaybackEnded(AppLovinAd appLovinAd, double v, boolean b) {
            String message = "method: videoPlaybackEnded, reward: " + appLovinAd.getAdIdNumber();
            Yodo1MasLog.v(TAG, message);
            callbackEarned();
        }
    };
    private final AppLovinAdDisplayListener rewardDisplayListener = new AppLovinAdDisplayListener() {
        @Override
        public void adDisplayed(AppLovinAd appLovinAd) {
            String message = "method: adDisplayed, reward: " + appLovinAd.getAdIdNumber();
            Yodo1MasLog.v(TAG, message);
            callbackOpen();
        }

        @Override
        public void adHidden(AppLovinAd appLovinAd) {
            String message = "method: adHidden, reward: " + appLovinAd.getAdIdNumber();
            Yodo1MasLog.v(TAG, message);
            callbackClose();
        }
    };
    private final AppLovinAdClickListener rewardClickListener = appLovinAd -> {
        String message = "method: adClicked, reward: " + appLovinAd.getAdIdNumber();
        Yodo1MasLog.v(TAG, message);
        callbackClick();
    };
    private final AppLovinAdRewardListener rewardedListener = new AppLovinAdRewardListener() {
        @Override
        public void userRewardVerified(AppLovinAd appLovinAd, Map<String, String> map) {
            String message = "method: userRewardVerified, reward: " + appLovinAd.getAdIdNumber();
            Yodo1MasLog.v(TAG, message);
        }

        @Override
        public void userOverQuota(AppLovinAd appLovinAd, Map<String, String> map) {
            String message = "method: userOverQuota, reward: " + appLovinAd.getAdIdNumber();
            Yodo1MasLog.v(TAG, message);
        }

        @Override
        public void userRewardRejected(AppLovinAd appLovinAd, Map<String, String> map) {
            String message = "method: userRewardRejected, reward: " + appLovinAd.getAdIdNumber();
            Yodo1MasLog.v(TAG, message);
        }

        @Override
        public void validationRequestFailed(AppLovinAd appLovinAd, int i) {
            String message = "method: validationRequestFailed, reward: " + appLovinAd.getAdIdNumber();
            Yodo1MasLog.v(TAG, message);
        }
    };
    private AppLovinIncentivizedInterstitial rewardAd;

    public Yodo1MasAppLovinRewardAdapter(List<Yodo1MasAdapterBase.AdId> unitIds) {
        super(unitIds);
    }

    @Override
    public boolean isRewardAdLoaded() {
        return rewardAd != null && rewardAd.isAdReadyToDisplay();
    }

    @Override
    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);

        if (rewardStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) return;

        String message = "method: loadRewardAdvert, loading reward ad...";
        Yodo1MasLog.v(TAG, message);
        rewardStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        rewardAd = AppLovinIncentivizedInterstitial.create(activity);
        rewardAd.preload(rewardLoadListener);
    }

    @Override
    public void showRewardAdvertFromActivity(@NonNull Activity activity) {
        super.showRewardAdvertFromActivity(activity);
        if (isRewardAdLoaded()) {
            String message = "method: showRewardAdvert, show reward ad...";
            Yodo1MasLog.v(TAG, message);
            rewardAd.show(activity, rewardedListener, rewardPlayListener, rewardDisplayListener, rewardClickListener);
        }
    }
}
