/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.applovin;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxAdListener;
import com.applovin.mediation.MaxAdRevenueListener;
import com.applovin.mediation.MaxError;
import com.applovin.mediation.ads.MaxAppOpenAd;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.appopenad.Yodo1MasAppOpenAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import java.util.List;

public class Yodo1MasApplovinMaxAppOpenAdapter
extends Yodo1MasAppOpenAdapterBase {
    private MaxAppOpenAd appOpenAd;
    private MaxAdRevenueListener revenueListener;
    private final MaxAdListener appOpenAdlListener = new MaxAdListener(){

        public void onAdLoaded(MaxAd ad) {
            String message = "method: onAdLoaded, appOpenAd, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d((String)Yodo1MasApplovinMaxAppOpenAdapter.this.TAG, (String)message);
            Yodo1MasApplovinMaxAppOpenAdapter.this.adSource = ad.getNetworkName();
            Yodo1MasApplovinMaxAppOpenAdapter.this.callbackLoad();
        }

        public void onAdDisplayed(MaxAd ad) {
            String message = "method: onAdDisplayed, appOpenAd, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d((String)Yodo1MasApplovinMaxAppOpenAdapter.this.TAG, (String)message);
            Yodo1MasApplovinMaxAppOpenAdapter.this.adSource = ad.getNetworkName();
            Yodo1MasApplovinMaxAppOpenAdapter.this.callbackOpen();
        }

        public void onAdHidden(MaxAd ad) {
            String message = "method: onAdHidden, appOpenAd, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d((String)Yodo1MasApplovinMaxAppOpenAdapter.this.TAG, (String)message);
            Yodo1MasApplovinMaxAppOpenAdapter.this.adSource = ad.getNetworkName();
            Yodo1MasApplovinMaxAppOpenAdapter.this.callbackClose();
        }

        public void onAdClicked(MaxAd ad) {
            String message = "method: onAdClicked, appOpenAd, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d((String)Yodo1MasApplovinMaxAppOpenAdapter.this.TAG, (String)message);
            Yodo1MasApplovinMaxAppOpenAdapter.this.adSource = ad.getNetworkName();
            Yodo1MasApplovinMaxAppOpenAdapter.this.callbackClick();
        }

        public void onAdLoadFailed(String adUnitId, MaxError error) {
            String message = "method: onAdLoadFailed, appOpenAd, AdUnitId: " + adUnitId + ", error: " + error.getWaterfall();
            Yodo1MasLog.d((String)Yodo1MasApplovinMaxAppOpenAdapter.this.TAG, (String)message);
            Yodo1MasError yodo1MasError = new Yodo1MasError(-600202, Yodo1MasApplovinMaxAppOpenAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasApplovinMaxAppOpenAdapter.this.callbackError(yodo1MasError, error.getCode(), error.getMessage());
        }

        public void onAdDisplayFailed(MaxAd ad, MaxError error) {
            String message = "method: onAdDisplayFailed, appOpenAd, AdUnitId: " + ad.getAdUnitId() + ", error: " + error.getWaterfall();
            Yodo1MasLog.d((String)Yodo1MasApplovinMaxAppOpenAdapter.this.TAG, (String)message);
            Yodo1MasError yodo1MasError = new Yodo1MasError(-600201, Yodo1MasApplovinMaxAppOpenAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasApplovinMaxAppOpenAdapter.this.callbackError(yodo1MasError, error.getCode(), error.getMessage());
        }
    };

    public Yodo1MasApplovinMaxAppOpenAdapter(List<Yodo1MasAdapterBase.AdId> unitIds) {
        super(unitIds);
    }

    public boolean isAppOpenAdLoaded() {
        return this.appOpenAd != null && this.appOpenAd.isReady();
    }

    public void loadAppOpenAdvert(Activity activity) {
        super.loadAppOpenAdvert(activity);
        String adId = this.getAdUnitId(false);
        if (TextUtils.isEmpty((CharSequence)adId)) {
            return;
        }
        if (this.appOpenStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) {
            return;
        }
        String message = "method: loadAppOpenAdvert, loading AppOpen ad...";
        Yodo1MasLog.d((String)this.TAG, (String)message);
        this.trackLoadTime();
        this.appOpenStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        this.appOpenAd = new MaxAppOpenAd(adId, (Context)activity);
        this.appOpenAd.setListener(this.appOpenAdlListener);
        if (this.revenueListener != null) {
            this.appOpenAd.setRevenueListener(this.revenueListener);
        }
        this.appOpenAd.loadAd();
    }

    public void showAppOpenAdvertFromActivity(Activity activity) {
        super.showAppOpenAdvertFromActivity(activity);
        if (this.isAppOpenAdLoaded()) {
            String message = "method: showAppOpenAdvert, show appOpen ad...";
            Yodo1MasLog.d((String)this.TAG, (String)message);
            if (!TextUtils.isEmpty((CharSequence)this.appOpenPlacement)) {
                this.appOpenAd.showAd(this.appOpenPlacement);
            } else {
                this.appOpenAd.showAd();
            }
        }
    }

    public void destroy() {
        super.destroy();
        if (this.appOpenAd != null) {
            this.appOpenAd.destroy();
        }
        this.appOpenAd = null;
    }

    public void setRevenueListener(MaxAdRevenueListener revenueListener) {
        this.revenueListener = revenueListener;
    }
}

