package com.yodo1.mas.mediation.applovin;

import android.app.Activity;
import android.text.TextUtils;

import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxAdListener;
import com.applovin.mediation.MaxAdRevenueListener;
import com.applovin.mediation.MaxError;
import com.applovin.mediation.ads.MaxAppOpenAd;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.appopenad.Yodo1MasAppOpenAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;

import java.util.List;

public class Yodo1MasApplovinMaxAppOpenAdapter extends Yodo1MasAppOpenAdapterBase {

    private MaxAppOpenAd appOpenAd;
    private MaxAdRevenueListener revenueListener;
    private Yodo1MasMaxAdRecordListener adRecordListener;

    private final MaxAdListener appOpenAdlListener = new MaxAdListener() {

        @Override
        public void onAdLoaded(MaxAd ad) {
            String message = "method: onAdLoaded, appOpenAd, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d(TAG, message);
            adSource = ad.getNetworkName();
            callbackLoad();
        }

        @Override
        public void onAdDisplayed(MaxAd ad) {
            String message = "method: onAdDisplayed, appOpenAd, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d(TAG, message);
            adSource = ad.getNetworkName();
            callbackOpen();
            if(adRecordListener != null) {
                adRecordListener.onAdDisplayed(Yodo1Mas.AdType.AppOpen, ad);
            }
        }

        @Override
        public void onAdHidden(MaxAd ad) {
            String message = "method: onAdHidden, appOpenAd, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d(TAG, message);
            adSource = ad.getNetworkName();
            callbackClose();
        }

        @Override
        public void onAdClicked(MaxAd ad) {
            String message = "method: onAdClicked, appOpenAd, AdUnitId: " + ad.getAdUnitId() + ", NetworkName: " + ad.getNetworkName();
            Yodo1MasLog.d(TAG, message);
            adSource = ad.getNetworkName();
            callbackClick();
        }

        @Override
        public void onAdLoadFailed(String adUnitId, MaxError error) {
            String message = "method: onAdLoadFailed, appOpenAd, AdUnitId: " + adUnitId + ", error: " + error.getWaterfall();
            Yodo1MasLog.d(TAG, message);
            Yodo1MasError yodo1MasError = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            callbackError(yodo1MasError, error.getCode(), error.getMessage());
        }

        @Override
        public void onAdDisplayFailed(MaxAd ad, MaxError error) {
            String message = "method: onAdDisplayFailed, appOpenAd, AdUnitId: " + ad.getAdUnitId() + ", error: " + error.getWaterfall();
            Yodo1MasLog.d(TAG, message);
            Yodo1MasError yodo1MasError = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_SHOW_FAIL, TAG + ":{" + message + "}");
            callbackError(yodo1MasError, error.getCode(), error.getMessage());
        }
    };

    public Yodo1MasApplovinMaxAppOpenAdapter(List<Yodo1MasAdapterBase.AdId> unitIds) {
        super(unitIds);
    }

    @Override
    public boolean isAppOpenAdLoaded() {
        return appOpenAd != null && appOpenAd.isReady();
    }

    @Override
    public void loadAppOpenAdvert(Activity activity) {
        super.loadAppOpenAdvert(activity);
        String adId = getAdUnitId(false);
        if (TextUtils.isEmpty(adId)) return;
        if (appOpenStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) return;
        String message = "method: loadAppOpenAdvert, loading AppOpen ad...";
        Yodo1MasLog.d(TAG, message);
        trackLoadTime();

        appOpenStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        appOpenAd = new MaxAppOpenAd( adId, activity);
        appOpenAd.setListener(appOpenAdlListener);
        if (this.revenueListener != null) {
            appOpenAd.setRevenueListener(revenueListener);
        }
        appOpenAd.loadAd();
    }

    @Override
    public void showAppOpenAdvertFromActivity(Activity activity) {
        super.showAppOpenAdvertFromActivity(activity);
        if (isAppOpenAdLoaded()) {
            String message = "method: showAppOpenAdvert, show appOpen ad...";
            Yodo1MasLog.d(TAG, message);

            if (!TextUtils.isEmpty(appOpenPlacement)) {
                appOpenAd.showAd(appOpenPlacement);
            } else {
                appOpenAd.showAd();
            }
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (appOpenAd != null) {
            appOpenAd.destroy();
        }
        appOpenAd = null;
    }

    public void setRevenueListener(MaxAdRevenueListener revenueListener) {
        this.revenueListener = revenueListener;
    }

    public void setAdRecordListener(Yodo1MasMaxAdRecordListener adRecordListener) {
        this.adRecordListener = adRecordListener;
    }
}
