package com.yodo1.mas.mediation.applovin;

import android.os.Bundle;
import android.text.TextUtils;

import com.applovin.mediation.MaxAdWaterfallInfo;
import com.applovin.mediation.MaxError;
import com.applovin.mediation.MaxMediatedNetworkInfo;
import com.applovin.mediation.MaxNetworkResponseInfo;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.analytics.Yodo1MasDataAnalytics;
import com.yodo1.mas.analytics.model.Yodo1MasAdRequestResultInfo;
import com.yodo1.mas.helper.model.Yodo1MasNetworkMediationAdapter;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Yodo1MasAppLovinMaxUtil {

    private static final Map<String, String> mappingMap = getNetworkNameMapping();

    private static Map<String, String> getNetworkNameMapping() {
        Map<String, String> map = new HashMap<>();
        map.put("AdMob", "admob");
        map.put("Google Ad Manager", "gam_google");
        map.put("AppLovin", "applovin");
        map.put("Facebook", "facebook");
        map.put("Fyber", "fyber");
        map.put("InMobi", "inmobi");
        map.put("ironSource", "ironsource");
        map.put("Mintegral", "mintegral");
        map.put("myTarget", "mytarget");
        map.put("Pangle", "pangle");
        map.put("Tapjoy", "tapjoy");
        map.put("Unity Ads", "unity");
        map.put("Vungle", "vungle");
        map.put("Yandex", "yandex");
        map.put("Kidoz", "kidoz");
        map.put("Amazon Publisher Services", "amazon");
        map.put("CustomSDK", "amazon"); // curently we have only amazon as a CustomSDK in MAX

        return map;
    }

    public static String getAmazonUnitId(Yodo1MasAdapterBase.AdId adIdObj) {
        String amazonUnitId = null;
        if(adIdObj != null && adIdObj.object instanceof Yodo1MasNetworkMediationAdapter) {
            Yodo1MasNetworkMediationAdapter amazon = (Yodo1MasNetworkMediationAdapter) adIdObj.object;
            amazonUnitId = amazon.unit_id;
        }
        return amazonUnitId;
    }

    public static Yodo1MasAdRequestResultInfo getAdRequestResult(
            Yodo1Mas.AdType adType, String mediationName, String unitId, boolean isAdLoaded,
            long duration, MaxAdWaterfallInfo maxWaterfallInfo, String adErrorCode, String adErrorMessage) {
//        if(waterfallInfo == null) {
//            return null;
//        }

        Yodo1MasAdRequestResultInfo result = new Yodo1MasAdRequestResultInfo();
        result.isMaxMediation = true;
        result.mediationName = mediationName;
        result.adType = adType;
        result.adResult = isAdLoaded ? Yodo1MasDataAnalytics.AdResult.SUCCESS.name : Yodo1MasDataAnalytics.AdResult.FAIL.name;
        result.adDuration = duration;
        result.adCurrentMediation = mediationName;
        result.mediationUnitId = unitId;
        result.adErrorCode = adErrorCode;
        result.adErrorMessage = adErrorMessage;

        List<MaxNetworkResponseInfo> maxInfofoList = (maxWaterfallInfo != null) ? maxWaterfallInfo.getNetworkResponses() : null;
        if(maxInfofoList != null && maxInfofoList.size() > 0) {
            List<Yodo1MasAdRequestResultInfo.Yodo1MasWaterfallInfo> waterfallInfoList = new ArrayList<>();

            for(MaxNetworkResponseInfo maxInfo : maxInfofoList){
//                printMAXAdLoadResultInfo(maxInfo);
                MaxNetworkResponseInfo.AdLoadState adLoadState = maxInfo.getAdLoadState();
                if(adLoadState == MaxNetworkResponseInfo.AdLoadState.AD_LOAD_NOT_ATTEMPTED) {
                    continue;
                }

                if(adLoadState == MaxNetworkResponseInfo.AdLoadState.AD_LOADED) {
                    result.adCurrentSource = formatMaxNetworkName(getMAXNetworkAdapterName(maxInfo));
                }

                Yodo1MasAdRequestResultInfo.Yodo1MasWaterfallInfo info = new Yodo1MasAdRequestResultInfo.Yodo1MasWaterfallInfo();
                info.adNetwork = formatMaxNetworkName(getMAXNetworkAdapterName(maxInfo));
                info.placement_id = getMAXNetworkAdapterPlacementId(maxInfo);
                info.duration = maxInfo.getLatencyMillis();
                info.result = (adLoadState == MaxNetworkResponseInfo.AdLoadState.AD_LOADED) ? Yodo1MasDataAnalytics.AdResult.SUCCESS.name : Yodo1MasDataAnalytics.AdResult.FAIL.name;
                MaxError maxError = maxInfo.getError();
                if(maxError != null) {
                    info.errorCode = maxError.getCode() + "";
                    info.errorMessage = maxError.getMessage();
                }
                info.mediation = mediationName;
                waterfallInfoList.add(info);
            }
            result.waterfallInfoList = waterfallInfoList;
        }

        return result;
    }

    private static String formatMaxNetworkName(String maxNetworkAdapterName) {
        if(TextUtils.isEmpty(maxNetworkAdapterName)) {
            return maxNetworkAdapterName;
        }

        maxNetworkAdapterName = maxNetworkAdapterName.trim();
        if(maxNetworkAdapterName.endsWith("Native")) {
            maxNetworkAdapterName = maxNetworkAdapterName.replace("Native", "").trim();
        }

        if (mappingMap.containsKey(maxNetworkAdapterName)) {
            return mappingMap.get(maxNetworkAdapterName);
        }
        else {
            return maxNetworkAdapterName;
        }

    }

    private static String getMAXNetworkAdapterName(MaxNetworkResponseInfo networkResponse) {
        if (networkResponse == null) return null;

        MaxMediatedNetworkInfo networkInfo = networkResponse.getMediatedNetwork();
        String maxNetworkAdapterName = networkInfo != null ? networkInfo.getName() : null;
        if (TextUtils.isEmpty(maxNetworkAdapterName)) {
            Bundle credentials = networkResponse.getCredentials();
            if (credentials != null && credentials.containsKey("network_name")) {
                maxNetworkAdapterName = credentials.getString("network_name");
            }
        }
        return maxNetworkAdapterName;
    }

    private static String getMAXNetworkAdapterPlacementId(MaxNetworkResponseInfo networkResponse) {
        if (networkResponse == null) return null;

        Bundle credentials = networkResponse.getCredentials();
        if (credentials != null && credentials.containsKey("placement_id")) {
            return credentials.getString("placement_id");
        }
        return null;
    }

    private static void printMAXAdLoadResultInfo(MaxNetworkResponseInfo networkResponse) {
        if (networkResponse == null) return;

        String waterfallInfoStr = "Network name -> " + networkResponse.getMediatedNetwork().getName()
                + "  " + networkResponse.getMediatedNetwork().getAdapterClassName();
//                + "\n...adLoadState: " + networkResponse.getAdLoadState();
//                + "\n...latency: " + networkResponse.getLatencyMillis() + " milliseconds"
//                + "\n...credentials: " + networkResponse.getCredentials();
//        if (networkResponse.getError() != null) {
//            waterfallInfoStr += "\n...error: " + networkResponse.getError();
//        }
        Yodo1MasLog.d("Yodo1MasAppLovinMaxUtil", "printMAXAdLoadResultInfo: " + waterfallInfoStr);
    }
}
