package com.yodo1.mas.mediation.facebook;

import android.app.Activity;
import android.text.TextUtils;
import android.view.View;

import androidx.annotation.NonNull;

import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdListener;
import com.facebook.ads.AdSize;
import com.facebook.ads.AdView;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.banner.Yodo1MasBannerAdSize;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.event.Yodo1MasAdEvent;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;

import java.util.List;

public class Yodo1MasFacebookBannerAdapter extends Yodo1MasBannerAdapterBase {

    private final AdListener bannerListener = new AdListener() {
        @Override
        public void onError(Ad ad, AdError adError) {
            String message = "method: onError, banner: " + ad.getPlacementId() + ", error: " + adError.getErrorMessage();
            Yodo1MasLog.d(TAG, message);
            trackAdRequestFailed(adError.getErrorCode(), adError.getErrorMessage());
            bannerState = Yodo1MasAdapterBase.AdvertState.NONE;

            if (isLastPlacement()) {
                Yodo1MasError error = new Yodo1MasError(adError == AdError.SHOW_CALLED_BEFORE_LOAD_ERROR ? Yodo1MasError.CODE_ADVERT_SHOW_FAIL : Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
                if (Yodo1MasError.CODE_ADVERT_LOAD_FAIL == error.getCode()) {
                    callback(error);
                } else if (Yodo1MasError.CODE_ADVERT_SHOW_FAIL == error.getCode()) {
                    callbackDisplayError(error, adError.getErrorCode(), adError.getErrorMessage());
                }
                advertAdapterState = AdvertAdapterState.FAILED;
                callbackAdapterState();
            } else {
                nextBanner();
                loadBannerAdvertDelayed();
            }
        }

        @Override
        public void onAdLoaded(Ad ad) {
            String message = "method: onAdLoaded, banner: " + ad.getPlacementId();
            Yodo1MasLog.d(TAG, message);
            bannerState = Yodo1MasAdapterBase.AdvertState.LOADED;
            trackAdRequestSuccessed();
            callback(Yodo1MasAdEvent.CODE_LOADED, TAG + ":{" + message + "}");

            advertAdapterState = AdvertAdapterState.LOADED;
            callbackAdapterState();
        }

        @Override
        public void onAdClicked(Ad ad) {
            String message = "method: onAdClicked, banner: " + ad.getPlacementId();
            Yodo1MasLog.d(TAG, message);
        }

        @Override
        public void onLoggingImpression(Ad ad) {
            String message = "method: onLoggingImpression, banner: " + ad.getPlacementId();
            Yodo1MasLog.d(TAG, message);
            callback(Yodo1MasAdEvent.CODE_OPENED, TAG + ":{" + message + "}");
        }
    };
    private AdView bannerAd;

    public Yodo1MasFacebookBannerAdapter(List<Yodo1MasAdapterBase.AdId> adIds) {
        super(adIds);
    }

    @Override
    public boolean isBannerAdvertLoaded() {
        super.isBannerAdvertLoaded();
        return bannerAd != null && !bannerAd.isAdInvalidated() && getBannerAdId() != null && bannerState == Yodo1MasAdapterBase.AdvertState.LOADED;
    }

    @Override
    public void loadBannerAdvert(@NonNull Activity activity) {
        super.loadBannerAdvert(activity);
        if (relateAdapter == null || !relateAdapter.isInitSDK()) {
            return;
        }

        Yodo1MasAdapterBase.AdId adId = getBannerAdId();
        if (adId != null && !TextUtils.isEmpty(adId.adId) && (bannerAd == null || !bannerAd.getPlacementId().equals(adId.adId))) {
            AdSize bannerSize = getBannerSize();
            bannerAd = new AdView(activity, adId.adId, bannerSize);
        }
        if (bannerAd != null && bannerState != Yodo1MasAdapterBase.AdvertState.LOADING) {
            String message = "method: loadBannerAdvert, loading banner ad...";
            Yodo1MasLog.d(TAG, message);
            bannerAd.loadAd(bannerAd.buildLoadAdConfig().withAdListener(bannerListener).build());
            bannerState = Yodo1MasAdapterBase.AdvertState.LOADING;
            advertAdapterState = AdvertAdapterState.LOADING;
            logAdIdInfo(adId);
        }
    }

    private AdSize getBannerSize() {
        Yodo1MasBannerAdSize size = bannerConfig.size;
        Yodo1MasLog.d(TAG, "setBannerSize: size: " + size.name());

        if (Yodo1MasBannerAdSize.Banner == size) {
            return AdSize.BANNER_320_50;
        }
//        else if(Yodo1MasBannerAdSize.IABMediumRectangle == size) {
//            return AdSize.RECTANGLE_HEIGHT_250;
//        }

        return AdSize.BANNER_320_50;
    }

    @Override
    public View getBannerView() {
        return bannerAd;
    }

    @Override
    public void dismissBannerAdvert(boolean destroy) {
        super.dismissBannerAdvert(destroy);
        if (bannerAd != null) {
            if (destroy) {
                bannerAd.destroy();
                bannerAd = null;
                bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
                advertAdapterState = AdvertAdapterState.NONE;
            }
        }
    }

    @Override
    public boolean isSupportMultipleInstance() {
        return true;
    }
}
