/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.facebook;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.RewardedVideoAd;
import com.facebook.ads.RewardedVideoAdListener;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.analytics.model.Yodo1MasAdRequestResultInfo;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import com.yodo1.mas.utils.Yodo1MasAdRequestTrackUtil;

public class Yodo1MasFacebookRewardAdapter
extends Yodo1MasRewardAdapterBase {
    private final RewardedVideoAdListener rewardListener = new RewardedVideoAdListener(){

        public void onAdLoaded(Ad ad) {
            String message = "method: onAdLoaded, reward: " + ad.getPlacementId();
            Yodo1MasLog.d((String)Yodo1MasFacebookRewardAdapter.this.TAG, (String)message);
            Yodo1MasAdRequestResultInfo adRequestResult = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult((Yodo1Mas.AdType)Yodo1Mas.AdType.Reward, (String)Yodo1MasFacebookRewardAdapter.this.advertCode, (String)ad.getPlacementId(), (boolean)true, (long)Yodo1MasFacebookRewardAdapter.this.getAdLoadDuration(), null, null);
            Yodo1MasFacebookRewardAdapter.this.callbackLoad(adRequestResult);
        }

        public void onError(Ad ad, AdError adError) {
            String message = "method: onError, reward: " + ad.getPlacementId() + ", error: " + adError.getErrorMessage();
            Yodo1MasLog.d((String)Yodo1MasFacebookRewardAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasFacebookRewardAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasAdRequestResultInfo adRequestResult = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult((Yodo1Mas.AdType)Yodo1Mas.AdType.Reward, (String)Yodo1MasFacebookRewardAdapter.this.advertCode, (String)ad.getPlacementId(), (boolean)false, (long)Yodo1MasFacebookRewardAdapter.this.getAdLoadDuration(), (String)(adError.getErrorCode() + ""), (String)adError.getErrorMessage());
            Yodo1MasFacebookRewardAdapter.this.callbackError(error, adError.getErrorCode(), adError.getErrorMessage(), adRequestResult);
        }

        public void onRewardedVideoClosed() {
            String message = "method: onRewardedVideoClosed";
            Yodo1MasLog.d((String)Yodo1MasFacebookRewardAdapter.this.TAG, (String)message);
            Yodo1MasFacebookRewardAdapter.this.callbackClose();
        }

        public void onRewardedVideoCompleted() {
            String message = "method: onRewardedVideoCompleted";
            Yodo1MasLog.d((String)Yodo1MasFacebookRewardAdapter.this.TAG, (String)message);
            Yodo1MasFacebookRewardAdapter.this.callbackEarned();
        }

        public void onAdClicked(Ad ad) {
            String message = "method: onAdClicked, reward: " + ad.getPlacementId();
            Yodo1MasLog.d((String)Yodo1MasFacebookRewardAdapter.this.TAG, (String)message);
            Yodo1MasFacebookRewardAdapter.this.callbackClick();
        }

        public void onLoggingImpression(Ad ad) {
            String message = "method: onLoggingImpression, reward: " + ad.getPlacementId();
            Yodo1MasLog.d((String)Yodo1MasFacebookRewardAdapter.this.TAG, (String)message);
            Yodo1MasFacebookRewardAdapter.this.callbackOpen();
        }
    };
    private RewardedVideoAd rewardAd;

    public Yodo1MasFacebookRewardAdapter(Yodo1MasAdapterBase.AdId unitId) {
        super(unitId);
    }

    public boolean isRewardAdLoaded() {
        return this.rewardAd != null && this.rewardAd.isAdLoaded();
    }

    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);
        String adId = this.getAdUnitId();
        if (TextUtils.isEmpty((CharSequence)adId)) {
            return;
        }
        if (this.rewardStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) {
            return;
        }
        String message = "method: loadRewardAdvert, loading reward ad...";
        Yodo1MasLog.d((String)this.TAG, (String)message);
        this.rewardStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        this.adLoadStartTimeStamp = System.currentTimeMillis();
        this.rewardAd = new RewardedVideoAd((Context)activity, adId);
        this.rewardAd.loadAd(this.rewardAd.buildLoadAdConfig().withAdListener(this.rewardListener).build());
    }

    public void showRewardAdvertFromActivity(@NonNull Activity activity) {
        super.showRewardAdvertFromActivity(activity);
        if (this.isRewardAdLoaded()) {
            String message = "method: showRewardAdvert, show reward ad...";
            Yodo1MasLog.d((String)this.TAG, (String)message);
            this.rewardAd.show();
            this.callbackOpen();
        }
    }

    public void destroy() {
        super.destroy();
        if (this.rewardAd != null) {
            this.rewardAd.destroy();
        }
        this.rewardAd = null;
    }
}

