package com.yodo1.mas.mediation.facebook;

import android.app.Activity;
import android.text.TextUtils;

import androidx.annotation.NonNull;

import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.RewardedVideoAd;
import com.facebook.ads.RewardedVideoAdListener;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.analytics.model.Yodo1MasAdRequestResultInfo;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import com.yodo1.mas.utils.Yodo1MasAdRequestTrackUtil;

public class Yodo1MasFacebookRewardAdapter extends Yodo1MasRewardAdapterBase {

    private final RewardedVideoAdListener rewardListener = new RewardedVideoAdListener() {
        @Override
        public void onAdLoaded(Ad ad) {
            String message = "method: onAdLoaded, reward: " + ad.getPlacementId();
            Yodo1MasLog.d(TAG, message);
            adRequestResult
                    = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult(Yodo1Mas.AdType.Reward
                    , advertCode, ad.getPlacementId(), true, getAdLoadDuration(), null, null);
            callbackLoad(adRequestResult);
        }

        @Override
        public void onError(Ad ad, AdError adError) {
            String message = "method: onError, reward: " + ad.getPlacementId() + ", error: " + adError.getErrorMessage();
            Yodo1MasLog.d(TAG, message);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            adRequestResult
                    = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult(Yodo1Mas.AdType.Reward
                    , advertCode, ad.getPlacementId(), false, getAdLoadDuration(), adError.getErrorCode() + "", adError.getErrorMessage());
            callbackError(error, adError.getErrorCode(), adError.getErrorMessage(), adRequestResult);
        }

        @Override
        public void onRewardedVideoClosed() {
            String message = "method: onRewardedVideoClosed";
            Yodo1MasLog.d(TAG, message);
            callbackClose();
        }

        @Override
        public void onRewardedVideoCompleted() {
            String message = "method: onRewardedVideoCompleted";
            Yodo1MasLog.d(TAG, message);
            callbackEarned();
        }

        @Override
        public void onAdClicked(Ad ad) {
            String message = "method: onAdClicked, reward: " + ad.getPlacementId();
            Yodo1MasLog.d(TAG, message);
            callbackClick();
        }

        @Override
        public void onLoggingImpression(Ad ad) {
            String message = "method: onLoggingImpression, reward: " + ad.getPlacementId();
            Yodo1MasLog.d(TAG, message);
            callbackOpen();
        }
    };
    private RewardedVideoAd rewardAd;

    public Yodo1MasFacebookRewardAdapter(Yodo1MasAdapterBase.AdId unitId) {
        super(unitId);
    }

    @Override
    public boolean isRewardAdLoaded() {
        return rewardAd != null && rewardAd.isAdLoaded();
    }

    @Override
    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);
        String adId = getAdUnitId();
        if (TextUtils.isEmpty(adId)) return;
        if (rewardStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) return;

        String message = "method: loadRewardAdvert, loading reward ad...";
        Yodo1MasLog.d(TAG, message);

        rewardStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        adLoadStartTimeStamp = System.currentTimeMillis();
        rewardAd = new RewardedVideoAd(activity, adId);
        rewardAd.loadAd(rewardAd.buildLoadAdConfig().withAdListener(rewardListener).build());
    }

    @Override
    public void showRewardAdvertFromActivity(@NonNull Activity activity) {
        super.showRewardAdvertFromActivity(activity);
        if (isRewardAdLoaded()) {
            String message = "method: showRewardAdvert, show reward ad...";
            Yodo1MasLog.d(TAG, message);
            rewardAd.show();
            callbackOpen();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (rewardAd != null) {
            rewardAd.destroy();
        }
        rewardAd = null;
    }
}
