/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.facebook;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdListener;
import com.facebook.ads.AdSettings;
import com.facebook.ads.AdSize;
import com.facebook.ads.AdView;
import com.facebook.ads.AudienceNetworkAds;
import com.facebook.ads.InterstitialAd;
import com.facebook.ads.InterstitialAdListener;
import com.facebook.ads.RewardedVideoAd;
import com.facebook.ads.RewardedVideoAdListener;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.analytics.Yodo1MasSensorHelper;
import com.yodo1.mas.banner.Yodo1MasBannerAdSize;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.helper.Yodo1MasBanner;
import com.yodo1.mas.helper.Yodo1MasHelper;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import org.json.JSONObject;

public class Yodo1MasFacebookAdapter
extends Yodo1MasAdapterBase {
    private RewardedVideoAd rewardAd;
    private InterstitialAd interstitialAd;
    private AdView bannerAd;
    private final RewardedVideoAdListener rewardListener = new RewardedVideoAdListener(){

        public void onAdLoaded(Ad ad) {
            String message = "method: onAdLoaded, reward: " + ad.getPlacementId();
            Log.d((String)Yodo1MasFacebookAdapter.this.TAG, (String)message);
            Yodo1MasFacebookAdapter.this.trackAdRequest(Yodo1Mas.AdType.Reward, Yodo1MasSensorHelper.AdResult.SUCCESS);
        }

        public void onError(Ad ad, AdError adError) {
            String message = "method: onError, reward: " + ad.getPlacementId() + ", error: " + adError.getErrorMessage();
            Log.d((String)Yodo1MasFacebookAdapter.this.TAG, (String)message);
            Yodo1MasFacebookAdapter.this.trackAdRequest(Yodo1Mas.AdType.Reward, Yodo1MasSensorHelper.AdResult.FAIL);
            Yodo1MasError error = new Yodo1MasError(-600201, Yodo1MasFacebookAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasFacebookAdapter.this.callback(error, Yodo1Mas.AdType.Reward);
            Yodo1MasFacebookAdapter.this.nextReward();
            Yodo1MasFacebookAdapter.this.loadRewardAdvertDelayed();
        }

        public void onAdClicked(Ad ad) {
            String message = "method: onAdClicked, reward: " + ad.getPlacementId();
            Log.d((String)Yodo1MasFacebookAdapter.this.TAG, (String)message);
        }

        public void onRewardedVideoCompleted() {
            String message = "method: onRewardedVideoCompleted";
            Log.d((String)Yodo1MasFacebookAdapter.this.TAG, (String)message);
            Yodo1MasFacebookAdapter.this.callback(2001, Yodo1Mas.AdType.Reward, Yodo1MasFacebookAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasFacebookAdapter.this.loadRewardAdvert();
        }

        public void onLoggingImpression(Ad ad) {
            String message = "method: onLoggingImpression, reward: " + ad.getPlacementId();
            Log.d((String)Yodo1MasFacebookAdapter.this.TAG, (String)message);
            Yodo1MasFacebookAdapter.this.callback(1001, Yodo1Mas.AdType.Reward, Yodo1MasFacebookAdapter.this.TAG + ":{" + message + "}");
        }

        public void onRewardedVideoClosed() {
            String message = "method: onRewardedVideoClosed";
            Log.d((String)Yodo1MasFacebookAdapter.this.TAG, (String)message);
            Yodo1MasFacebookAdapter.this.callback(1002, Yodo1Mas.AdType.Reward, Yodo1MasFacebookAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasFacebookAdapter.this.loadRewardAdvert();
        }
    };
    private final InterstitialAdListener interstitialListener = new InterstitialAdListener(){

        public void onInterstitialDisplayed(Ad ad) {
            String message = "method: onInterstitialDisplayed, interstitial: " + ad.getPlacementId();
            Log.d((String)Yodo1MasFacebookAdapter.this.TAG, (String)message);
            Yodo1MasFacebookAdapter.this.callback(1001, Yodo1Mas.AdType.Interstitial, Yodo1MasFacebookAdapter.this.TAG + ":{" + message + "}");
        }

        public void onInterstitialDismissed(Ad ad) {
            String message = "method: onInterstitialDismissed, interstitial: " + ad.getPlacementId();
            Log.d((String)Yodo1MasFacebookAdapter.this.TAG, (String)message);
            Yodo1MasFacebookAdapter.this.callback(1002, Yodo1Mas.AdType.Interstitial, Yodo1MasFacebookAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasFacebookAdapter.this.loadInterstitialAdvert();
        }

        public void onError(Ad ad, AdError adError) {
            String message = "method: onError, interstitial: " + ad.getPlacementId() + ", error: " + adError.getErrorMessage();
            Log.d((String)Yodo1MasFacebookAdapter.this.TAG, (String)message);
            Yodo1MasFacebookAdapter.this.trackAdRequest(Yodo1Mas.AdType.Interstitial, Yodo1MasSensorHelper.AdResult.FAIL);
            Yodo1MasError error = new Yodo1MasError(-600201, Yodo1MasFacebookAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasFacebookAdapter.this.callback(error, Yodo1Mas.AdType.Interstitial);
            Yodo1MasFacebookAdapter.this.nextInterstitial();
            Yodo1MasFacebookAdapter.this.loadInterstitialAdvertDelayed();
        }

        public void onAdLoaded(Ad ad) {
            String message = "method: onAdLoaded, interstitial: " + ad.getPlacementId();
            Log.d((String)Yodo1MasFacebookAdapter.this.TAG, (String)message);
            Yodo1MasFacebookAdapter.this.trackAdRequest(Yodo1Mas.AdType.Interstitial, Yodo1MasSensorHelper.AdResult.SUCCESS);
        }

        public void onAdClicked(Ad ad) {
            String message = "method: onAdClicked, interstitial: " + ad.getPlacementId();
            Log.d((String)Yodo1MasFacebookAdapter.this.TAG, (String)message);
        }

        public void onLoggingImpression(Ad ad) {
            String message = "method: onLoggingImpression, interstitial: " + ad.getPlacementId();
            Log.d((String)Yodo1MasFacebookAdapter.this.TAG, (String)message);
        }
    };
    private final AdListener bannerListener = new AdListener(){

        public void onError(Ad ad, AdError adError) {
            String message = "method: onError, banner: " + ad.getPlacementId() + ", error: " + adError.getErrorMessage();
            Log.d((String)Yodo1MasFacebookAdapter.this.TAG, (String)message);
            Yodo1MasFacebookAdapter.this.trackAdRequest(Yodo1Mas.AdType.Banner, Yodo1MasSensorHelper.AdResult.FAIL);
            Yodo1MasError error = new Yodo1MasError(adError == AdError.SHOW_CALLED_BEFORE_LOAD_ERROR ? -600201 : -600202, Yodo1MasFacebookAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasFacebookAdapter.this.callback(error, Yodo1Mas.AdType.Banner);
            Yodo1MasFacebookAdapter.this.nextBanner();
            Yodo1MasFacebookAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            Yodo1MasFacebookAdapter.this.loadBannerAdvertDelayed();
        }

        public void onAdLoaded(Ad ad) {
            String message = "method: onAdLoaded, banner: " + ad.getPlacementId();
            Log.d((String)Yodo1MasFacebookAdapter.this.TAG, (String)message);
            Yodo1MasFacebookAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.LOADED;
            Yodo1MasFacebookAdapter.this.trackAdRequest(Yodo1Mas.AdType.Banner, Yodo1MasSensorHelper.AdResult.SUCCESS);
            Yodo1MasFacebookAdapter.this.callback(1003, Yodo1Mas.AdType.Banner, Yodo1MasFacebookAdapter.this.TAG + ":{" + message + "}");
        }

        public void onAdClicked(Ad ad) {
            String message = "method: onAdClicked, banner: " + ad.getPlacementId();
            Log.d((String)Yodo1MasFacebookAdapter.this.TAG, (String)message);
        }

        public void onLoggingImpression(Ad ad) {
            String message = "method: onLoggingImpression, banner: " + ad.getPlacementId();
            Log.d((String)Yodo1MasFacebookAdapter.this.TAG, (String)message);
            Yodo1MasFacebookAdapter.this.callback(1001, Yodo1Mas.AdType.Banner, Yodo1MasFacebookAdapter.this.TAG + ":{" + message + "}");
        }
    };

    public String getAdvertCode() {
        return "facebook";
    }

    public String getSDKVersion() {
        return "6.7.0";
    }

    public String getMediationVersion() {
        return "4.4.0";
    }

    public void initSDK(@NonNull Activity activity, @NonNull Yodo1MasAdapterBase.Config config, @Nullable Yodo1MasAdapterBase.InitCallback callback) {
        super.initSDK(activity, config, callback);
        if (!this.isInitSDK()) {
            this.init = true;
            if (Yodo1MasHelper.getInstance().isDebug()) {
                AdSettings.turnOnSDKDebugger((Context)this.applicationContext);
            }
            if (!AudienceNetworkAds.isInitialized((Context)this.applicationContext)) {
                AudienceNetworkAds.buildInitSettings((Context)this.applicationContext).withInitListener(result -> {
                    String message = "method: onInitialized, result: " + result;
                    Log.d((String)this.TAG, (String)message);
                    if (result.isSuccess()) {
                        this.updatePrivacy();
                        this.loadRewardAdvert();
                        this.loadInterstitialAdvert();
                        if (callback != null) {
                            callback.onAdapterInitSuccessful(this.getAdvertCode());
                        }
                    } else if (callback != null) {
                        callback.onAdapterInitFailed(this.getAdvertCode(), new Yodo1MasError(-600001, result.getMessage()));
                    }
                }).initialize();
            }
        } else if (callback != null) {
            callback.onAdapterInitSuccessful(this.getAdvertCode());
        }
    }

    public boolean isInitSDK() {
        return super.isInitSDK() && AudienceNetworkAds.isInitialized((Context)this.applicationContext);
    }

    public void updatePrivacy() {
        super.updatePrivacy();
        Yodo1MasFacebookAdapter.setFacebookPrivacy();
    }

    public static void setFacebookPrivacy() {
        AdSettings.setMixedAudience((boolean)Yodo1MasHelper.getInstance().isCOPPAAgeRestricted());
    }

    public boolean isRewardAdvertLoaded() {
        super.isRewardAdvertLoaded();
        return this.rewardAd != null && this.rewardAd.isAdLoaded();
    }

    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);
        if (!this.isInitSDK()) {
            return;
        }
        Yodo1MasAdapterBase.AdId adId = this.getRewardAdId();
        if (!(adId == null || TextUtils.isEmpty((CharSequence)adId.adId) || this.rewardAd != null && this.rewardAd.getPlacementId().equals(adId.adId))) {
            this.rewardAd = new RewardedVideoAd((Context)activity, adId.adId);
        }
        if (this.rewardAd != null) {
            String message = "method: loadRewardAdvert, loading reward ad...";
            Log.d((String)this.TAG, (String)message);
            this.rewardAd.loadAd(this.rewardAd.buildLoadAdConfig().withAdListener(this.rewardListener).build());
        }
    }

    public void showRewardAdvert(@NonNull Activity activity, @Nullable JSONObject object, @Nullable Yodo1MasAdapterBase.AdvertCallback callback) {
        super.showRewardAdvert(activity, object, callback);
        if (this.isCanShow(Yodo1Mas.AdType.Reward, callback)) {
            String message = "method: showRewardAdvert, show reward ad...";
            Log.d((String)this.TAG, (String)message);
            this.rewardAd.show();
        }
    }

    public void dismissRewardAdvert() {
        super.dismissRewardAdvert();
        if (this.rewardAd != null) {
            this.rewardAd.destroy();
        }
        this.rewardAd = null;
    }

    public boolean isInterstitialAdvertLoaded() {
        super.isInterstitialAdvertLoaded();
        return this.interstitialAd != null && this.interstitialAd.isAdLoaded();
    }

    public void loadInterstitialAdvert(@NonNull Activity activity) {
        super.loadInterstitialAdvert(activity);
        if (!this.isInitSDK()) {
            return;
        }
        Yodo1MasAdapterBase.AdId adId = this.getInterstitialAdId();
        if (!(adId == null || TextUtils.isEmpty((CharSequence)adId.adId) || this.interstitialAd != null && this.interstitialAd.getPlacementId().equals(adId.adId))) {
            this.interstitialAd = new InterstitialAd((Context)activity, adId.adId);
        }
        if (this.interstitialAd != null) {
            String message = "method: loadInterstitialAdvert, loading interstitial ad...";
            Log.d((String)this.TAG, (String)message);
            this.interstitialAd.loadAd(this.interstitialAd.buildLoadAdConfig().withAdListener(this.interstitialListener).build());
        }
    }

    public void showInterstitialAdvert(@NonNull Activity activity, @Nullable JSONObject object, @Nullable Yodo1MasAdapterBase.AdvertCallback callback) {
        super.showInterstitialAdvert(activity, object, callback);
        if (this.isCanShow(Yodo1Mas.AdType.Interstitial, callback)) {
            String message = "method: showInterstitialAdvert, show interstitial ad...";
            Log.d((String)this.TAG, (String)message);
            this.interstitialAd.show();
        }
    }

    public void dismissInterstitialAdvert() {
        super.dismissInterstitialAdvert();
        if (this.interstitialAd != null) {
            this.interstitialAd.destroy();
        }
        this.interstitialAd = null;
    }

    public boolean isBannerAdvertLoaded() {
        super.isBannerAdvertLoaded();
        return this.bannerAd != null && !this.bannerAd.isAdInvalidated() && this.getBannerAdId() != null && this.bannerState == Yodo1MasAdapterBase.AdvertState.LOADED;
    }

    public void loadBannerAdvert(@NonNull Activity activity) {
        super.loadBannerAdvert(activity);
        if (!this.isInitSDK()) {
            return;
        }
        Yodo1MasAdapterBase.AdId adId = this.getBannerAdId();
        if (!(adId == null || TextUtils.isEmpty((CharSequence)adId.adId) || this.bannerAd != null && this.bannerAd.getPlacementId().equals(adId.adId))) {
            AdSize bannerSize = this.getBannerSize();
            this.bannerAd = new AdView((Context)activity, adId.adId, bannerSize);
        }
        if (this.bannerAd != null && this.bannerState != Yodo1MasAdapterBase.AdvertState.LOADING) {
            String message = "method: loadBannerAdvert, loading banner ad...";
            Log.d((String)this.TAG, (String)message);
            this.bannerAd.loadAd(this.bannerAd.buildLoadAdConfig().withAdListener(this.bannerListener).build());
            this.bannerState = Yodo1MasAdapterBase.AdvertState.LOADING;
        }
    }

    private AdSize getBannerSize() {
        Yodo1MasBannerAdSize size = this.bannerConfig.size;
        Log.d((String)this.TAG, (String)("setBannerSize: size: " + size.name()));
        if (Yodo1MasBannerAdSize.Banner == size) {
            return AdSize.BANNER_320_50;
        }
        return AdSize.BANNER_320_50;
    }

    public void showBannerAdvert(@NonNull Activity activity, @Nullable JSONObject object, @Nullable Yodo1MasAdapterBase.AdvertCallback callback) {
        super.showBannerAdvert(activity, object, callback);
        if (this.isCanShow(Yodo1Mas.AdType.Banner, callback)) {
            String message = "method: showBannerAdvert, show banner ad...";
            Log.d((String)this.TAG, (String)message);
            Yodo1MasBanner.showBanner((Activity)activity, (View)this.bannerAd, (JSONObject)object);
        }
    }

    public View getBannerView() {
        return this.bannerAd;
    }

    public void dismissBannerAdvert(boolean destroy) {
        super.dismissBannerAdvert(destroy);
        if (this.bannerAd != null && destroy) {
            this.bannerAd.destroy();
            this.bannerAd = null;
            this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
        }
    }
}

