/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.facebook;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import androidx.annotation.NonNull;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdListener;
import com.facebook.ads.AdSize;
import com.facebook.ads.AdView;
import com.yodo1.mas.banner.Yodo1MasBannerAdSize;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasBannerAdapterBase;

public class Yodo1MasFacebookBannerAdapter
extends Yodo1MasBannerAdapterBase {
    private final AdListener bannerListener = new AdListener(){

        public void onError(Ad ad, AdError adError) {
            String message = "method: onError, banner: " + ad.getPlacementId() + ", error: " + adError.getErrorMessage();
            Log.d((String)Yodo1MasFacebookBannerAdapter.this.TAG, (String)message);
            Yodo1MasFacebookBannerAdapter.this.trackAdRequestFailed(adError.getErrorCode(), adError.getErrorMessage());
            Yodo1MasFacebookBannerAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            if (Yodo1MasFacebookBannerAdapter.this.isLastPlacement()) {
                Yodo1MasError error = new Yodo1MasError(adError == AdError.SHOW_CALLED_BEFORE_LOAD_ERROR ? -600201 : -600202, Yodo1MasFacebookBannerAdapter.this.TAG + ":{" + message + "}");
                if (-600202 == error.getCode()) {
                    Yodo1MasFacebookBannerAdapter.this.callback(error);
                } else if (-600201 == error.getCode()) {
                    Yodo1MasFacebookBannerAdapter.this.callbackDisplayError(error, adError.getErrorCode(), adError.getErrorMessage());
                }
                Yodo1MasFacebookBannerAdapter.this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.FAILED;
                Yodo1MasFacebookBannerAdapter.this.callbackAdapterState();
            } else {
                Yodo1MasFacebookBannerAdapter.this.nextBanner();
                Yodo1MasFacebookBannerAdapter.this.loadBannerAdvertDelayed();
            }
        }

        public void onAdLoaded(Ad ad) {
            String message = "method: onAdLoaded, banner: " + ad.getPlacementId();
            Log.d((String)Yodo1MasFacebookBannerAdapter.this.TAG, (String)message);
            Yodo1MasFacebookBannerAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.LOADED;
            Yodo1MasFacebookBannerAdapter.this.trackAdRequestSuccessed();
            Yodo1MasFacebookBannerAdapter.this.callback(1003, Yodo1MasFacebookBannerAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasFacebookBannerAdapter.this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.LOADED;
            Yodo1MasFacebookBannerAdapter.this.callbackAdapterState();
        }

        public void onAdClicked(Ad ad) {
            String message = "method: onAdClicked, banner: " + ad.getPlacementId();
            Log.d((String)Yodo1MasFacebookBannerAdapter.this.TAG, (String)message);
        }

        public void onLoggingImpression(Ad ad) {
            String message = "method: onLoggingImpression, banner: " + ad.getPlacementId();
            Log.d((String)Yodo1MasFacebookBannerAdapter.this.TAG, (String)message);
            Yodo1MasFacebookBannerAdapter.this.callback(1001, Yodo1MasFacebookBannerAdapter.this.TAG + ":{" + message + "}");
        }
    };
    private AdView bannerAd;

    public boolean isBannerAdvertLoaded() {
        super.isBannerAdvertLoaded();
        return this.bannerAd != null && !this.bannerAd.isAdInvalidated() && this.getBannerAdId() != null && this.bannerState == Yodo1MasAdapterBase.AdvertState.LOADED;
    }

    public void loadBannerAdvert(@NonNull Activity activity) {
        super.loadBannerAdvert(activity);
        if (this.relateAdapter == null || !this.relateAdapter.isInitSDK()) {
            return;
        }
        Yodo1MasAdapterBase.AdId adId = this.getBannerAdId();
        if (!(adId == null || TextUtils.isEmpty((CharSequence)adId.adId) || this.bannerAd != null && this.bannerAd.getPlacementId().equals(adId.adId))) {
            AdSize bannerSize = this.getBannerSize();
            this.bannerAd = new AdView((Context)activity, adId.adId, bannerSize);
        }
        if (this.bannerAd != null && this.bannerState != Yodo1MasAdapterBase.AdvertState.LOADING) {
            String message = "method: loadBannerAdvert, loading banner ad...";
            Log.d((String)this.TAG, (String)message);
            this.bannerAd.loadAd(this.bannerAd.buildLoadAdConfig().withAdListener(this.bannerListener).build());
            this.bannerState = Yodo1MasAdapterBase.AdvertState.LOADING;
            this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.LOADING;
            this.logAdIdInfo(adId);
        }
    }

    private AdSize getBannerSize() {
        Yodo1MasBannerAdSize size = this.bannerConfig.size;
        Log.d((String)this.TAG, (String)("setBannerSize: size: " + size.name()));
        if (Yodo1MasBannerAdSize.Banner == size) {
            return AdSize.BANNER_320_50;
        }
        return AdSize.BANNER_320_50;
    }

    public View getBannerView() {
        return this.bannerAd;
    }

    public void dismissBannerAdvert(boolean destroy) {
        super.dismissBannerAdvert(destroy);
        if (this.bannerAd != null && destroy) {
            this.bannerAd.destroy();
            this.bannerAd = null;
            this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.NONE;
        }
    }

    public boolean isSupportMultipleInstance() {
        return true;
    }
}

