package com.yodo1.mas.mediation.facebook;

import android.app.Activity;
import android.text.TextUtils;
import android.util.Log;

import androidx.annotation.NonNull;

import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.RewardedVideoAd;
import com.facebook.ads.RewardedVideoAdListener;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;

import java.util.List;

public class Yodo1MasFacebookRewardAdapter extends Yodo1MasRewardAdapterBase {

    private RewardedVideoAd rewardAd;

    public Yodo1MasFacebookRewardAdapter(List<Yodo1MasAdapterBase.AdId> unitIds) {
        super(unitIds);
    }

    @Override
    public boolean isRewardAdLoaded() {
        return rewardAd != null && rewardAd.isAdLoaded();
    }

    @Override
    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);
        String adId = getAdUnitId(false);
        if (TextUtils.isEmpty(adId)) return;
        if (rewardStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) return;

        String message = "method: loadRewardAdvert, loading reward ad...";
        Log.d(TAG, message);

        rewardStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        rewardAd = new RewardedVideoAd(activity, adId);
        rewardAd.loadAd(rewardAd.buildLoadAdConfig().withAdListener(rewardListener).build());
    }

    @Override
    public void showRewardAdvertFromActivity(@NonNull Activity activity) {
        super.showRewardAdvertFromActivity(activity);
        if (isRewardAdLoaded()) {
            String message = "method: showRewardAdvert, show reward ad...";
            Log.d(TAG, message);
            rewardAd.show();
            callbackOpen();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (rewardAd != null) {
            rewardAd.destroy();
        }
        rewardAd = null;
    }

    private final RewardedVideoAdListener rewardListener = new RewardedVideoAdListener() {
        @Override
        public void onAdLoaded(Ad ad) {
            String message = "method: onAdLoaded, reward: " + ad.getPlacementId();
            Log.d(TAG, message);
            callbackLoad();
        }

        @Override
        public void onError(Ad ad, AdError adError) {
            String message = "method: onError, reward: " + ad.getPlacementId() + ", error: " + adError.getErrorMessage();
            Log.d(TAG, message);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            callbackError(error, adError.getErrorCode(), adError.getErrorMessage());
        }

        @Override
        public void onRewardedVideoClosed() {
            String message = "method: onRewardedVideoClosed";
            Log.d(TAG, message);
            callbackClose();
        }

        @Override
        public void onRewardedVideoCompleted() {
            String message = "method: onRewardedVideoCompleted";
            Log.d(TAG, message);
            callbackEarned();
        }

        @Override
        public void onAdClicked(Ad ad) {
            String message = "method: onAdClicked, reward: " + ad.getPlacementId();
            Log.d(TAG, message);
            callbackClick();
        }

        @Override
        public void onLoggingImpression(Ad ad) {
            String message = "method: onLoggingImpression, reward: " + ad.getPlacementId();
            Log.d(TAG, message);
            callbackOpen();
        }
    };
}
