package com.yodo1.mas.mediation.facebook;

import android.app.Activity;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.facebook.ads.AdSettings;
import com.facebook.ads.AudienceNetworkAds;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.appopenad.Yodo1MasAppOpenAdapterBase;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.helper.Yodo1MasHelper;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.nativeads.Yodo1MasNativeAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import com.yodo1.mas.rewardedinterstitial.Yodo1MasRewardedInterstitialAdapterBase;

public class Yodo1MasFacebookAdapter extends Yodo1MasAdapterBase {

    public static void setFacebookPrivacy() {
        AdSettings.setMixedAudience(Yodo1MasHelper.getInstance().isCOPPAAgeRestricted());
    }

    @Override
    public String getAdvertCode() {
        return "facebook";
    }

    @Override
    public String getSDKVersion() {
        return BuildConfig.SDK_VERSION_NAME;
    }

    @Override
    public String getMediationVersion() {
        return BuildConfig.MAS_VERSION_NAME;
    }

    @Override
    public void initSDK(@NonNull Activity activity, @NonNull Config config, @Nullable InitCallback callback) {
        super.initSDK(activity, config, callback);
        if (!isInitSDK()) {
            init = true;
            if (Yodo1MasHelper.getInstance().isDebug()) {
                AdSettings.turnOnSDKDebugger(applicationContext);
            }
            if (!AudienceNetworkAds.isInitialized(applicationContext)) {
                AudienceNetworkAds.buildInitSettings(applicationContext).withInitListener(result -> {
                    String message = "method: onInitialized, result: " + result;
                    Yodo1MasLog.v(TAG, message);

                    if (result.isSuccess()) {
                        updatePrivacy();

                        if (callback != null) {
                            callback.onAdapterInitSuccessful(getAdvertCode());
                        }
                    } else {
                        if (callback != null) {
                            callback.onAdapterInitFailed(getAdvertCode(), new Yodo1MasError(Yodo1MasError.CODE_ADVERT_UNINITIALIZED, result.getMessage()));
                        }
                    }
                }).initialize();
            }
        } else {
            if (callback != null) {
                callback.onAdapterInitSuccessful(getAdvertCode());
            }
        }
    }

    @Override
    public boolean isInitSDK() {
        return super.isInitSDK() && AudienceNetworkAds.isInitialized(applicationContext);
    }

    @Override
    public void updatePrivacy() {
        super.updatePrivacy();
        setFacebookPrivacy();
    }

    // Reward
    @Override
    protected Class<? extends Yodo1MasRewardAdapterBase> rewardAdapterClass() {
        return Yodo1MasFacebookRewardAdapter.class;
    }

    // Interstitial
    @Override
    protected Class<? extends Yodo1MasInterstitialAdapterBase> interstitialAdapterClass() {
        return Yodo1MasFacebookInterstitialAdapter.class;
    }

    // Native
    @Override
    public Class<? extends Yodo1MasNativeAdapterBase> nativeAdapterClass() {
        return null;
    }

    // Banner
    @Override
    public Class<? extends Yodo1MasBannerAdapterBase> bannerAdapterClass() {
        return Yodo1MasFacebookBannerAdapter.class;
    }

    // Rewarded Interstitial
    @Override
    protected Class<? extends Yodo1MasRewardedInterstitialAdapterBase> rewardedInterstitialAdapterClass() {
        return null;
    }

    // App Open
    @Override
    protected Class<? extends Yodo1MasAppOpenAdapterBase> appOpenAdapterClass() {
        return null;
    }

}
