package com.yodo1.mas.mediation.facebook;

import android.app.Activity;
import android.text.TextUtils;

import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.InterstitialAd;
import com.facebook.ads.InterstitialAdListener;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;

import java.util.List;

public class Yodo1MasFacebookInterstitialAdapter extends Yodo1MasInterstitialAdapterBase {

    private final InterstitialAdListener interstitialListener = new InterstitialAdListener() {
        @Override
        public void onAdLoaded(Ad ad) {
            String message = "method: onAdLoaded, interstitial: " + ad.getPlacementId();
            Yodo1MasLog.v(TAG, message);
            callbackLoad();
        }

        @Override
        public void onError(Ad ad, AdError adError) {
            String message = "method: onError, interstitial: " + ad.getPlacementId() + ", error: " + adError.getErrorMessage();
            Yodo1MasLog.v(TAG, message);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            callbackError(error, adError.getErrorCode(), adError.getErrorMessage());
        }

        @Override
        public void onInterstitialDisplayed(Ad ad) {
            String message = "method: onInterstitialDisplayed, interstitial: " + ad.getPlacementId();
            Yodo1MasLog.v(TAG, message);
            callbackOpen();
        }

        @Override
        public void onInterstitialDismissed(Ad ad) {
            String message = "method: onInterstitialDismissed, interstitial: " + ad.getPlacementId();
            Yodo1MasLog.v(TAG, message);
            callbackClose();
        }

        @Override
        public void onAdClicked(Ad ad) {
            String message = "method: onAdClicked, interstitial: " + ad.getPlacementId();
            Yodo1MasLog.v(TAG, message);
            callbackClick();
        }

        @Override
        public void onLoggingImpression(Ad ad) {
            String message = "method: onLoggingImpression, interstitial: " + ad.getPlacementId();
            Yodo1MasLog.v(TAG, message);
        }
    };
    private InterstitialAd interstitialAd;

    public Yodo1MasFacebookInterstitialAdapter(List<Yodo1MasAdapterBase.AdId> unitIds) {
        super(unitIds);
    }

    @Override
    public boolean isInterstitialAdLoaded() {
        return interstitialAd != null && interstitialAd.isAdLoaded();
    }

    @Override
    public void loadInterstitialAdvert(Activity activity) {
        super.loadInterstitialAdvert(activity);
        String adId = getAdUnitId(false);
        if (TextUtils.isEmpty(adId)) return;
        if (interstitialStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) return;
        String message = "method: loadInterstitialAdvert, loading interstitial ad...";
        Yodo1MasLog.v(TAG, message);

        interstitialStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        interstitialAd = new InterstitialAd(activity, adId);
        interstitialAd.loadAd(interstitialAd.buildLoadAdConfig().withAdListener(interstitialListener).build());
    }

    @Override
    public void showInterstitialAdvertFromActivity(Activity activity) {
        super.showInterstitialAdvertFromActivity(activity);
        if (isInterstitialAdLoaded()) {
            String message = "method: showInterstitialAdvert, show interstitial ad...";
            Yodo1MasLog.v(TAG, message);
            interstitialAd.show();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (interstitialAd != null) {
            interstitialAd.destroy();
        }
        interstitialAd = null;
    }
}
