/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.facebook;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.InterstitialAd;
import com.facebook.ads.InterstitialAdListener;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import java.util.List;

public class Yodo1MasFacebookInterstitialAdapter
extends Yodo1MasInterstitialAdapterBase {
    private final InterstitialAdListener interstitialListener = new InterstitialAdListener(){

        public void onAdLoaded(Ad ad) {
            String message = "method: onAdLoaded, interstitial: " + ad.getPlacementId();
            Yodo1MasLog.d((String)Yodo1MasFacebookInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasFacebookInterstitialAdapter.this.callbackLoad();
        }

        public void onError(Ad ad, AdError adError) {
            String message = "method: onError, interstitial: " + ad.getPlacementId() + ", error: " + adError.getErrorMessage();
            Yodo1MasLog.d((String)Yodo1MasFacebookInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasFacebookInterstitialAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasFacebookInterstitialAdapter.this.callbackError(error, adError.getErrorCode(), adError.getErrorMessage());
        }

        public void onInterstitialDisplayed(Ad ad) {
            String message = "method: onInterstitialDisplayed, interstitial: " + ad.getPlacementId();
            Yodo1MasLog.d((String)Yodo1MasFacebookInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasFacebookInterstitialAdapter.this.callbackOpen();
        }

        public void onInterstitialDismissed(Ad ad) {
            String message = "method: onInterstitialDismissed, interstitial: " + ad.getPlacementId();
            Yodo1MasLog.d((String)Yodo1MasFacebookInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasFacebookInterstitialAdapter.this.callbackClose();
        }

        public void onAdClicked(Ad ad) {
            String message = "method: onAdClicked, interstitial: " + ad.getPlacementId();
            Yodo1MasLog.d((String)Yodo1MasFacebookInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasFacebookInterstitialAdapter.this.callbackClick();
        }

        public void onLoggingImpression(Ad ad) {
            String message = "method: onLoggingImpression, interstitial: " + ad.getPlacementId();
            Yodo1MasLog.d((String)Yodo1MasFacebookInterstitialAdapter.this.TAG, (String)message);
        }
    };
    private InterstitialAd interstitialAd;

    public Yodo1MasFacebookInterstitialAdapter(List<Yodo1MasAdapterBase.AdId> unitIds) {
        super(unitIds);
    }

    public boolean isInterstitialAdLoaded() {
        return this.interstitialAd != null && this.interstitialAd.isAdLoaded();
    }

    public void loadInterstitialAdvert(Activity activity) {
        super.loadInterstitialAdvert(activity);
        String adId = this.getAdUnitId(false);
        if (TextUtils.isEmpty((CharSequence)adId)) {
            return;
        }
        if (this.interstitialStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) {
            return;
        }
        String message = "method: loadInterstitialAdvert, loading interstitial ad...";
        Yodo1MasLog.d((String)this.TAG, (String)message);
        this.interstitialStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        this.interstitialAd = new InterstitialAd((Context)activity, adId);
        this.interstitialAd.loadAd(this.interstitialAd.buildLoadAdConfig().withAdListener(this.interstitialListener).build());
    }

    public void showInterstitialAdvertFromActivity(Activity activity) {
        super.showInterstitialAdvertFromActivity(activity);
        if (this.isInterstitialAdLoaded()) {
            String message = "method: showInterstitialAdvert, show interstitial ad...";
            Yodo1MasLog.d((String)this.TAG, (String)message);
            this.interstitialAd.show();
        }
    }

    public void destroy() {
        super.destroy();
        if (this.interstitialAd != null) {
            this.interstitialAd.destroy();
        }
        this.interstitialAd = null;
    }
}

