/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.fyber;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.fyber.inneractive.sdk.external.InneractiveAdManager;
import com.fyber.inneractive.sdk.external.InneractiveAdRequest;
import com.fyber.inneractive.sdk.external.InneractiveAdSpot;
import com.fyber.inneractive.sdk.external.InneractiveAdSpotManager;
import com.fyber.inneractive.sdk.external.InneractiveAdViewEventsListener;
import com.fyber.inneractive.sdk.external.InneractiveAdViewUnitController;
import com.fyber.inneractive.sdk.external.InneractiveErrorCode;
import com.fyber.inneractive.sdk.external.InneractiveFullscreenAdEventsListener;
import com.fyber.inneractive.sdk.external.InneractiveFullscreenUnitController;
import com.fyber.inneractive.sdk.external.InneractiveUnitController;
import com.fyber.inneractive.sdk.external.OnFyberMarketplaceInitializedListener;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.helper.Yodo1MasBanner;
import com.yodo1.mas.helper.Yodo1MasHelper;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import org.json.JSONObject;

public class Yodo1MasFyberAdapter
extends Yodo1MasAdapterBase {
    private InneractiveAdSpot rewardAd;
    private InneractiveAdSpot interstitialAd;
    private InneractiveAdSpot bannerAd;
    private ViewGroup mBannerWrapperView;
    private Yodo1MasAdapterBase.AdvertState rewardState = Yodo1MasAdapterBase.AdvertState.NONE;
    private Yodo1MasAdapterBase.AdvertState interstitialState = Yodo1MasAdapterBase.AdvertState.NONE;
    private final InneractiveAdSpot.RequestListener rewardListener = new InneractiveAdSpot.RequestListener(){

        public void onInneractiveSuccessfulAdRequest(InneractiveAdSpot inneractiveAdSpot) {
            String message = "method: onInneractiveSuccessfulAdRequest, reward: ";
            Log.d((String)Yodo1MasFyberAdapter.this.TAG, (String)message);
            Yodo1MasFyberAdapter.this.rewardState = Yodo1MasAdapterBase.AdvertState.LOADED;
            InneractiveFullscreenUnitController controller = (InneractiveFullscreenUnitController)Yodo1MasFyberAdapter.this.rewardAd.getSelectedUnitController();
            controller.setRewardedListener(inneractiveAdSpot1 -> {
                String message1 = "method: onAdRewarded, reward: ";
                Log.d((String)Yodo1MasFyberAdapter.this.TAG, (String)message1);
                Yodo1MasFyberAdapter.this.callback(2001, Yodo1Mas.AdType.Reward, Yodo1MasFyberAdapter.this.TAG + ":{" + message1 + "}");
            });
            controller.setEventsListener((InneractiveUnitController.EventsListener)new InneractiveFullscreenAdEventsListener(){

                public void onAdImpression(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdImpression, reward: ";
                    Log.d((String)Yodo1MasFyberAdapter.this.TAG, (String)message);
                    Yodo1MasFyberAdapter.this.callback(1001, Yodo1Mas.AdType.Reward, Yodo1MasFyberAdapter.this.TAG + ":{" + message + "}");
                }

                public void onAdClicked(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdClicked, reward: ";
                    Log.d((String)Yodo1MasFyberAdapter.this.TAG, (String)message);
                }

                public void onAdWillOpenExternalApp(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdWillOpenExternalApp, reward: ";
                    Log.d((String)Yodo1MasFyberAdapter.this.TAG, (String)message);
                }

                public void onAdEnteredErrorState(InneractiveAdSpot inneractiveAdSpot, InneractiveUnitController.AdDisplayError adDisplayError) {
                    String message = "method: onAdEnteredErrorState, reward: ";
                    Log.d((String)Yodo1MasFyberAdapter.this.TAG, (String)message);
                }

                public void onAdWillCloseInternalBrowser(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdWillCloseInternalBrowser, reward: ";
                    Log.d((String)Yodo1MasFyberAdapter.this.TAG, (String)message);
                }

                public void onAdDismissed(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdDismissed, reward: ";
                    Log.d((String)Yodo1MasFyberAdapter.this.TAG, (String)message);
                    Yodo1MasFyberAdapter.this.callback(1002, Yodo1Mas.AdType.Reward, Yodo1MasFyberAdapter.this.TAG + ":{" + message + "}");
                    Yodo1MasFyberAdapter.this.loadRewardAdvert();
                }
            });
        }

        public void onInneractiveFailedAdRequest(InneractiveAdSpot inneractiveAdSpot, InneractiveErrorCode inneractiveErrorCode) {
            String message = "method: onInneractiveFailedAdRequest, reward errorCode:" + inneractiveErrorCode.name();
            Log.d((String)Yodo1MasFyberAdapter.this.TAG, (String)message);
            Yodo1MasFyberAdapter.this.rewardState = Yodo1MasAdapterBase.AdvertState.NONE;
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasFyberAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasFyberAdapter.this.callback(error, Yodo1Mas.AdType.Reward);
            Yodo1MasFyberAdapter.this.nextReward();
            Yodo1MasFyberAdapter.this.loadRewardAdvertDelayed();
        }
    };
    private final InneractiveAdSpot.RequestListener interstitialListener = new InneractiveAdSpot.RequestListener(){

        public void onInneractiveSuccessfulAdRequest(InneractiveAdSpot inneractiveAdSpot) {
            String message = "method: onInneractiveSuccessfulAdRequest, interstitial: ";
            Log.d((String)Yodo1MasFyberAdapter.this.TAG, (String)message);
            Yodo1MasFyberAdapter.this.interstitialState = Yodo1MasAdapterBase.AdvertState.LOADED;
            InneractiveFullscreenUnitController controller = (InneractiveFullscreenUnitController)Yodo1MasFyberAdapter.this.interstitialAd.getSelectedUnitController();
            controller.setEventsListener((InneractiveUnitController.EventsListener)new InneractiveFullscreenAdEventsListener(){

                public void onAdImpression(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdImpression, interstitial: ";
                    Log.d((String)Yodo1MasFyberAdapter.this.TAG, (String)message);
                    Yodo1MasFyberAdapter.this.callback(1001, Yodo1Mas.AdType.Interstitial, Yodo1MasFyberAdapter.this.TAG + ":{" + message + "}");
                }

                public void onAdClicked(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdClicked, interstitial: ";
                    Log.d((String)Yodo1MasFyberAdapter.this.TAG, (String)message);
                }

                public void onAdWillOpenExternalApp(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdWillOpenExternalApp, interstitial: ";
                    Log.d((String)Yodo1MasFyberAdapter.this.TAG, (String)message);
                }

                public void onAdEnteredErrorState(InneractiveAdSpot inneractiveAdSpot, InneractiveUnitController.AdDisplayError adDisplayError) {
                    String message = "method: onAdEnteredErrorState, interstitial: ";
                    Log.d((String)Yodo1MasFyberAdapter.this.TAG, (String)message);
                }

                public void onAdWillCloseInternalBrowser(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdWillCloseInternalBrowser, interstitial: ";
                    Log.d((String)Yodo1MasFyberAdapter.this.TAG, (String)message);
                }

                public void onAdDismissed(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdWillCloseInternalBrowser, interstitial: ";
                    Log.d((String)Yodo1MasFyberAdapter.this.TAG, (String)message);
                    Yodo1MasFyberAdapter.this.callback(1002, Yodo1Mas.AdType.Interstitial, Yodo1MasFyberAdapter.this.TAG + ":{" + message + "}");
                    Yodo1MasFyberAdapter.this.loadInterstitialAdvert();
                }
            });
        }

        public void onInneractiveFailedAdRequest(InneractiveAdSpot inneractiveAdSpot, InneractiveErrorCode inneractiveErrorCode) {
            String message = "method: onInneractiveFailedAdRequest, interstitial: errorCode: " + inneractiveErrorCode.name();
            Log.d((String)Yodo1MasFyberAdapter.this.TAG, (String)message);
            Yodo1MasFyberAdapter.this.interstitialState = Yodo1MasAdapterBase.AdvertState.NONE;
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasFyberAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasFyberAdapter.this.callback(error, Yodo1Mas.AdType.Interstitial);
            Yodo1MasFyberAdapter.this.nextInterstitial();
            Yodo1MasFyberAdapter.this.loadInterstitialAdvertDelayed();
        }
    };
    private final InneractiveAdSpot.RequestListener bannerListener = new InneractiveAdSpot.RequestListener(){

        public void onInneractiveSuccessfulAdRequest(InneractiveAdSpot inneractiveAdSpot) {
            String message = "method: onInneractiveSuccessfulAdRequest, banner: ";
            Log.d((String)Yodo1MasFyberAdapter.this.TAG, (String)message);
            Yodo1MasFyberAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.LOADED;
            InneractiveAdViewUnitController controller = (InneractiveAdViewUnitController)Yodo1MasFyberAdapter.this.bannerAd.getSelectedUnitController();
            controller.setEventsListener((InneractiveUnitController.EventsListener)new InneractiveAdViewEventsListener(){

                public void onAdImpression(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onLoggingImpression, banner: ";
                    Log.d((String)Yodo1MasFyberAdapter.this.TAG, (String)message);
                    Yodo1MasFyberAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
                    Yodo1MasFyberAdapter.this.callback(1001, Yodo1Mas.AdType.Banner, Yodo1MasFyberAdapter.this.TAG + ":{" + message + "}");
                }

                public void onAdClicked(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdClicked, banner: ";
                    Log.d((String)Yodo1MasFyberAdapter.this.TAG, (String)message);
                }

                public void onAdWillCloseInternalBrowser(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdWillCloseInternalBrowser, banner: ";
                    Log.d((String)Yodo1MasFyberAdapter.this.TAG, (String)message);
                    Yodo1MasFyberAdapter.this.callback(1002, Yodo1Mas.AdType.Banner, Yodo1MasFyberAdapter.this.TAG + ":{" + message + "}");
                }

                public void onAdWillOpenExternalApp(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdWillOpenExternalApp, banner: ";
                    Log.d((String)Yodo1MasFyberAdapter.this.TAG, (String)message);
                }

                public void onAdEnteredErrorState(InneractiveAdSpot inneractiveAdSpot, InneractiveUnitController.AdDisplayError adDisplayError) {
                    String message = "method: onAdEnteredErrorState, banner: ";
                    Log.d((String)Yodo1MasFyberAdapter.this.TAG, (String)message);
                }

                public void onAdExpanded(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdExpanded, banner: ";
                    Log.d((String)Yodo1MasFyberAdapter.this.TAG, (String)message);
                }

                public void onAdResized(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdResized, banner: ";
                    Log.d((String)Yodo1MasFyberAdapter.this.TAG, (String)message);
                }

                public void onAdCollapsed(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdCollapsed, banner: ";
                    Log.d((String)Yodo1MasFyberAdapter.this.TAG, (String)message);
                }
            });
        }

        public void onInneractiveFailedAdRequest(InneractiveAdSpot inneractiveAdSpot, InneractiveErrorCode inneractiveErrorCode) {
            String message = "method: onInneractiveFailedAdRequest, errorcode: " + inneractiveErrorCode.name();
            Log.d((String)Yodo1MasFyberAdapter.this.TAG, (String)message);
            Yodo1MasFyberAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasFyberAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasFyberAdapter.this.callback(error, Yodo1Mas.AdType.Banner);
            Yodo1MasFyberAdapter.this.nextBanner();
            Yodo1MasFyberAdapter.this.loadBannerAdvertDelayed();
        }
    };

    public String getAdvertCode() {
        return "fyber";
    }

    public String getSDKVersion() {
        return "7.8.2";
    }

    public String getMediationVersion() {
        return "4.1.1";
    }

    public void initSDK(@NonNull Activity activity, @NonNull Yodo1MasAdapterBase.Config config, @Nullable Yodo1MasAdapterBase.InitCallback callback) {
        super.initSDK(activity, config, callback);
        if (this.isInitSDK()) {
            if (callback != null) {
                callback.onAdapterInitSuccessful(this.getAdvertCode());
            }
            return;
        }
        if (TextUtils.isEmpty((CharSequence)config.appId)) {
            if (callback != null) {
                callback.onAdapterInitFailed(this.getAdvertCode(), new Yodo1MasError(-600001, "config.appId is null"));
            }
            return;
        }
        this.init = true;
        InneractiveAdManager.initialize((Context)activity, (String)config.appId);
        InneractiveAdManager.initialize((Context)activity, (String)config.appId, status -> {
            String message = "method: onFyberMarketplaceInitialized, status: " + status.name();
            Log.d((String)this.TAG, (String)message);
            if (OnFyberMarketplaceInitializedListener.FyberInitStatus.SUCCESSFULLY == status) {
                this.updatePrivacy();
                this.loadRewardAdvert();
                this.loadInterstitialAdvert();
                this.loadBannerAdvert();
                if (callback != null) {
                    callback.onAdapterInitSuccessful(this.getAdvertCode());
                }
            }
        });
    }

    public void updatePrivacy() {
        super.updatePrivacy();
        InneractiveAdManager.setGdprConsent((boolean)Yodo1MasHelper.getInstance().isGDPRUserConsent());
        String ccpaContent = Yodo1MasHelper.getInstance().isCCPADoNotSell() ? "1YYN" : "1YNN";
        InneractiveAdManager.setUSPrivacyString((String)ccpaContent);
    }

    public boolean isRewardAdvertLoaded() {
        return this.rewardAd != null && this.rewardAd.isReady();
    }

    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);
        if (!this.isInitSDK()) {
            return;
        }
        if (this.rewardAd == null) {
            this.rewardAd = InneractiveAdSpotManager.get().createSpot();
            InneractiveFullscreenUnitController controller = new InneractiveFullscreenUnitController();
            this.rewardAd.addUnitController((InneractiveUnitController)controller);
            this.rewardAd.setRequestListener(this.rewardListener);
        }
        if (this.rewardAd != null && this.rewardState != Yodo1MasAdapterBase.AdvertState.LOADING) {
            String message = "method: loadRewardAdvert, loading reward ad...";
            Log.d((String)this.TAG, (String)message);
            InneractiveAdRequest adRequest = new InneractiveAdRequest("");
            this.rewardAd.requestAd(adRequest);
            this.rewardState = Yodo1MasAdapterBase.AdvertState.LOADING;
        }
    }

    public void showRewardAdvert(@NonNull Activity activity, @Nullable JSONObject object, @Nullable Yodo1MasAdapterBase.AdvertCallback callback) {
        super.showRewardAdvert(activity, object, callback);
        if (this.isCanShow(Yodo1Mas.AdType.Reward, callback)) {
            String message = "method: showRewardAdvert, show reward ad...";
            Log.d((String)this.TAG, (String)message);
            InneractiveFullscreenUnitController controller = (InneractiveFullscreenUnitController)this.rewardAd.getSelectedUnitController();
            controller.show((Context)activity);
            this.rewardState = Yodo1MasAdapterBase.AdvertState.NONE;
        }
    }

    public void dismissRewardAdvert() {
        super.dismissRewardAdvert();
        if (this.rewardAd != null) {
            this.rewardAd.destroy();
        }
        this.rewardAd = null;
    }

    public boolean isInterstitialAdvertLoaded() {
        return this.interstitialAd != null && this.interstitialAd.isReady();
    }

    public void loadInterstitialAdvert(@NonNull Activity activity) {
        super.loadInterstitialAdvert(activity);
        if (!this.isInitSDK()) {
            return;
        }
        if (this.interstitialAd == null) {
            this.interstitialAd = InneractiveAdSpotManager.get().createSpot();
            InneractiveFullscreenUnitController controller = new InneractiveFullscreenUnitController();
            this.interstitialAd.addUnitController((InneractiveUnitController)controller);
            this.interstitialAd.setRequestListener(this.interstitialListener);
        }
        if (this.interstitialAd != null && this.interstitialState != Yodo1MasAdapterBase.AdvertState.LOADING) {
            String message = "method: loadInterstitialAdvert, loading interstitial ad...";
            Log.d((String)this.TAG, (String)message);
            InneractiveAdRequest adRequest = new InneractiveAdRequest("");
            this.interstitialAd.requestAd(adRequest);
            this.interstitialState = Yodo1MasAdapterBase.AdvertState.LOADING;
        }
    }

    public void showInterstitialAdvert(@NonNull Activity activity, @Nullable JSONObject object, @Nullable Yodo1MasAdapterBase.AdvertCallback callback) {
        super.showInterstitialAdvert(activity, object, callback);
        if (this.isCanShow(Yodo1Mas.AdType.Interstitial, callback)) {
            String message = "method: showInterstitialAdvert, show interstitial ad...";
            Log.d((String)this.TAG, (String)message);
            InneractiveFullscreenUnitController controller = (InneractiveFullscreenUnitController)this.interstitialAd.getSelectedUnitController();
            controller.show((Context)activity);
            this.interstitialState = Yodo1MasAdapterBase.AdvertState.NONE;
        }
    }

    public void dismissInterstitialAdvert() {
        super.dismissInterstitialAdvert();
        if (this.interstitialAd != null) {
            this.interstitialAd.destroy();
        }
        this.interstitialAd = null;
    }

    public boolean isBannerAdvertLoaded() {
        return this.bannerAd != null && this.bannerAd.isReady();
    }

    public void loadBannerAdvert(@NonNull Activity activity) {
        super.loadBannerAdvert(activity);
        if (!this.isInitSDK()) {
            return;
        }
        if (this.bannerAd == null) {
            this.bannerAd = InneractiveAdSpotManager.get().createSpot();
            InneractiveAdViewUnitController controller = new InneractiveAdViewUnitController();
            this.bannerAd.addUnitController((InneractiveUnitController)controller);
            this.bannerAd.setRequestListener(this.bannerListener);
        }
        if (this.bannerAd != null && this.bannerState != Yodo1MasAdapterBase.AdvertState.LOADING) {
            String message = "method: loadBannerAdvert, loading banner ad...";
            Log.d((String)this.TAG, (String)message);
            InneractiveAdRequest adRequest = new InneractiveAdRequest("");
            this.bannerAd.requestAd(adRequest);
            this.bannerState = Yodo1MasAdapterBase.AdvertState.LOADING;
        }
    }

    public void showBannerAdvert(@NonNull Activity activity, @Nullable JSONObject object, @Nullable Yodo1MasAdapterBase.AdvertCallback callback) {
        super.showBannerAdvert(activity, object, callback);
        if (this.isCanShow(Yodo1Mas.AdType.Banner, callback)) {
            String message = "method: showBannerAdvert, show banner ad...";
            Log.d((String)this.TAG, (String)message);
            if (this.mBannerWrapperView == null) {
                this.mBannerWrapperView = new RelativeLayout((Context)activity);
                InneractiveAdViewUnitController controller = (InneractiveAdViewUnitController)this.bannerAd.getSelectedUnitController();
                controller.bindView(this.mBannerWrapperView);
            }
            if (this.mBannerWrapperView != null) {
                Yodo1MasBanner.showBanner((Activity)activity, (View)this.mBannerWrapperView, (JSONObject)object);
            }
        }
    }

    public void dismissBannerAdvert(boolean destroy) {
        super.dismissBannerAdvert(destroy);
        if (this.bannerAd != null) {
            if (this.mBannerWrapperView != null) {
                Yodo1MasBanner.removeBanner((View)this.mBannerWrapperView);
            }
            if (destroy) {
                this.bannerAd.destroy();
                this.bannerAd = null;
                this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
                this.loadBannerAdvert();
            }
        }
    }

    public void onActivityDestroy(@NonNull Activity activity) {
        super.onActivityDestroy(activity);
        if (this.bannerAd != null) {
            this.bannerAd.destroy();
        }
        InneractiveAdManager.destroy();
    }
}

