package com.yodo1.mas.mediation.fyber;

import android.app.Activity;
import android.text.TextUtils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.fyber.inneractive.sdk.external.InneractiveAdManager;
import com.fyber.inneractive.sdk.external.OnFyberMarketplaceInitializedListener;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.appopenad.Yodo1MasAppOpenAdapterBase;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.helper.Yodo1MasHelper;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.nativeads.Yodo1MasNativeAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import com.yodo1.mas.rewardedinterstitial.Yodo1MasRewardedInterstitialAdapterBase;

public class Yodo1MasFyberAdapter extends Yodo1MasAdapterBase {

    public static void setFyberPrivacy() {
        InneractiveAdManager.setGdprConsent(Yodo1MasHelper.getInstance().isGDPRUserConsent());
        String ccpaContent = Yodo1MasHelper.getInstance().isCCPADoNotSell() ? "1YYN" : "1YNN";
        InneractiveAdManager.setUSPrivacyString(ccpaContent);
    }

    @Override
    public String getAdvertCode() {
        return "fyber";
    }

    @Override
    public String networkName() {
        return "DT Exchange";
    }

    @Override
    public String getSDKVersion() {
        return BuildConfig.SDK_VERSION_NAME;
    }

    @Override
    public String getMediationVersion() {
        return BuildConfig.MAS_VERSION_NAME;
    }

    @Override
    public void initSDK(@NonNull Activity activity, @NonNull Config config, @Nullable InitCallback callback) {
        super.initSDK(activity, config, callback);
        if (isInitSDK()) {
            if (callback != null) {
                callback.onAdapterInitSuccessful(getAdvertCode());
            }
            return;
        }

        if (TextUtils.isEmpty(config.appId)) {
            if (callback != null) {
                callback.onAdapterInitFailed(getAdvertCode(), new Yodo1MasError(Yodo1MasError.CODE_ADVERT_UNINITIALIZED, "config.appId is null"));
            }
            return;
        }

        init = true;
        InneractiveAdManager.initialize(activity, config.appId);
        InneractiveAdManager.initialize(activity, config.appId, status -> {
            String message = "method: onFyberMarketplaceInitialized, status: " + status.name();
            Yodo1MasLog.d(TAG, message);
            if (OnFyberMarketplaceInitializedListener.FyberInitStatus.SUCCESSFULLY == status) {
                updatePrivacy();
                if (callback != null) {
                    callback.onAdapterInitSuccessful(getAdvertCode());
                }
            }
        });
    }

    @Override
    public void updatePrivacy() {
        super.updatePrivacy();
        setFyberPrivacy();
    }

    // Reward
    @Override
    public Class<? extends Yodo1MasRewardAdapterBase> rewardAdapterClass() {
        return Yodo1MasFyberRewardAdapter.class;
    }

    // Interstitial
    @Override
    public Class<? extends Yodo1MasInterstitialAdapterBase> interstitialAdapterClass() {
        return Yodo1MasFyberInterstitialAdapter.class;
    }

    // Native
    @Override
    public Class<? extends Yodo1MasNativeAdapterBase> nativeAdapterClass() {
        return null;
    }

    // Banner
    @Override
    public Class<? extends Yodo1MasBannerAdapterBase> bannerAdapterClass() {
        return Yodo1MasFyberBannerAdapter.class;
    }

    @Override
    public void onActivityDestroy(@NonNull Activity activity) {
        super.onActivityDestroy(activity);
        InneractiveAdManager.destroy();
    }

    // Rewarded Interstitial
    @Override
    public Class<? extends Yodo1MasRewardedInterstitialAdapterBase> rewardedInterstitialAdapterClass() {
        return null;
    }

    // App Open
    @Override
    public Class<? extends Yodo1MasAppOpenAdapterBase> appOpenAdapterClass() {
        return null;
    }
}
