package com.yodo1.mas.mediation.fyber;

import android.app.Activity;
import android.text.TextUtils;

import com.fyber.inneractive.sdk.external.InneractiveAdRequest;
import com.fyber.inneractive.sdk.external.InneractiveAdSpot;
import com.fyber.inneractive.sdk.external.InneractiveAdSpotManager;
import com.fyber.inneractive.sdk.external.InneractiveErrorCode;
import com.fyber.inneractive.sdk.external.InneractiveFullscreenAdEventsListener;
import com.fyber.inneractive.sdk.external.InneractiveFullscreenUnitController;
import com.fyber.inneractive.sdk.external.InneractiveUnitController;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.analytics.model.Yodo1MasAdRequestResultInfo;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.utils.Yodo1MasAdRequestTrackUtil;

public class Yodo1MasFyberInterstitialAdapter extends Yodo1MasInterstitialAdapterBase {

    private final InneractiveAdSpot.RequestListener interstitialListener = new InneractiveAdSpot.RequestListener() {

        @Override
        public void onInneractiveSuccessfulAdRequest(InneractiveAdSpot inneractiveAdSpot) {
            String message = "method: onInneractiveSuccessfulAdRequest, interstitial: ";
            Yodo1MasLog.d(TAG, message);
            adRequestResult
                    = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult(Yodo1Mas.AdType.Interstitial
                    , advertCode, getAdUnitId(), true, getAdLoadDuration(), null, null);
            callbackLoad(adRequestResult);
        }

        @Override
        public void onInneractiveFailedAdRequest(InneractiveAdSpot inneractiveAdSpot, InneractiveErrorCode inneractiveErrorCode) {
            String message = "method: onInneractiveFailedAdRequest, interstitial: errorCode: " + inneractiveErrorCode.name();
            Yodo1MasLog.d(TAG, message);

            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            adRequestResult
                    = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult(Yodo1Mas.AdType.Interstitial
                    , advertCode, getAdUnitId(), false, getAdLoadDuration(), inneractiveErrorCode.ordinal()+"", message);
            callbackError(error, inneractiveErrorCode.ordinal(), message, adRequestResult);
        }
    };
    private final InneractiveFullscreenAdEventsListener eventsListener = new InneractiveFullscreenAdEventsListener() {

        @Override
        public void onAdDismissed(InneractiveAdSpot inneractiveAdSpot) {
            String message = "method: onAdWillCloseInternalBrowser, interstitial: ";
            Yodo1MasLog.d(TAG, message);
            callbackClose();
        }

        @Override
        public void onAdClicked(InneractiveAdSpot inneractiveAdSpot) {
            String message = "method: onAdClicked, interstitial: ";
            Yodo1MasLog.d(TAG, message);
            callbackClick();
        }

        @Override
        public void onAdEnteredErrorState(InneractiveAdSpot inneractiveAdSpot, InneractiveUnitController.AdDisplayError adDisplayError) {
            String message = "method: onAdEnteredErrorState, interstitial: ";
            Yodo1MasLog.d(TAG, message);
        }

        @Override
        public void onAdWillCloseInternalBrowser(InneractiveAdSpot inneractiveAdSpot) {
            String message = "method: onAdWillCloseInternalBrowser, interstitial: ";
            Yodo1MasLog.d(TAG, message);
        }

        @Override
        public void onAdWillOpenExternalApp(InneractiveAdSpot inneractiveAdSpot) {
            String message = "method: onAdWillOpenExternalApp, interstitial: ";
            Yodo1MasLog.d(TAG, message);
        }

        @Override
        public void onAdImpression(InneractiveAdSpot inneractiveAdSpot) {
            String message = "method: onAdImpression, interstitial: ";
            Yodo1MasLog.d(TAG, message);
        }
    };
    private InneractiveAdSpot interstitialAd;

    public Yodo1MasFyberInterstitialAdapter(Yodo1MasAdapterBase.AdId unitId) {
        super(unitId);
    }

    @Override
    public boolean isInterstitialAdLoaded() {
        return interstitialAd != null && interstitialAd.isReady();
    }

    @Override
    public void loadInterstitialAdvert(Activity activity) {
        super.loadInterstitialAdvert(activity);
        String adId = getAdUnitId();
        if (TextUtils.isEmpty(adId)) return;

        if (interstitialStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) return;

        String message = "method: loadInterstitialAdvert, loading interstitial ad...";
        Yodo1MasLog.d(TAG, message);

        interstitialStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        adLoadStartTimeStamp = System.currentTimeMillis();

        InneractiveFullscreenUnitController controller = new InneractiveFullscreenUnitController();
        controller.setEventsListener(eventsListener);

        InneractiveAdRequest adRequest = new InneractiveAdRequest(adId);

        interstitialAd = InneractiveAdSpotManager.get().createSpot();
        interstitialAd.addUnitController(controller);
        interstitialAd.setRequestListener(interstitialListener);
        interstitialAd.requestAd(adRequest);
        // InneractiveFullscreenUnitController controller = (InneractiveFullscreenUnitController) interstitialAd.getSelectedUnitController();
    }

    @Override
    public void showInterstitialAdvertFromActivity(Activity activity) {
        super.showInterstitialAdvertFromActivity(activity);
        if (isInterstitialAdLoaded()) {
            String message = "method: showInterstitialAdvert, show interstitial ad...";
            Yodo1MasLog.d(TAG, message);

            InneractiveFullscreenUnitController controller = (InneractiveFullscreenUnitController) interstitialAd.getSelectedUnitController();
            controller.show(activity);
            callbackOpen();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (interstitialAd != null) {
            interstitialAd.destroy();
        }
        interstitialAd = null;
    }
}
