package com.yodo1.mas.mediation.fyber;

import android.app.Activity;
import android.text.TextUtils;
import android.util.Log;
import android.view.ViewGroup;
import android.widget.RelativeLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.fyber.inneractive.sdk.external.InneractiveAdManager;
import com.fyber.inneractive.sdk.external.InneractiveAdRequest;
import com.fyber.inneractive.sdk.external.InneractiveAdSpot;
import com.fyber.inneractive.sdk.external.InneractiveAdSpotManager;
import com.fyber.inneractive.sdk.external.InneractiveAdViewEventsListener;
import com.fyber.inneractive.sdk.external.InneractiveAdViewUnitController;
import com.fyber.inneractive.sdk.external.InneractiveErrorCode;
import com.fyber.inneractive.sdk.external.InneractiveFullscreenAdEventsListener;
import com.fyber.inneractive.sdk.external.InneractiveFullscreenUnitController;
import com.fyber.inneractive.sdk.external.InneractiveUnitController;
import com.fyber.inneractive.sdk.external.OnFyberMarketplaceInitializedListener;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.event.Yodo1MasAdEvent;
import com.yodo1.mas.helper.Yodo1MasBanner;
import com.yodo1.mas.helper.Yodo1MasHelper;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;

import org.json.JSONObject;

public class Yodo1MasFyberAdapter extends Yodo1MasAdapterBase {

    private InneractiveAdSpot rewardAd;
    private InneractiveAdSpot interstitialAd;
    private InneractiveAdSpot bannerAd;
    private ViewGroup mBannerWrapperView;

    private AdvertState rewardState = AdvertState.NONE;
    private AdvertState interstitialState = AdvertState.NONE;

    @Override
    public String getAdvertCode() {
        return "fyber";
    }

    @Override
    public String getSDKVersion() {
        return BuildConfig.SDK_VERSION_NAME;
    }

    @Override
    public String getMediationVersion() {
        return BuildConfig.MAS_VERSION_NAME;
    }

    @Override
    public void initSDK(@NonNull Activity activity, @NonNull Config config, @Nullable InitCallback callback) {
        super.initSDK(activity, config, callback);
        if (isInitSDK()) {
            if (callback != null) {
                callback.onAdapterInitSuccessful(getAdvertCode());
            }
            return;
        }

        if (TextUtils.isEmpty(config.appId)) {
            if (callback != null) {
                callback.onAdapterInitFailed(getAdvertCode(), new Yodo1MasError(Yodo1MasError.CODE_ADVERT_UNINITIALIZED, "config.appId is null"));
            }
            return;
        }

        init = true;
        InneractiveAdManager.initialize(activity, config.appId);
        InneractiveAdManager.initialize(activity, config.appId, status -> {
            String message = "method: onFyberMarketplaceInitialized, status: " + status.name();
            Log.d(TAG, message);
            if (OnFyberMarketplaceInitializedListener.FyberInitStatus.SUCCESSFULLY == status) {
                updatePrivacy();
                loadRewardAdvert();
                loadInterstitialAdvert();
                loadBannerAdvert();
                if (callback != null) {
                    callback.onAdapterInitSuccessful(getAdvertCode());
                }
            }
        });
    }

    @Override
    public void updatePrivacy() {
        super.updatePrivacy();
        InneractiveAdManager.setGdprConsent(Yodo1MasHelper.getInstance().isGDPRUserConsent());
        String ccpaContent = Yodo1MasHelper.getInstance().isCCPADoNotSell() ? "1YYN" : "1YNN";
        InneractiveAdManager.setUSPrivacyString(ccpaContent);
    }

    @Override
    public boolean isRewardAdvertLoaded() {
        return rewardAd != null && rewardAd.isReady();
    }

    @Override
    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);
        if (!isInitSDK()) return;

        if (rewardAd == null) {
            rewardAd = InneractiveAdSpotManager.get().createSpot();
            InneractiveFullscreenUnitController controller = new InneractiveFullscreenUnitController();
            rewardAd.addUnitController(controller);
            rewardAd.setRequestListener(rewardListener);
        }
        if (rewardAd != null && rewardState != AdvertState.LOADING) {
            String message = "method: loadRewardAdvert, loading reward ad...";
            Log.d(TAG, message);

            InneractiveAdRequest adRequest = new InneractiveAdRequest("");
            rewardAd.requestAd(adRequest);
            rewardState = AdvertState.LOADING;
        }
    }

    @Override
    public void showRewardAdvert(@NonNull Activity activity, @Nullable JSONObject object, @Nullable AdvertCallback callback) {
        super.showRewardAdvert(activity, object, callback);
        if (isCanShow(Yodo1Mas.AdType.Reward, callback)) {
            String message = "method: showRewardAdvert, show reward ad...";
            Log.d(TAG, message);
            InneractiveFullscreenUnitController controller = (InneractiveFullscreenUnitController) rewardAd.getSelectedUnitController();
            controller.show(activity);
            rewardState = AdvertState.NONE;
        }
    }

    @Override
    public void dismissRewardAdvert() {
        super.dismissRewardAdvert();
        if (rewardAd != null) {
            rewardAd.destroy();
        }
        rewardAd = null;
    }

    @Override
    public boolean isInterstitialAdvertLoaded() {
        return interstitialAd != null && interstitialAd.isReady();
    }

    @Override
    public void loadInterstitialAdvert(@NonNull Activity activity) {
        super.loadInterstitialAdvert(activity);
        if (!isInitSDK()) return;

        if (interstitialAd == null) {
            interstitialAd = InneractiveAdSpotManager.get().createSpot();
            InneractiveFullscreenUnitController controller = new InneractiveFullscreenUnitController();
            interstitialAd.addUnitController(controller);
            interstitialAd.setRequestListener(interstitialListener);
        }
        if (interstitialAd != null && interstitialState != AdvertState.LOADING) {
            String message = "method: loadInterstitialAdvert, loading interstitial ad...";
            Log.d(TAG, message);

            InneractiveAdRequest adRequest = new InneractiveAdRequest("");
            interstitialAd.requestAd(adRequest);
            interstitialState = AdvertState.LOADING;
        }
    }

    @Override
    public void showInterstitialAdvert(@NonNull Activity activity, @Nullable JSONObject object, @Nullable AdvertCallback callback) {
        super.showInterstitialAdvert(activity, object, callback);

        if (isCanShow(Yodo1Mas.AdType.Interstitial, callback)) {
            String message = "method: showInterstitialAdvert, show interstitial ad...";
            Log.d(TAG, message);

            InneractiveFullscreenUnitController controller = (InneractiveFullscreenUnitController) interstitialAd.getSelectedUnitController();
            controller.show(activity);
            interstitialState = AdvertState.NONE;
        }
    }

    @Override
    public void dismissInterstitialAdvert() {
        super.dismissInterstitialAdvert();
        if (interstitialAd != null) {
            interstitialAd.destroy();
        }
        interstitialAd = null;
    }

    @Override
    public boolean isBannerAdvertLoaded() {
        return bannerAd != null && bannerAd.isReady();
    }

    @Override
    public void loadBannerAdvert(@NonNull Activity activity) {
        super.loadBannerAdvert(activity);
        if (!isInitSDK()) return;

        if (bannerAd == null) {
            bannerAd = InneractiveAdSpotManager.get().createSpot();
            InneractiveAdViewUnitController controller = new InneractiveAdViewUnitController();
            bannerAd.addUnitController(controller);
            bannerAd.setRequestListener(bannerListener);
        }

        if (bannerAd != null && bannerState != AdvertState.LOADING) {
            String message = "method: loadBannerAdvert, loading banner ad...";
            Log.d(TAG, message);

            InneractiveAdRequest adRequest = new InneractiveAdRequest("");
            bannerAd.requestAd(adRequest);
            bannerState = AdvertState.LOADING;
        }
    }

    @Override
    public void showBannerAdvert(@NonNull Activity activity, @Nullable JSONObject object, @Nullable AdvertCallback callback) {
        super.showBannerAdvert(activity, object, callback);
        if (isCanShow(Yodo1Mas.AdType.Banner, callback)) {
            String message = "method: showBannerAdvert, show banner ad...";
            Log.d(TAG, message);

            if (mBannerWrapperView == null) {
                mBannerWrapperView = new RelativeLayout(activity);
                InneractiveAdViewUnitController controller = (InneractiveAdViewUnitController) bannerAd.getSelectedUnitController();
                controller.bindView(mBannerWrapperView);
            }

            if (mBannerWrapperView != null)
                Yodo1MasBanner.showBanner(activity, mBannerWrapperView, object);
        }
    }

    @Override
    public void dismissBannerAdvert(boolean destroy) {
        super.dismissBannerAdvert(destroy);
        if (bannerAd != null) {
            if (mBannerWrapperView != null)
                Yodo1MasBanner.removeBanner(mBannerWrapperView);

            if (destroy) {
                bannerAd.destroy();
                bannerAd = null;
                bannerState = AdvertState.NONE;
                loadBannerAdvert();
            }
        }
    }

    @Override
    public void onActivityDestroy(@NonNull Activity activity) {
        super.onActivityDestroy(activity);
        if (bannerAd != null) {
            bannerAd.destroy();
        }
        InneractiveAdManager.destroy();
    }

    private final InneractiveAdSpot.RequestListener rewardListener = new InneractiveAdSpot.RequestListener() {

        @Override
        public void onInneractiveSuccessfulAdRequest(InneractiveAdSpot inneractiveAdSpot) {

            String message = "method: onInneractiveSuccessfulAdRequest, reward: ";
            Log.d(TAG, message);
            rewardState = AdvertState.LOADED;

            InneractiveFullscreenUnitController controller =
                    (InneractiveFullscreenUnitController) rewardAd.getSelectedUnitController();
            controller.setRewardedListener(inneractiveAdSpot1 -> {
                String message1 = "method: onAdRewarded, reward: ";
                Log.d(TAG, message1);
                callback(Yodo1MasAdEvent.CODE_REWARD_EARNED, Yodo1Mas.AdType.Reward, TAG + ":{" + message1 + "}");
            });

            controller.setEventsListener(new InneractiveFullscreenAdEventsListener() {

                @Override
                public void onAdImpression(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdImpression, reward: ";
                    Log.d(TAG, message);
                    callback(Yodo1MasAdEvent.CODE_OPENED, Yodo1Mas.AdType.Reward, TAG + ":{" + message + "}");
                }

                @Override
                public void onAdClicked(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdClicked, reward: ";
                    Log.d(TAG, message);
                }

                @Override
                public void onAdWillOpenExternalApp(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdWillOpenExternalApp, reward: ";
                    Log.d(TAG, message);
                }

                @Override
                public void onAdEnteredErrorState(InneractiveAdSpot inneractiveAdSpot, InneractiveUnitController.AdDisplayError adDisplayError) {
                    String message = "method: onAdEnteredErrorState, reward: ";
                    Log.d(TAG, message);
                }

                @Override
                public void onAdWillCloseInternalBrowser(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdWillCloseInternalBrowser, reward: ";
                    Log.d(TAG, message);
                }

                @Override
                public void onAdDismissed(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdDismissed, reward: ";
                    Log.d(TAG, message);
                    callback(Yodo1MasAdEvent.CODE_CLOSED, Yodo1Mas.AdType.Reward, TAG + ":{" + message + "}");
                    loadRewardAdvert();
                }
            });

        }

        @Override
        public void onInneractiveFailedAdRequest(InneractiveAdSpot inneractiveAdSpot, InneractiveErrorCode inneractiveErrorCode) {
            String message = "method: onInneractiveFailedAdRequest, reward errorCode:" + inneractiveErrorCode.name();
            Log.d(TAG, message);
            rewardState = AdvertState.NONE;

            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            callback(error, Yodo1Mas.AdType.Reward);

            nextReward();
            loadRewardAdvertDelayed();
        }
    };

    private final InneractiveAdSpot.RequestListener interstitialListener = new InneractiveAdSpot.RequestListener() {

        @Override
        public void onInneractiveSuccessfulAdRequest(InneractiveAdSpot inneractiveAdSpot) {

            String message = "method: onInneractiveSuccessfulAdRequest, interstitial: ";
            Log.d(TAG, message);
            interstitialState = AdvertState.LOADED;

            InneractiveFullscreenUnitController controller =
                    (InneractiveFullscreenUnitController) interstitialAd.getSelectedUnitController();
            controller.setEventsListener(new InneractiveFullscreenAdEventsListener() {

                @Override
                public void onAdImpression(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdImpression, interstitial: ";
                    Log.d(TAG, message);
                    callback(Yodo1MasAdEvent.CODE_OPENED, Yodo1Mas.AdType.Interstitial, TAG + ":{" + message + "}");
                }

                @Override
                public void onAdClicked(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdClicked, interstitial: ";
                    Log.d(TAG, message);
                }

                @Override
                public void onAdWillOpenExternalApp(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdWillOpenExternalApp, interstitial: ";
                    Log.d(TAG, message);
                }

                @Override
                public void onAdEnteredErrorState(InneractiveAdSpot inneractiveAdSpot, InneractiveUnitController.AdDisplayError adDisplayError) {
                    String message = "method: onAdEnteredErrorState, interstitial: ";
                    Log.d(TAG, message);
                }

                @Override
                public void onAdWillCloseInternalBrowser(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdWillCloseInternalBrowser, interstitial: ";
                    Log.d(TAG, message);
                }

                @Override
                public void onAdDismissed(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdWillCloseInternalBrowser, interstitial: ";
                    Log.d(TAG, message);
                    callback(Yodo1MasAdEvent.CODE_CLOSED, Yodo1Mas.AdType.Interstitial, TAG + ":{" + message + "}");
                    loadInterstitialAdvert();
                }
            });
        }

        @Override
        public void onInneractiveFailedAdRequest(InneractiveAdSpot inneractiveAdSpot, InneractiveErrorCode inneractiveErrorCode) {
            String message = "method: onInneractiveFailedAdRequest, interstitial: errorCode: " + inneractiveErrorCode.name();
            Log.d(TAG, message);
            interstitialState = AdvertState.NONE;

            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            callback(error, Yodo1Mas.AdType.Interstitial);

            nextInterstitial();
            loadInterstitialAdvertDelayed();
        }
    };

    private final InneractiveAdSpot.RequestListener bannerListener = new InneractiveAdSpot.RequestListener() {

        @Override
        public void onInneractiveSuccessfulAdRequest(InneractiveAdSpot inneractiveAdSpot) {

            String message = "method: onInneractiveSuccessfulAdRequest, banner: ";
            Log.d(TAG, message);
            bannerState = AdvertState.LOADED;
            callback(Yodo1MasAdEvent.CODE_LOADED, Yodo1Mas.AdType.Banner, TAG + ":{" + message + "}");

            InneractiveAdViewUnitController controller = (InneractiveAdViewUnitController) bannerAd.getSelectedUnitController();
            controller.setEventsListener(new InneractiveAdViewEventsListener() {

                @Override
                public void onAdImpression(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onLoggingImpression, banner: ";
                    Log.d(TAG, message);
                    bannerState = AdvertState.NONE;
                    callback(Yodo1MasAdEvent.CODE_OPENED, Yodo1Mas.AdType.Banner, TAG + ":{" + message + "}");
                }

                @Override
                public void onAdClicked(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdClicked, banner: ";
                    Log.d(TAG, message);
                }

                @Override
                public void onAdWillCloseInternalBrowser(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdWillCloseInternalBrowser, banner: ";
                    Log.d(TAG, message);
                    callback(Yodo1MasAdEvent.CODE_CLOSED, Yodo1Mas.AdType.Banner, TAG + ":{" + message + "}");
                }

                @Override
                public void onAdWillOpenExternalApp(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdWillOpenExternalApp, banner: ";
                    Log.d(TAG, message);
                }

                @Override
                public void onAdEnteredErrorState(InneractiveAdSpot inneractiveAdSpot, InneractiveUnitController.AdDisplayError adDisplayError) {
                    String message = "method: onAdEnteredErrorState, banner: ";
                    Log.d(TAG, message);
                }

                @Override
                public void onAdExpanded(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdExpanded, banner: ";
                    Log.d(TAG, message);
                }

                @Override
                public void onAdResized(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdResized, banner: ";
                    Log.d(TAG, message);
                }

                @Override
                public void onAdCollapsed(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdCollapsed, banner: ";
                    Log.d(TAG, message);
                }
            });
        }

        @Override
        public void onInneractiveFailedAdRequest(InneractiveAdSpot inneractiveAdSpot, InneractiveErrorCode inneractiveErrorCode) {
            String message = "method: onInneractiveFailedAdRequest, errorcode: " + inneractiveErrorCode.name();
            Log.d(TAG, message);
            bannerState = AdvertState.NONE;
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            callback(error, Yodo1Mas.AdType.Banner);

            nextBanner();
            loadBannerAdvertDelayed();
        }
    };
}
