package com.yodo1.mas.mediation.fyber;

import android.app.Activity;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;

import com.fyber.inneractive.sdk.external.InneractiveAdRequest;
import com.fyber.inneractive.sdk.external.InneractiveAdSpot;
import com.fyber.inneractive.sdk.external.InneractiveAdSpotManager;
import com.fyber.inneractive.sdk.external.InneractiveAdViewEventsListener;
import com.fyber.inneractive.sdk.external.InneractiveAdViewUnitController;
import com.fyber.inneractive.sdk.external.InneractiveErrorCode;
import com.fyber.inneractive.sdk.external.InneractiveUnitController;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.analytics.Yodo1MasSensorHelper;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.event.Yodo1MasAdEvent;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasBannerAdapterBase;

import androidx.annotation.NonNull;

public class Yodo1MasFyberBannerAdapter extends Yodo1MasBannerAdapterBase {

    private InneractiveAdSpot bannerAd;
    private ViewGroup mBannerWrapperView;

    @Override
    public boolean isBannerAdvertLoaded() {
        return bannerAd != null && bannerAd.isReady();
    }

    @Override
    public void loadBannerAdvert(@NonNull Activity activity) {
        super.loadBannerAdvert(activity);
        if (relateAdapter == null || !relateAdapter.isInitSDK()) {
            return;
        }

        Yodo1MasAdapterBase.AdId adId = getBannerAdId();
        if(adId == null || TextUtils.isEmpty(adId.adId)) {
            return;
        }

        if(adId.object != null && !isPriceValuable(adId)) {
            handlePricyNotAbaliable();
            return;
        }

        if (bannerAd == null) {
            if (mBannerWrapperView == null) {
                mBannerWrapperView = new RelativeLayout(activity);
            }
            bannerAd = InneractiveAdSpotManager.get().createSpot();
            InneractiveAdViewUnitController controller = new InneractiveAdViewUnitController();
            bannerAd.addUnitController(controller);
            bannerAd.setRequestListener(bannerListener);
        }

        if (bannerAd != null && bannerState != Yodo1MasAdapterBase.AdvertState.LOADING) {
            String message = "method: loadBannerAdvert, loading banner ad...";
            Log.d(TAG, message);

            String spotId = !TextUtils.isEmpty(adId.adId) ? adId.adId : "";
            InneractiveAdRequest adRequest = new InneractiveAdRequest(spotId);
            bannerAd.requestAd(adRequest);
            bannerState = Yodo1MasAdapterBase.AdvertState.LOADING;
            advertAdapterState = AdvertAdapterState.LOADING;
            logAdIdInfo(adId);
        }
    }

    @Override
    public View getBannerView() {
        return mBannerWrapperView;
    }

    @Override
    public void dismissBannerAdvert(boolean destroy) {
        super.dismissBannerAdvert(destroy);
        if (bannerAd != null) {
            if (destroy) {
                bannerAd.destroy();
                bannerAd = null;
                bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
                advertAdapterState = AdvertAdapterState.NONE;
            }
        }
    }

    @Override
    public boolean isSupportMultipleInstance() {
        return false;
    }

    private final InneractiveAdSpot.RequestListener bannerListener = new InneractiveAdSpot.RequestListener() {

        @Override
        public void onInneractiveSuccessfulAdRequest(InneractiveAdSpot inneractiveAdSpot) {

            String message = "method: onInneractiveSuccessfulAdRequest, banner: ";
            Log.d(TAG, message);
            bannerState = Yodo1MasAdapterBase.AdvertState.LOADED;
            trackAdRequestSuccessed();
            callback(Yodo1MasAdEvent.CODE_LOADED, TAG + ":{" + message + "}");

            advertAdapterState = AdvertAdapterState.LOADED;
            callbackAdapterState();

            InneractiveAdViewUnitController controller = (InneractiveAdViewUnitController) bannerAd.getSelectedUnitController();

            if (inneractiveAdSpot.isReady() ) {
                controller.bindView(mBannerWrapperView);
            }
            controller.setEventsListener(new InneractiveAdViewEventsListener() {

                @Override
                public void onAdImpression(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onLoggingImpression, banner: ";
                    Log.d(TAG, message);
                    bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
                    callback(Yodo1MasAdEvent.CODE_OPENED, TAG + ":{" + message + "}");
                }

                @Override
                public void onAdClicked(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdClicked, banner: ";
                    Log.d(TAG, message);
                }

                @Override
                public void onAdWillCloseInternalBrowser(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdWillCloseInternalBrowser, banner: ";
                    Log.d(TAG, message);
                    callback(Yodo1MasAdEvent.CODE_CLOSED, TAG + ":{" + message + "}");
                }

                @Override
                public void onAdWillOpenExternalApp(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdWillOpenExternalApp, banner: ";
                    Log.d(TAG, message);
                }

                @Override
                public void onAdEnteredErrorState(InneractiveAdSpot inneractiveAdSpot, InneractiveUnitController.AdDisplayError adDisplayError) {
                    String message = "method: onAdEnteredErrorState, banner: ";
                    Log.d(TAG, message);
                }

                @Override
                public void onAdExpanded(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdExpanded, banner: ";
                    Log.d(TAG, message);
                }

                @Override
                public void onAdResized(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdResized, banner: ";
                    Log.d(TAG, message);
                }

                @Override
                public void onAdCollapsed(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdCollapsed, banner: ";
                    Log.d(TAG, message);
                }
            });
        }

        @Override
        public void onInneractiveFailedAdRequest(InneractiveAdSpot inneractiveAdSpot, InneractiveErrorCode inneractiveErrorCode) {
            String message = "method: onInneractiveFailedAdRequest, errorcode: " + inneractiveErrorCode.name();
            Log.d(TAG, message);
            bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            trackAdRequestFailed(inneractiveErrorCode.name(), inneractiveErrorCode.toString());

            if(isLastPlacement()) {
                Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
                callback(error);
                advertAdapterState = AdvertAdapterState.FAILED;
                callbackAdapterState();
            }
            else {
                nextBanner();
                loadBannerAdvertDelayed();
            }
        }
    };
}
