/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.fyber;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.fyber.inneractive.sdk.external.InneractiveAdManager;
import com.fyber.inneractive.sdk.external.InneractiveAdRequest;
import com.fyber.inneractive.sdk.external.InneractiveAdSpot;
import com.fyber.inneractive.sdk.external.InneractiveAdSpotManager;
import com.fyber.inneractive.sdk.external.InneractiveErrorCode;
import com.fyber.inneractive.sdk.external.InneractiveFullscreenAdEventsListener;
import com.fyber.inneractive.sdk.external.InneractiveFullscreenUnitController;
import com.fyber.inneractive.sdk.external.InneractiveUnitController;
import com.fyber.inneractive.sdk.external.OnFyberMarketplaceInitializedListener;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.helper.Yodo1MasHelper;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.mediation.fyber.Yodo1MasFyberBannerAdapter;
import org.json.JSONObject;

public class Yodo1MasFyberAdapter
extends Yodo1MasAdapterBase {
    private InneractiveAdSpot rewardAd;
    private InneractiveAdSpot interstitialAd;
    private Yodo1MasAdapterBase.AdvertState rewardState = Yodo1MasAdapterBase.AdvertState.NONE;
    private final InneractiveAdSpot.RequestListener rewardListener = new InneractiveAdSpot.RequestListener(){

        public void onInneractiveSuccessfulAdRequest(InneractiveAdSpot inneractiveAdSpot) {
            String message = "method: onInneractiveSuccessfulAdRequest, reward: ";
            Log.d((String)Yodo1MasFyberAdapter.this.TAG, (String)message);
            Yodo1MasFyberAdapter.this.rewardState = Yodo1MasAdapterBase.AdvertState.LOADED;
            InneractiveFullscreenUnitController controller = (InneractiveFullscreenUnitController)Yodo1MasFyberAdapter.this.rewardAd.getSelectedUnitController();
            controller.setRewardedListener(inneractiveAdSpot1 -> {
                String message1 = "method: onAdRewarded, reward: ";
                Log.d((String)Yodo1MasFyberAdapter.this.TAG, (String)message1);
                Yodo1MasFyberAdapter.this.callback(2001, Yodo1Mas.AdType.Reward, Yodo1MasFyberAdapter.this.TAG + ":{" + message1 + "}");
            });
            controller.setEventsListener((InneractiveUnitController.EventsListener)new InneractiveFullscreenAdEventsListener(){

                public void onAdImpression(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdImpression, reward: ";
                    Log.d((String)Yodo1MasFyberAdapter.this.TAG, (String)message);
                    Yodo1MasFyberAdapter.this.callback(1001, Yodo1Mas.AdType.Reward, Yodo1MasFyberAdapter.this.TAG + ":{" + message + "}");
                }

                public void onAdClicked(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdClicked, reward: ";
                    Log.d((String)Yodo1MasFyberAdapter.this.TAG, (String)message);
                }

                public void onAdWillOpenExternalApp(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdWillOpenExternalApp, reward: ";
                    Log.d((String)Yodo1MasFyberAdapter.this.TAG, (String)message);
                }

                public void onAdEnteredErrorState(InneractiveAdSpot inneractiveAdSpot, InneractiveUnitController.AdDisplayError adDisplayError) {
                    String message = "method: onAdEnteredErrorState, reward: ";
                    Log.d((String)Yodo1MasFyberAdapter.this.TAG, (String)message);
                }

                public void onAdWillCloseInternalBrowser(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdWillCloseInternalBrowser, reward: ";
                    Log.d((String)Yodo1MasFyberAdapter.this.TAG, (String)message);
                }

                public void onAdDismissed(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdDismissed, reward: ";
                    Log.d((String)Yodo1MasFyberAdapter.this.TAG, (String)message);
                    Yodo1MasFyberAdapter.this.callback(1002, Yodo1Mas.AdType.Reward, Yodo1MasFyberAdapter.this.TAG + ":{" + message + "}");
                    Yodo1MasFyberAdapter.this.loadRewardAdvert();
                }
            });
        }

        public void onInneractiveFailedAdRequest(InneractiveAdSpot inneractiveAdSpot, InneractiveErrorCode inneractiveErrorCode) {
            String message = "method: onInneractiveFailedAdRequest, reward errorCode:" + inneractiveErrorCode.name();
            Log.d((String)Yodo1MasFyberAdapter.this.TAG, (String)message);
            Yodo1MasFyberAdapter.this.rewardState = Yodo1MasAdapterBase.AdvertState.NONE;
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasFyberAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasFyberAdapter.this.callback(error, Yodo1Mas.AdType.Reward);
            Yodo1MasFyberAdapter.this.nextReward();
            Yodo1MasFyberAdapter.this.loadRewardAdvertDelayed();
        }
    };
    private Yodo1MasAdapterBase.AdvertState interstitialState = Yodo1MasAdapterBase.AdvertState.NONE;
    private final InneractiveAdSpot.RequestListener interstitialListener = new InneractiveAdSpot.RequestListener(){

        public void onInneractiveSuccessfulAdRequest(InneractiveAdSpot inneractiveAdSpot) {
            String message = "method: onInneractiveSuccessfulAdRequest, interstitial: ";
            Log.d((String)Yodo1MasFyberAdapter.this.TAG, (String)message);
            Yodo1MasFyberAdapter.this.interstitialState = Yodo1MasAdapterBase.AdvertState.LOADED;
            InneractiveFullscreenUnitController controller = (InneractiveFullscreenUnitController)Yodo1MasFyberAdapter.this.interstitialAd.getSelectedUnitController();
            controller.setEventsListener((InneractiveUnitController.EventsListener)new InneractiveFullscreenAdEventsListener(){

                public void onAdImpression(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdImpression, interstitial: ";
                    Log.d((String)Yodo1MasFyberAdapter.this.TAG, (String)message);
                    Yodo1MasFyberAdapter.this.callback(1001, Yodo1Mas.AdType.Interstitial, Yodo1MasFyberAdapter.this.TAG + ":{" + message + "}");
                }

                public void onAdClicked(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdClicked, interstitial: ";
                    Log.d((String)Yodo1MasFyberAdapter.this.TAG, (String)message);
                }

                public void onAdWillOpenExternalApp(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdWillOpenExternalApp, interstitial: ";
                    Log.d((String)Yodo1MasFyberAdapter.this.TAG, (String)message);
                }

                public void onAdEnteredErrorState(InneractiveAdSpot inneractiveAdSpot, InneractiveUnitController.AdDisplayError adDisplayError) {
                    String message = "method: onAdEnteredErrorState, interstitial: ";
                    Log.d((String)Yodo1MasFyberAdapter.this.TAG, (String)message);
                }

                public void onAdWillCloseInternalBrowser(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdWillCloseInternalBrowser, interstitial: ";
                    Log.d((String)Yodo1MasFyberAdapter.this.TAG, (String)message);
                }

                public void onAdDismissed(InneractiveAdSpot inneractiveAdSpot) {
                    String message = "method: onAdWillCloseInternalBrowser, interstitial: ";
                    Log.d((String)Yodo1MasFyberAdapter.this.TAG, (String)message);
                    Yodo1MasFyberAdapter.this.callback(1002, Yodo1Mas.AdType.Interstitial, Yodo1MasFyberAdapter.this.TAG + ":{" + message + "}");
                    Yodo1MasFyberAdapter.this.loadInterstitialAdvert();
                }
            });
        }

        public void onInneractiveFailedAdRequest(InneractiveAdSpot inneractiveAdSpot, InneractiveErrorCode inneractiveErrorCode) {
            String message = "method: onInneractiveFailedAdRequest, interstitial: errorCode: " + inneractiveErrorCode.name();
            Log.d((String)Yodo1MasFyberAdapter.this.TAG, (String)message);
            Yodo1MasFyberAdapter.this.interstitialState = Yodo1MasAdapterBase.AdvertState.NONE;
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasFyberAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasFyberAdapter.this.callback(error, Yodo1Mas.AdType.Interstitial);
            Yodo1MasFyberAdapter.this.nextInterstitial();
            Yodo1MasFyberAdapter.this.loadInterstitialAdvertDelayed();
        }
    };

    public static void setFyberPrivacy() {
        InneractiveAdManager.setGdprConsent((boolean)Yodo1MasHelper.getInstance().isGDPRUserConsent());
        String ccpaContent = Yodo1MasHelper.getInstance().isCCPADoNotSell() ? "1YYN" : "1YNN";
        InneractiveAdManager.setUSPrivacyString((String)ccpaContent);
    }

    public String getAdvertCode() {
        return "fyber";
    }

    public String getSDKVersion() {
        return "8.1.3";
    }

    public String getMediationVersion() {
        return "4.6.1";
    }

    public void initSDK(@NonNull Activity activity, @NonNull Yodo1MasAdapterBase.Config config, @Nullable Yodo1MasAdapterBase.InitCallback callback) {
        super.initSDK(activity, config, callback);
        if (this.isInitSDK()) {
            if (callback != null) {
                callback.onAdapterInitSuccessful(this.getAdvertCode());
            }
            return;
        }
        if (TextUtils.isEmpty((CharSequence)config.appId)) {
            if (callback != null) {
                callback.onAdapterInitFailed(this.getAdvertCode(), new Yodo1MasError(-600001, "config.appId is null"));
            }
            return;
        }
        this.init = true;
        InneractiveAdManager.initialize((Context)activity, (String)config.appId);
        InneractiveAdManager.initialize((Context)activity, (String)config.appId, status -> {
            String message = "method: onFyberMarketplaceInitialized, status: " + status.name();
            Log.d((String)this.TAG, (String)message);
            if (OnFyberMarketplaceInitializedListener.FyberInitStatus.SUCCESSFULLY == status) {
                this.updatePrivacy();
                this.loadRewardAdvert();
                this.loadInterstitialAdvert();
                if (callback != null) {
                    callback.onAdapterInitSuccessful(this.getAdvertCode());
                }
            }
        });
    }

    public void updatePrivacy() {
        super.updatePrivacy();
        Yodo1MasFyberAdapter.setFyberPrivacy();
    }

    public boolean isRewardAdvertLoaded() {
        return this.rewardAd != null && this.rewardAd.isReady();
    }

    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);
        if (!this.isInitSDK()) {
            return;
        }
        Yodo1MasAdapterBase.AdId adId = this.getRewardAdId();
        if (adId == null || TextUtils.isEmpty((CharSequence)adId.adId)) {
            return;
        }
        if (this.rewardAd == null) {
            this.rewardAd = InneractiveAdSpotManager.get().createSpot();
            InneractiveFullscreenUnitController controller = new InneractiveFullscreenUnitController();
            this.rewardAd.addUnitController((InneractiveUnitController)controller);
            this.rewardAd.setRequestListener(this.rewardListener);
        }
        if (this.rewardAd != null && this.rewardState != Yodo1MasAdapterBase.AdvertState.LOADING) {
            String message = "method: loadRewardAdvert, loading reward ad...";
            Log.d((String)this.TAG, (String)message);
            InneractiveAdRequest adRequest = new InneractiveAdRequest("");
            this.rewardAd.requestAd(adRequest);
            this.rewardState = Yodo1MasAdapterBase.AdvertState.LOADING;
        }
    }

    public void showRewardAdvert(@NonNull Activity activity, @Nullable JSONObject object, @Nullable Yodo1MasAdapterBase.AdvertCallback callback) {
        super.showRewardAdvert(activity, object, callback);
        if (this.isCanShow(Yodo1Mas.AdType.Reward, callback)) {
            String message = "method: showRewardAdvert, show reward ad...";
            Log.d((String)this.TAG, (String)message);
            InneractiveFullscreenUnitController controller = (InneractiveFullscreenUnitController)this.rewardAd.getSelectedUnitController();
            controller.show(activity);
            this.rewardState = Yodo1MasAdapterBase.AdvertState.NONE;
        }
    }

    public void dismissRewardAdvert() {
        super.dismissRewardAdvert();
        if (this.rewardAd != null) {
            this.rewardAd.destroy();
        }
        this.rewardAd = null;
        this.rewardState = Yodo1MasAdapterBase.AdvertState.NONE;
    }

    public boolean isInterstitialAdvertLoaded() {
        return this.interstitialAd != null && this.interstitialAd.isReady();
    }

    public void loadInterstitialAdvert(@NonNull Activity activity) {
        super.loadInterstitialAdvert(activity);
        if (!this.isInitSDK()) {
            return;
        }
        Yodo1MasAdapterBase.AdId adId = this.getInterstitialAdId();
        if (adId == null || TextUtils.isEmpty((CharSequence)adId.adId)) {
            return;
        }
        if (this.interstitialAd == null) {
            this.interstitialAd = InneractiveAdSpotManager.get().createSpot();
            InneractiveFullscreenUnitController controller = new InneractiveFullscreenUnitController();
            this.interstitialAd.addUnitController((InneractiveUnitController)controller);
            this.interstitialAd.setRequestListener(this.interstitialListener);
        }
        if (this.interstitialAd != null && this.interstitialState != Yodo1MasAdapterBase.AdvertState.LOADING) {
            String message = "method: loadInterstitialAdvert, loading interstitial ad...";
            Log.d((String)this.TAG, (String)message);
            InneractiveAdRequest adRequest = new InneractiveAdRequest("");
            this.interstitialAd.requestAd(adRequest);
            this.interstitialState = Yodo1MasAdapterBase.AdvertState.LOADING;
        }
    }

    public void showInterstitialAdvert(@NonNull Activity activity, @Nullable JSONObject object, @Nullable Yodo1MasAdapterBase.AdvertCallback callback) {
        super.showInterstitialAdvert(activity, object, callback);
        if (this.isCanShow(Yodo1Mas.AdType.Interstitial, callback)) {
            String message = "method: showInterstitialAdvert, show interstitial ad...";
            Log.d((String)this.TAG, (String)message);
            InneractiveFullscreenUnitController controller = (InneractiveFullscreenUnitController)this.interstitialAd.getSelectedUnitController();
            controller.show(activity);
            this.interstitialState = Yodo1MasAdapterBase.AdvertState.NONE;
        }
    }

    public void dismissInterstitialAdvert() {
        super.dismissInterstitialAdvert();
        if (this.interstitialAd != null) {
            this.interstitialAd.destroy();
        }
        this.interstitialAd = null;
        this.interstitialState = Yodo1MasAdapterBase.AdvertState.NONE;
    }

    public Yodo1MasBannerAdapterBase getYodo1MasBannerAdapter() {
        Yodo1MasFyberBannerAdapter bannerAdapter = new Yodo1MasFyberBannerAdapter();
        bannerAdapter.bannerAdIds.clear();
        bannerAdapter.bannerAdIds.addAll(this.bannerAdIds);
        bannerAdapter.relateAdapter = this;
        bannerAdapter.advertCode = this.getAdvertCode();
        bannerAdapter.sdkVersion = this.getSDKVersion();
        bannerAdapter.mediationVersion = this.getMediationVersion();
        return bannerAdapter;
    }

    public void onActivityDestroy(@NonNull Activity activity) {
        super.onActivityDestroy(activity);
        InneractiveAdManager.destroy();
    }
}

