package com.yodo1.mas.mediation.fyber;

import android.app.Activity;

import com.fyber.inneractive.sdk.external.InneractiveAdRequest;
import com.fyber.inneractive.sdk.external.InneractiveAdSpot;
import com.fyber.inneractive.sdk.external.InneractiveAdSpotManager;
import com.fyber.inneractive.sdk.external.InneractiveErrorCode;
import com.fyber.inneractive.sdk.external.InneractiveFullscreenAdEventsListener;
import com.fyber.inneractive.sdk.external.InneractiveFullscreenUnitController;
import com.fyber.inneractive.sdk.external.InneractiveUnitController;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;

import java.util.List;

public class Yodo1MasFyberInterstitialAdapter extends Yodo1MasInterstitialAdapterBase {

    private InneractiveAdSpot interstitialAd;

    public Yodo1MasFyberInterstitialAdapter(List<Yodo1MasAdapterBase.AdId> unitIds) {
        super(unitIds);
    }

    @Override
    public boolean isInterstitialAdLoaded() {
        return interstitialAd != null && interstitialAd.isReady();
    }

    @Override
    public void loadInterstitialAdvert(Activity activity) {
        super.loadInterstitialAdvert(activity);

        if (interstitialStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) return;

        String message = "method: loadInterstitialAdvert, loading interstitial ad...";
        Yodo1MasLog.v(TAG, message);

        interstitialStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;

        InneractiveFullscreenUnitController controller = new InneractiveFullscreenUnitController();
        controller.setEventsListener(eventsListener);

        InneractiveAdRequest adRequest = new InneractiveAdRequest("");

        interstitialAd = InneractiveAdSpotManager.get().createSpot();
        interstitialAd.addUnitController(controller);
        interstitialAd.setRequestListener(interstitialListener);
        interstitialAd.requestAd(adRequest);
        // InneractiveFullscreenUnitController controller = (InneractiveFullscreenUnitController) interstitialAd.getSelectedUnitController();
    }

    @Override
    public void showInterstitialAdvertFromActivity(Activity activity) {
        super.showInterstitialAdvertFromActivity(activity);
        if (isInterstitialAdLoaded()) {
            String message = "method: showInterstitialAdvert, show interstitial ad...";
            Yodo1MasLog.v(TAG, message);

            InneractiveFullscreenUnitController controller = (InneractiveFullscreenUnitController) interstitialAd.getSelectedUnitController();
            controller.show(activity);
            callbackOpen();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (interstitialAd != null) {
            interstitialAd.destroy();
        }
        interstitialAd = null;
    }

    private final InneractiveAdSpot.RequestListener interstitialListener = new InneractiveAdSpot.RequestListener() {

        @Override
        public void onInneractiveSuccessfulAdRequest(InneractiveAdSpot inneractiveAdSpot) {
            String message = "method: onInneractiveSuccessfulAdRequest, interstitial: ";
            Yodo1MasLog.v(TAG, message);
            callbackLoad();
        }

        @Override
        public void onInneractiveFailedAdRequest(InneractiveAdSpot inneractiveAdSpot, InneractiveErrorCode inneractiveErrorCode) {
            String message = "method: onInneractiveFailedAdRequest, interstitial: errorCode: " + inneractiveErrorCode.name();
            Yodo1MasLog.v(TAG, message);

            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            callbackError(error, inneractiveErrorCode.ordinal(), message);
        }
    };

    private final InneractiveFullscreenAdEventsListener eventsListener = new InneractiveFullscreenAdEventsListener() {

        @Override
        public void onAdDismissed(InneractiveAdSpot inneractiveAdSpot) {
            String message = "method: onAdWillCloseInternalBrowser, interstitial: ";
            Yodo1MasLog.v(TAG, message);
            callbackClose();
        }

        @Override
        public void onAdClicked(InneractiveAdSpot inneractiveAdSpot) {
            String message = "method: onAdClicked, interstitial: ";
            Yodo1MasLog.v(TAG, message);
            callbackClick();
        }

        @Override
        public void onAdEnteredErrorState(InneractiveAdSpot inneractiveAdSpot, InneractiveUnitController.AdDisplayError adDisplayError) {
            String message = "method: onAdEnteredErrorState, interstitial: ";
            Yodo1MasLog.v(TAG, message);
        }

        @Override
        public void onAdWillCloseInternalBrowser(InneractiveAdSpot inneractiveAdSpot) {
            String message = "method: onAdWillCloseInternalBrowser, interstitial: ";
            Yodo1MasLog.v(TAG, message);
        }

        @Override
        public void onAdWillOpenExternalApp(InneractiveAdSpot inneractiveAdSpot) {
            String message = "method: onAdWillOpenExternalApp, interstitial: ";
            Yodo1MasLog.v(TAG, message);
        }

        @Override
        public void onAdImpression(InneractiveAdSpot inneractiveAdSpot) {
            String message = "method: onAdImpression, interstitial: ";
            Yodo1MasLog.v(TAG, message);
        }
    };
}
