package com.yodo1.mas.mediation.fyber;

import android.app.Activity;

import androidx.annotation.NonNull;

import com.fyber.inneractive.sdk.external.InneractiveAdRequest;
import com.fyber.inneractive.sdk.external.InneractiveAdSpot;
import com.fyber.inneractive.sdk.external.InneractiveAdSpotManager;
import com.fyber.inneractive.sdk.external.InneractiveErrorCode;
import com.fyber.inneractive.sdk.external.InneractiveFullScreenAdRewardedListener;
import com.fyber.inneractive.sdk.external.InneractiveFullscreenAdEventsListener;
import com.fyber.inneractive.sdk.external.InneractiveFullscreenUnitController;
import com.fyber.inneractive.sdk.external.InneractiveUnitController;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;

import java.util.List;

public class Yodo1MasFyberRewardAdapter extends Yodo1MasRewardAdapterBase {

    private final InneractiveAdSpot.RequestListener rewardListener = new InneractiveAdSpot.RequestListener() {

        @Override
        public void onInneractiveSuccessfulAdRequest(InneractiveAdSpot inneractiveAdSpot) {

            String message = "method: onInneractiveSuccessfulAdRequest, reward: ";
            Yodo1MasLog.v(TAG, message);
            callbackLoad();
        }

        @Override
        public void onInneractiveFailedAdRequest(InneractiveAdSpot inneractiveAdSpot, InneractiveErrorCode inneractiveErrorCode) {
            String message = "method: onInneractiveFailedAdRequest, reward errorCode:" + inneractiveErrorCode.name();
            Yodo1MasLog.v(TAG, message);

            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            callbackError(error, inneractiveErrorCode.ordinal(), message);
        }
    };
    private final InneractiveFullscreenAdEventsListener eventsListener = new InneractiveFullscreenAdEventsListener() {
        @Override
        public void onAdDismissed(InneractiveAdSpot inneractiveAdSpot) {
            String message = "method: onAdDismissed, reward: ";
            Yodo1MasLog.v(TAG, message);
            callbackClose();
        }

        @Override
        public void onAdClicked(InneractiveAdSpot inneractiveAdSpot) {
            String message = "method: onAdClicked, reward: ";
            Yodo1MasLog.v(TAG, message);
            callbackClick();
        }

        @Override
        public void onAdImpression(InneractiveAdSpot inneractiveAdSpot) {
            String message = "method: onAdImpression, reward: ";
            Yodo1MasLog.v(TAG, message);
        }

        @Override
        public void onAdWillOpenExternalApp(InneractiveAdSpot inneractiveAdSpot) {
            String message = "method: onAdWillOpenExternalApp, reward: ";
            Yodo1MasLog.v(TAG, message);
        }

        @Override
        public void onAdEnteredErrorState(InneractiveAdSpot inneractiveAdSpot, InneractiveUnitController.AdDisplayError adDisplayError) {
            String message = "method: onAdEnteredErrorState, reward: ";
            Yodo1MasLog.v(TAG, message);
        }

        @Override
        public void onAdWillCloseInternalBrowser(InneractiveAdSpot inneractiveAdSpot) {
            String message = "method: onAdWillCloseInternalBrowser, reward: ";
            Yodo1MasLog.v(TAG, message);
        }
    };
    private final InneractiveFullScreenAdRewardedListener earnedListener = new InneractiveFullScreenAdRewardedListener() {
        @Override
        public void onAdRewarded(InneractiveAdSpot inneractiveAdSpot) {
            String message1 = "method: onAdRewarded, reward: ";
            Yodo1MasLog.v(TAG, message1);
            callbackEarned();
        }
    };
    private InneractiveAdSpot rewardAd;

    public Yodo1MasFyberRewardAdapter(List<Yodo1MasAdapterBase.AdId> unitIds) {
        super(unitIds);
    }

    @Override
    public boolean isRewardAdLoaded() {
        return rewardAd != null && rewardAd.isReady();
    }

    @Override
    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);

        if (rewardStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) return;
        String message = "method: loadRewardAdvert, loading reward ad...";
        Yodo1MasLog.v(TAG, message);

        rewardStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;

        InneractiveFullscreenUnitController controller = new InneractiveFullscreenUnitController();
        controller.setRewardedListener(earnedListener);
        controller.setEventsListener(eventsListener);

        InneractiveAdRequest adRequest = new InneractiveAdRequest("");

        rewardAd = InneractiveAdSpotManager.get().createSpot();
        rewardAd.addUnitController(controller);
        rewardAd.setRequestListener(rewardListener);
        rewardAd.requestAd(adRequest);
        //InneractiveFullscreenUnitController controller = (InneractiveFullscreenUnitController) rewardAd.getSelectedUnitController();
    }

    @Override
    public void showRewardAdvertFromActivity(@NonNull Activity activity) {
        super.showRewardAdvertFromActivity(activity);
        if (isRewardAdLoaded()) {
            String message = "method: showRewardAdvert, show reward ad...";
            Yodo1MasLog.v(TAG, message);
            InneractiveFullscreenUnitController controller = (InneractiveFullscreenUnitController) rewardAd.getSelectedUnitController();
            controller.show(activity);
            callbackOpen();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (rewardAd != null) {
            rewardAd.destroy();
        }
        rewardAd = null;
    }
}
