/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.fyber;

import android.app.Activity;
import androidx.annotation.NonNull;
import com.fyber.inneractive.sdk.external.InneractiveAdRequest;
import com.fyber.inneractive.sdk.external.InneractiveAdSpot;
import com.fyber.inneractive.sdk.external.InneractiveAdSpotManager;
import com.fyber.inneractive.sdk.external.InneractiveErrorCode;
import com.fyber.inneractive.sdk.external.InneractiveFullScreenAdRewardedListener;
import com.fyber.inneractive.sdk.external.InneractiveFullscreenAdEventsListener;
import com.fyber.inneractive.sdk.external.InneractiveFullscreenUnitController;
import com.fyber.inneractive.sdk.external.InneractiveUnitController;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import java.util.List;

public class Yodo1MasFyberRewardAdapter
extends Yodo1MasRewardAdapterBase {
    private final InneractiveAdSpot.RequestListener rewardListener = new InneractiveAdSpot.RequestListener(){

        public void onInneractiveSuccessfulAdRequest(InneractiveAdSpot inneractiveAdSpot) {
            String message = "method: onInneractiveSuccessfulAdRequest, reward: ";
            Yodo1MasLog.v((String)Yodo1MasFyberRewardAdapter.this.TAG, (String)message);
            Yodo1MasFyberRewardAdapter.this.callbackLoad();
        }

        public void onInneractiveFailedAdRequest(InneractiveAdSpot inneractiveAdSpot, InneractiveErrorCode inneractiveErrorCode) {
            String message = "method: onInneractiveFailedAdRequest, reward errorCode:" + inneractiveErrorCode.name();
            Yodo1MasLog.v((String)Yodo1MasFyberRewardAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasFyberRewardAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasFyberRewardAdapter.this.callbackError(error, inneractiveErrorCode.ordinal(), message);
        }
    };
    private final InneractiveFullscreenAdEventsListener eventsListener = new InneractiveFullscreenAdEventsListener(){

        public void onAdDismissed(InneractiveAdSpot inneractiveAdSpot) {
            String message = "method: onAdDismissed, reward: ";
            Yodo1MasLog.v((String)Yodo1MasFyberRewardAdapter.this.TAG, (String)message);
            Yodo1MasFyberRewardAdapter.this.callbackClose();
        }

        public void onAdClicked(InneractiveAdSpot inneractiveAdSpot) {
            String message = "method: onAdClicked, reward: ";
            Yodo1MasLog.v((String)Yodo1MasFyberRewardAdapter.this.TAG, (String)message);
            Yodo1MasFyberRewardAdapter.this.callbackClick();
        }

        public void onAdImpression(InneractiveAdSpot inneractiveAdSpot) {
            String message = "method: onAdImpression, reward: ";
            Yodo1MasLog.v((String)Yodo1MasFyberRewardAdapter.this.TAG, (String)message);
        }

        public void onAdWillOpenExternalApp(InneractiveAdSpot inneractiveAdSpot) {
            String message = "method: onAdWillOpenExternalApp, reward: ";
            Yodo1MasLog.v((String)Yodo1MasFyberRewardAdapter.this.TAG, (String)message);
        }

        public void onAdEnteredErrorState(InneractiveAdSpot inneractiveAdSpot, InneractiveUnitController.AdDisplayError adDisplayError) {
            String message = "method: onAdEnteredErrorState, reward: ";
            Yodo1MasLog.v((String)Yodo1MasFyberRewardAdapter.this.TAG, (String)message);
        }

        public void onAdWillCloseInternalBrowser(InneractiveAdSpot inneractiveAdSpot) {
            String message = "method: onAdWillCloseInternalBrowser, reward: ";
            Yodo1MasLog.v((String)Yodo1MasFyberRewardAdapter.this.TAG, (String)message);
        }
    };
    private final InneractiveFullScreenAdRewardedListener earnedListener = new InneractiveFullScreenAdRewardedListener(){

        public void onAdRewarded(InneractiveAdSpot inneractiveAdSpot) {
            String message1 = "method: onAdRewarded, reward: ";
            Yodo1MasLog.v((String)Yodo1MasFyberRewardAdapter.this.TAG, (String)message1);
            Yodo1MasFyberRewardAdapter.this.callbackEarned();
        }
    };
    private InneractiveAdSpot rewardAd;

    public Yodo1MasFyberRewardAdapter(List<Yodo1MasAdapterBase.AdId> unitIds) {
        super(unitIds);
    }

    public boolean isRewardAdLoaded() {
        return this.rewardAd != null && this.rewardAd.isReady();
    }

    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);
        if (this.rewardStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) {
            return;
        }
        String message = "method: loadRewardAdvert, loading reward ad...";
        Yodo1MasLog.v((String)this.TAG, (String)message);
        this.rewardStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        InneractiveFullscreenUnitController controller = new InneractiveFullscreenUnitController();
        controller.setRewardedListener(this.earnedListener);
        controller.setEventsListener((InneractiveUnitController.EventsListener)this.eventsListener);
        InneractiveAdRequest adRequest = new InneractiveAdRequest("");
        this.rewardAd = InneractiveAdSpotManager.get().createSpot();
        this.rewardAd.addUnitController((InneractiveUnitController)controller);
        this.rewardAd.setRequestListener(this.rewardListener);
        this.rewardAd.requestAd(adRequest);
    }

    public void showRewardAdvertFromActivity(@NonNull Activity activity) {
        super.showRewardAdvertFromActivity(activity);
        if (this.isRewardAdLoaded()) {
            String message = "method: showRewardAdvert, show reward ad...";
            Yodo1MasLog.v((String)this.TAG, (String)message);
            InneractiveFullscreenUnitController controller = (InneractiveFullscreenUnitController)this.rewardAd.getSelectedUnitController();
            controller.show(activity);
            this.callbackOpen();
        }
    }

    public void destroy() {
        super.destroy();
        if (this.rewardAd != null) {
            this.rewardAd.destroy();
        }
        this.rewardAd = null;
    }
}

