package com.yodo1.mas.mediation.inmobi;

import android.app.Activity;
import android.text.TextUtils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.inmobi.sdk.InMobiSdk;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.appopenad.Yodo1MasAppOpenAdapterBase;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.helper.Yodo1MasHelper;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.nativeads.Yodo1MasNativeAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import com.yodo1.mas.rewardedinterstitial.Yodo1MasRewardedInterstitialAdapterBase;

import org.json.JSONException;
import org.json.JSONObject;

public class Yodo1MasInMobiAdapter extends Yodo1MasAdapterBase {

    public static void setInMobiPrivacy() {
        JSONObject json = new JSONObject();
        try {
            json.put(InMobiSdk.IM_GDPR_CONSENT_AVAILABLE, Yodo1MasHelper.getInstance().isGDPRUserConsent());
            json.put("gdpr", Yodo1MasHelper.getInstance().isGDPRUserConsent() ? "1" : "0");
        } catch (JSONException e) {
            e.printStackTrace();
        }
        InMobiSdk.updateGDPRConsent(json);
        InMobiSdk.setIsAgeRestricted(Yodo1MasHelper.getInstance().isCOPPAAgeRestricted());
    }

    @Override
    public String getAdvertCode() {
        return "inmobi";
    }

    @Override
    public String getSDKVersion() {
        return BuildConfig.SDK_VERSION_NAME;
    }

    @Override
    public String getMediationVersion() {
        return BuildConfig.MAS_VERSION_NAME;
    }

    @Override
    public void initSDK(@NonNull Activity activity, @NonNull Config config, @Nullable InitCallback callback) {
        super.initSDK(activity, config, callback);
        if (!isInitSDK()) {
            if (!TextUtils.isEmpty(config.appId)) {
                InMobiSdk.init(applicationContext, config.appId, null, error -> {
                    String message = "method: onInitializationComplete, error: " + (error != null ? error.toString() : null);
                    Yodo1MasLog.d(TAG, message);

                    if (error == null) {
                        init = true;
                        updatePrivacy();

                        if (callback != null) {
                            callback.onAdapterInitSuccessful(getAdvertCode());
                        }
                    } else {
                        init = false;
                        if (callback != null) {
                            callback.onAdapterInitFailed(getAdvertCode(), new Yodo1MasError(Yodo1MasError.CODE_ADVERT_UNINITIALIZED, error.getMessage()));
                        }
                    }
                });
            } else {
                if (callback != null) {
                    callback.onAdapterInitFailed(getAdvertCode(), new Yodo1MasError(Yodo1MasError.CODE_ADVERT_UNINITIALIZED, "config.appId is null"));
                }
            }
        } else {
            if (callback != null) {
                callback.onAdapterInitSuccessful(getAdvertCode());
            }
        }
    }

    @Override
    public void updatePrivacy() {
        super.updatePrivacy();
        setInMobiPrivacy();
    }

    // Reward
    @Override
    protected Class<? extends Yodo1MasRewardAdapterBase> rewardAdapterClass() {
        return Yodo1MasInMobiRewardAdapter.class;
    }

    // Interstitial
    @Override
    protected Class<? extends Yodo1MasInterstitialAdapterBase> interstitialAdapterClass() {
        return Yodo1MasInMobiInterstitialAdapter.class;
    }

    // Native
    @Override
    public Class<? extends Yodo1MasNativeAdapterBase> nativeAdapterClass() {
        return null;
    }

    // Banner
    @Override
    public Class<? extends Yodo1MasBannerAdapterBase> bannerAdapterClass() {
        return Yodo1MasInMobiBannerAdapter.class;
    }

    // Rewarded Interstitial
    @Override
    protected Class<? extends Yodo1MasRewardedInterstitialAdapterBase> rewardedInterstitialAdapterClass() {
        return null;
    }

    // App Open
    @Override
    protected Class<? extends Yodo1MasAppOpenAdapterBase> appOpenAdapterClass() {
        return null;
    }
}
