package com.yodo1.mas.mediation.inmobi;

import android.app.Activity;
import android.text.TextUtils;
import android.view.View;
import android.widget.RelativeLayout;

import androidx.annotation.NonNull;

import com.inmobi.ads.AdMetaInfo;
import com.inmobi.ads.InMobiAdRequestStatus;
import com.inmobi.ads.InMobiBanner;
import com.inmobi.ads.listeners.BannerAdEventListener;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.event.Yodo1MasAdEvent;
import com.yodo1.mas.helper.model.Yodo1MasNetworkPlacement;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;

import java.util.List;

public class Yodo1MasInMobiBannerAdapter extends Yodo1MasBannerAdapterBase {

    private final BannerAdEventListener bannerListener = new BannerAdEventListener() {

        @Override
        public void onAdDisplayed(@NonNull InMobiBanner banner) {
            String message = "method: onAdDisplayed, banner: " + banner;
            Yodo1MasLog.d(TAG, message);
            callback(Yodo1MasAdEvent.CODE_OPENED, TAG + ":{" + message + "}");
        }

        @Override
        public void onAdDismissed(@NonNull InMobiBanner banner) {
            String message = "method: onAdDismissed, banner: " + banner;
            Yodo1MasLog.d(TAG, message);
            bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            callback(Yodo1MasAdEvent.CODE_CLOSED, TAG + ":{" + message + "}");
            loadBannerAdvert();
        }

        @Override
        public void onAdLoadSucceeded(@NonNull InMobiBanner banner, @NonNull AdMetaInfo adMetaInfo) {
            String message = "method: onAdLoadSucceeded, banner with bid: " + adMetaInfo.getBid();
            Yodo1MasLog.d(TAG, message);
            bannerState = Yodo1MasAdapterBase.AdvertState.LOADED;
            price = adMetaInfo.getBid();
            trackAdRequestSuccessed();
            callback(Yodo1MasAdEvent.CODE_LOADED, TAG + ":{" + message + "}");

            double price = adMetaInfo.getBid();
            for (Yodo1MasAdapterBase.AdId adId : bannerAdIds) {
                if (adId != null && adId.object != null) {
                    Yodo1MasNetworkPlacement placement = (Yodo1MasNetworkPlacement) adId.object;
                    if (TextUtils.equals(placement.price_type, "bidding")) {
                        placement.price = price;
                    }
                }
            }
            advertAdapterState = AdvertAdapterState.LOADED;
            callbackAdapterState();
        }

        @Override
        public void onAdFetchFailed(@NonNull InMobiBanner banner, @NonNull InMobiAdRequestStatus status) {
            String message = "method: onAdFetchFailed, banner: " + banner + ", status: " + status;
            Yodo1MasLog.d(TAG, message);
            bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            trackAdRequestFailed(status.getStatusCode().toString(), status.getMessage());

            if (isLastPlacement()) {
                Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
                callback(error);
                advertAdapterState = AdvertAdapterState.FAILED;
                callbackAdapterState();
            } else {
                nextBanner();
                loadBannerAdvertDelayed();
            }
        }
    };
    private InMobiBanner bannerAd;

    public Yodo1MasInMobiBannerAdapter(List<Yodo1MasAdapterBase.AdId> adIds) {
        super(adIds);
    }

    @Override
    public boolean isBannerAdvertLoaded() {
        super.isBannerAdvertLoaded();
        return bannerAd != null && getBannerAdId() != null && bannerState == Yodo1MasAdapterBase.AdvertState.LOADED;
    }

    @Override
    public void loadBannerAdvert(@NonNull Activity activity) {
        super.loadBannerAdvert(activity);
        if (relateAdapter == null || !relateAdapter.isInitSDK()) {
            return;
        }

        Yodo1MasAdapterBase.AdId adId = getBannerAdId();
        if (adId != null && !TextUtils.isEmpty(adId.adId)) {
            bannerAd = new InMobiBanner(activity, Long.parseLong(adId.adId));
//            bannerAd.setBannerSize(320, 50);
            bannerAd.setRefreshInterval(60);
            bannerAd.setListener(bannerListener);
        }
        if (bannerAd != null && bannerState != Yodo1MasAdapterBase.AdvertState.LOADING) {
            String message = "method: loadBannerAdvert, show banner ad...";
            Yodo1MasLog.d(TAG, message);
            setBannerLayoutParams(activity);
            bannerAd.load();
            bannerState = Yodo1MasAdapterBase.AdvertState.LOADING;
            advertAdapterState = AdvertAdapterState.LOADING;
            logAdIdInfo(adId);
        }
    }

    private void setBannerLayoutParams(Activity activity) {
        int width = toPixelUnits(activity, 320);
        int height = toPixelUnits(activity, 50);
        RelativeLayout.LayoutParams bannerLayoutParams = new RelativeLayout.LayoutParams(width, height);
        bannerLayoutParams.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
        bannerLayoutParams.addRule(RelativeLayout.CENTER_HORIZONTAL);
        bannerAd.setLayoutParams(bannerLayoutParams);
    }

    private int toPixelUnits(Activity activity, int dipUnit) {
        float density = activity.getResources().getDisplayMetrics().density;
        return Math.round(dipUnit * density);
    }

    @Override
    public View getBannerView() {
        return bannerAd;
    }

    @Override
    public void dismissBannerAdvert(boolean destroy) {
        super.dismissBannerAdvert(destroy);
        if (bannerAd != null) {
            if (destroy) {
                bannerAd.destroy();
                bannerAd = null;
                bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
                advertAdapterState = AdvertAdapterState.NONE;
            }
        }
    }

    @Override
    public boolean isSupportMultipleInstance() {
        return false;
    }
    
}
