package com.yodo1.mas.mediation.inmobi;

import android.app.Activity;
import android.text.TextUtils;

import androidx.annotation.NonNull;

import com.inmobi.ads.AdMetaInfo;
import com.inmobi.ads.InMobiAdRequestStatus;
import com.inmobi.ads.InMobiInterstitial;
import com.inmobi.ads.listeners.InterstitialAdEventListener;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.analytics.model.Yodo1MasAdRequestResultInfo;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.utils.Yodo1MasAdRequestTrackUtil;

import java.util.Map;

public class Yodo1MasInMobiInterstitialAdapter extends Yodo1MasInterstitialAdapterBase {

    private final InterstitialAdEventListener interstitialListener = new InterstitialAdEventListener() {
        @Override
        public void onAdLoadSucceeded(@NonNull InMobiInterstitial inMobiInterstitial, @NonNull AdMetaInfo adMetaInfo) {
            super.onAdLoadSucceeded(inMobiInterstitial, adMetaInfo);
            String message = "method: onAdLoadSucceeded, interstitial: " + inMobiInterstitial + ", adMetaInfo: " + adMetaInfo;
            Yodo1MasLog.d(TAG, message);
            adRequestResult
                    = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult(Yodo1Mas.AdType.Interstitial
                    , advertCode, getAdUnitId(), true, getAdLoadDuration(), null, null);
            callbackLoad(adRequestResult);
        }

        @Override
        public void onAdLoadFailed(@NonNull InMobiInterstitial interstitial, @NonNull InMobiAdRequestStatus status) {
            String message = "method: onAdLoadFailed, interstitial: " + interstitial + ", status: " + status;
            Yodo1MasLog.d(TAG, message);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            adRequestResult
                    = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult(Yodo1Mas.AdType.Interstitial
                    , advertCode, getAdUnitId(), false, getAdLoadDuration(), status.getStatusCode().ordinal() + "", status.getMessage());
            callbackError(error, status.getStatusCode().ordinal(), status.getMessage(), adRequestResult);
        }

        @Override
        public void onAdDisplayed(@NonNull InMobiInterstitial interstitial, @NonNull AdMetaInfo info) {
            String message = "method: onAdDisplayed, interstitial: " + interstitial + ", info: " + info;
            Yodo1MasLog.d(TAG, message);
            callbackOpen();
        }

        @Override
        public void onAdDisplayFailed(@NonNull InMobiInterstitial interstitial) {
            String message = "method: onAdDisplayFailed, interstitial: " + interstitial;
            Yodo1MasLog.d(TAG, message);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_SHOW_FAIL, TAG + ":{" + message + "}");
            callbackError(error, 0, message, null);
        }

        @Override
        public void onAdDismissed(@NonNull InMobiInterstitial interstitial) {
            String message = "method: onAdDisplayed, interstitial: " + interstitial;
            Yodo1MasLog.d(TAG, message);
            callbackClose();
        }

        @Override
        public void onAdClicked(@NonNull InMobiInterstitial inMobiInterstitial, Map<Object, Object> map) {
            callbackClick();
        }
    };
    private InMobiInterstitial interstitialAd;

    public Yodo1MasInMobiInterstitialAdapter(Yodo1MasAdapterBase.AdId unitId) {
        super(unitId);
    }

    @Override
    public boolean isInterstitialAdLoaded() {
        return interstitialAd != null && interstitialAd.isReady();
    }

    @Override
    public void loadInterstitialAdvert(Activity activity) {
        super.loadInterstitialAdvert(activity);
        String adId = getAdUnitId();
        if (TextUtils.isEmpty(adId)) return;

        if (!isNetworkInited()) {
            String message = "method: loadInterstitialAdvert, the inmobi sdk has not been initialized yet ";
            Yodo1MasLog.d(TAG, message);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            String tdErrorMsg = "Yodo1Mas Inmobi network error: the inmobi sdk has not been initialized yet";
            adRequestResult
                    = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult(Yodo1Mas.AdType.Interstitial
                    , advertCode, getAdUnitId(), false, 0, null, tdErrorMsg);
            callbackError(error, 0, tdErrorMsg, adRequestResult);
            return;
        }

        if (interstitialStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) return;
        String message = "method: loadInterstitialAdvert, loading interstitial ad...";
        Yodo1MasLog.d(TAG, message);

        interstitialStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        adLoadStartTimeStamp = System.currentTimeMillis();
        interstitialAd = new InMobiInterstitial(activity.getApplicationContext(), Long.parseLong(adId), interstitialListener);
        interstitialAd.load();
    }

    @Override
    public void showInterstitialAdvertFromActivity(Activity activity) {
        super.showInterstitialAdvertFromActivity(activity);
        if (isInterstitialAdLoaded()) {
            String message = "method: showInterstitialAdvert, show interstitial ad...";
            Yodo1MasLog.d(TAG, message);
            interstitialAd.show();
        }
    }
}
