package com.yodo1.mas.mediation.inmobi;

import android.app.Activity;
import android.text.TextUtils;

import androidx.annotation.NonNull;

import com.inmobi.ads.AdMetaInfo;
import com.inmobi.ads.InMobiAdRequestStatus;
import com.inmobi.ads.InMobiInterstitial;
import com.inmobi.ads.listeners.InterstitialAdEventListener;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.analytics.model.Yodo1MasAdRequestResultInfo;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import com.yodo1.mas.utils.Yodo1MasAdRequestTrackUtil;

import java.util.Map;

public class Yodo1MasInMobiRewardAdapter extends Yodo1MasRewardAdapterBase {
    private final InterstitialAdEventListener rewardListener = new InterstitialAdEventListener() {

        @Override
        public void onAdLoadSucceeded(@NonNull InMobiInterstitial inMobiInterstitial, @NonNull AdMetaInfo adMetaInfo) {
            super.onAdLoadSucceeded(inMobiInterstitial, adMetaInfo);
            String message = "method: onAdLoadSucceeded, reward: " + inMobiInterstitial + ", adMetaInfo: " + adMetaInfo;
            Yodo1MasLog.d(TAG, message);
            adRequestResult
                    = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult(Yodo1Mas.AdType.Reward
                    , advertCode, getAdUnitId(), true, getAdLoadDuration(), null, null);
            callbackLoad(adRequestResult);
        }

        @Override
        public void onAdLoadFailed(@NonNull InMobiInterstitial reward, @NonNull InMobiAdRequestStatus status) {
            String message = "method: onAdLoadFailed, reward: " + reward + ", status: " + status;
            Yodo1MasLog.d(TAG, message);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            adRequestResult
                    = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult(Yodo1Mas.AdType.Reward
                    , advertCode, getAdUnitId(), false, getAdLoadDuration(), status.getStatusCode().ordinal() + "", status.getMessage());
            callbackError(error, status.getStatusCode().ordinal(), status.getMessage(), adRequestResult);
        }

        @Override
        public void onAdDisplayed(@NonNull InMobiInterstitial reward, @NonNull AdMetaInfo info) {
            String message = "method: onAdDisplayed, reward: " + reward + ", metaInfo: " + info;
            Yodo1MasLog.d(TAG, message);
            callbackOpen();
        }

        @Override
        public void onAdDisplayFailed(@NonNull InMobiInterstitial reward) {
            String message = "method: onAdDisplayFailed, reward: " + reward;
            Yodo1MasLog.d(TAG, message);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_SHOW_FAIL, TAG + ":{" + message + "}");
            callbackError(error, 0, message, null);
        }

        @Override
        public void onAdDismissed(@NonNull InMobiInterstitial reward) {
            String message = "method: onAdDismissed, reward: " + reward;
            Yodo1MasLog.d(TAG, message);
            callbackClose();
        }

        @Override
        public void onAdClicked(@NonNull InMobiInterstitial inMobiInterstitial, Map<Object, Object> map) {
            callbackClick();
        }

        @Override
        public void onRewardsUnlocked(@NonNull InMobiInterstitial reward, Map<Object, Object> map) {
            String message = "method: onRewardsUnlocked, reward: " + reward + ", map: " + map;
            Yodo1MasLog.d(TAG, message);
            callbackEarned();
        }
    };
    private InMobiInterstitial rewardAd;

    public Yodo1MasInMobiRewardAdapter(Yodo1MasAdapterBase.AdId unitId) {
        super(unitId);
    }

    @Override
    public boolean isRewardAdLoaded() {
        return rewardAd != null && rewardAd.isReady();
    }

    @Override
    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);

        String adId = getAdUnitId();
        if (TextUtils.isEmpty(adId)) return;

        if (!isNetworkInited()) {
            String message = "method: loadRewardAdvert, the inmobi sdk has not been initialized yet ";
            Yodo1MasLog.d(TAG, message);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            String tdErrorMsg = "Yodo1Mas Inmobi network error: the inmobi sdk has not been initialized yet";
            adRequestResult
                    = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult(Yodo1Mas.AdType.Reward
                    , advertCode, getAdUnitId(), false, 0, null, tdErrorMsg);
            callbackError(error, 0, tdErrorMsg, adRequestResult);
            return;
        }

        if (rewardStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) return;

        String message = "method: loadRewardAdvert, loading reward ad...";
        Yodo1MasLog.d(TAG, message);
        rewardStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        adLoadStartTimeStamp = System.currentTimeMillis();
        rewardAd = new InMobiInterstitial(activity.getApplicationContext(), Long.parseLong(adId), rewardListener);
        rewardAd.load();
    }

    @Override
    public void showRewardAdvertFromActivity(@NonNull Activity activity) {
        super.showRewardAdvertFromActivity(activity);
        if (isRewardAdLoaded()) {
            String message = "method: showRewardAdvert, show reward ad...";
            Yodo1MasLog.d(TAG, message);
            rewardAd.show();
        }
    }
}
