/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.inmobi;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.inmobi.sdk.InMobiSdk;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.helper.Yodo1MasHelper;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.mediation.inmobi.Yodo1MasInMobiBannerAdapter;
import com.yodo1.mas.mediation.inmobi.Yodo1MasInMobiInterstitialAdapter;
import com.yodo1.mas.mediation.inmobi.Yodo1MasInMobiRewardAdapter;
import com.yodo1.mas.nativeads.Yodo1MasNativeAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import org.json.JSONException;
import org.json.JSONObject;

public class Yodo1MasInMobiAdapter
extends Yodo1MasAdapterBase {
    public String getAdvertCode() {
        return "inmobi";
    }

    public String getSDKVersion() {
        return "10.0.7";
    }

    public String getMediationVersion() {
        return "4.7.2";
    }

    public void initSDK(@NonNull Activity activity, @NonNull Yodo1MasAdapterBase.Config config, @Nullable Yodo1MasAdapterBase.InitCallback callback) {
        super.initSDK(activity, config, callback);
        if (!this.isInitSDK()) {
            if (!TextUtils.isEmpty((CharSequence)config.appId)) {
                this.init = true;
                InMobiSdk.init((Context)this.applicationContext, (String)config.appId, null, error -> {
                    String message = "method: onInitializationComplete, error: " + (error != null ? error.toString() : null);
                    Log.d((String)this.TAG, (String)message);
                    if (error == null) {
                        this.updatePrivacy();
                        if (callback != null) {
                            callback.onAdapterInitSuccessful(this.getAdvertCode());
                        }
                    } else if (callback != null) {
                        callback.onAdapterInitFailed(this.getAdvertCode(), new Yodo1MasError(-600001, error.getMessage()));
                    }
                });
            } else if (callback != null) {
                callback.onAdapterInitFailed(this.getAdvertCode(), new Yodo1MasError(-600001, "config.appId is null"));
            }
        } else if (callback != null) {
            callback.onAdapterInitSuccessful(this.getAdvertCode());
        }
    }

    public void updatePrivacy() {
        super.updatePrivacy();
        Yodo1MasInMobiAdapter.setInMobiPrivacy();
    }

    public static void setInMobiPrivacy() {
        JSONObject json = new JSONObject();
        try {
            json.put("gdpr_consent_available", Yodo1MasHelper.getInstance().isGDPRUserConsent());
            json.put("gdpr", (Object)(Yodo1MasHelper.getInstance().isGDPRUserConsent() ? "1" : "0"));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        InMobiSdk.updateGDPRConsent((JSONObject)json);
        InMobiSdk.setIsAgeRestricted((boolean)Yodo1MasHelper.getInstance().isCOPPAAgeRestricted());
    }

    protected Class<? extends Yodo1MasRewardAdapterBase> rewardAdapterClass() {
        return Yodo1MasInMobiRewardAdapter.class;
    }

    protected Class<? extends Yodo1MasInterstitialAdapterBase> interstitialAdapterClass() {
        return Yodo1MasInMobiInterstitialAdapter.class;
    }

    public Class<? extends Yodo1MasNativeAdapterBase> nativeAdapterClass() {
        return null;
    }

    public Class<? extends Yodo1MasBannerAdapterBase> bannerAdapterClass() {
        return Yodo1MasInMobiBannerAdapter.class;
    }
}

