/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.inmobi;

import android.app.Activity;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import com.inmobi.ads.AdMetaInfo;
import com.inmobi.ads.InMobiAdRequestStatus;
import com.inmobi.ads.InMobiInterstitial;
import com.inmobi.ads.listeners.InterstitialAdEventListener;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import java.util.List;
import java.util.Map;

public class Yodo1MasInMobiInterstitialAdapter
extends Yodo1MasInterstitialAdapterBase {
    private InMobiInterstitial interstitialAd;
    private final InterstitialAdEventListener interstitialListener = new InterstitialAdEventListener(){

        public void onAdLoadSucceeded(@NonNull InMobiInterstitial inMobiInterstitial, @NonNull AdMetaInfo adMetaInfo) {
            super.onAdLoadSucceeded((Object)inMobiInterstitial, adMetaInfo);
            String message = "method: onAdLoadSucceeded, interstitial: " + inMobiInterstitial + ", adMetaInfo: " + adMetaInfo;
            Log.d((String)Yodo1MasInMobiInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasInMobiInterstitialAdapter.this.callbackLoad();
        }

        public void onAdLoadFailed(@NonNull InMobiInterstitial interstitial, @NonNull InMobiAdRequestStatus status) {
            String message = "method: onAdLoadFailed, interstitial: " + interstitial + ", status: " + status;
            Log.d((String)Yodo1MasInMobiInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasInMobiInterstitialAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasInMobiInterstitialAdapter.this.callbackError(error, status.getStatusCode().ordinal(), status.getMessage());
        }

        public void onAdDisplayed(@NonNull InMobiInterstitial interstitial, @NonNull AdMetaInfo info) {
            String message = "method: onAdDisplayed, interstitial: " + interstitial + ", info: " + info;
            Log.d((String)Yodo1MasInMobiInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasInMobiInterstitialAdapter.this.callbackOpen();
        }

        public void onAdDisplayFailed(@NonNull InMobiInterstitial interstitial) {
            String message = "method: onAdDisplayFailed, interstitial: " + interstitial;
            Log.d((String)Yodo1MasInMobiInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600201, Yodo1MasInMobiInterstitialAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasInMobiInterstitialAdapter.this.callbackError(error, 0, message);
        }

        public void onAdDismissed(@NonNull InMobiInterstitial interstitial) {
            String message = "method: onAdDisplayed, interstitial: " + interstitial;
            Log.d((String)Yodo1MasInMobiInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasInMobiInterstitialAdapter.this.callbackClose();
        }

        public void onAdClicked(@NonNull InMobiInterstitial inMobiInterstitial, Map<Object, Object> map) {
            Yodo1MasInMobiInterstitialAdapter.this.callbackClick();
        }
    };

    public Yodo1MasInMobiInterstitialAdapter(List<Yodo1MasAdapterBase.AdId> unitIds) {
        super(unitIds);
    }

    public boolean isInterstitialAdLoaded() {
        return this.interstitialAd != null && this.interstitialAd.isReady();
    }

    public void loadInterstitialAdvert(Activity activity) {
        super.loadInterstitialAdvert(activity);
        String adId = this.getAdUnitId(false);
        if (TextUtils.isEmpty((CharSequence)adId)) {
            return;
        }
        if (this.interstitialStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) {
            return;
        }
        String message = "method: loadInterstitialAdvert, loading interstitial ad...";
        Log.d((String)this.TAG, (String)message);
        this.interstitialStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        this.interstitialAd = new InMobiInterstitial(activity.getApplicationContext(), Long.parseLong(adId), this.interstitialListener);
        this.interstitialAd.load();
    }

    public void showInterstitialAdvertFromActivity(Activity activity) {
        super.showInterstitialAdvertFromActivity(activity);
        if (this.isInterstitialAdLoaded()) {
            String message = "method: showInterstitialAdvert, show interstitial ad...";
            Log.d((String)this.TAG, (String)message);
            this.interstitialAd.show();
        }
    }
}

