/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.inmobi;

import android.app.Activity;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.inmobi.ads.AdMetaInfo;
import com.inmobi.ads.InMobiAdRequestStatus;
import com.inmobi.ads.InMobiInterstitial;
import com.inmobi.ads.listeners.InterstitialAdEventListener;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import java.util.List;
import java.util.Map;

public class Yodo1MasInMobiRewardAdapter
extends Yodo1MasRewardAdapterBase {
    private InMobiInterstitial rewardAd;
    private final InterstitialAdEventListener rewardListener = new InterstitialAdEventListener(){

        public void onAdLoadSucceeded(@NonNull InMobiInterstitial inMobiInterstitial, @NonNull AdMetaInfo adMetaInfo) {
            super.onAdLoadSucceeded((Object)inMobiInterstitial, adMetaInfo);
            String message = "method: onAdLoadSucceeded, reward: " + inMobiInterstitial + ", adMetaInfo: " + adMetaInfo;
            Yodo1MasLog.v((String)Yodo1MasInMobiRewardAdapter.this.TAG, (String)message);
            Yodo1MasInMobiRewardAdapter.this.callbackLoad();
        }

        public void onAdLoadFailed(@NonNull InMobiInterstitial reward, @NonNull InMobiAdRequestStatus status) {
            String message = "method: onAdLoadFailed, reward: " + reward + ", status: " + status;
            Yodo1MasLog.v((String)Yodo1MasInMobiRewardAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasInMobiRewardAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasInMobiRewardAdapter.this.callbackError(error, status.getStatusCode().ordinal(), status.getMessage());
        }

        public void onAdDisplayed(@NonNull InMobiInterstitial reward, @NonNull AdMetaInfo info) {
            String message = "method: onAdDisplayed, reward: " + reward + ", metaInfo: " + info;
            Yodo1MasLog.v((String)Yodo1MasInMobiRewardAdapter.this.TAG, (String)message);
            Yodo1MasInMobiRewardAdapter.this.callbackOpen();
        }

        public void onAdDisplayFailed(@NonNull InMobiInterstitial reward) {
            String message = "method: onAdDisplayFailed, reward: " + reward;
            Yodo1MasLog.v((String)Yodo1MasInMobiRewardAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600201, Yodo1MasInMobiRewardAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasInMobiRewardAdapter.this.callbackError(error, 0, message);
        }

        public void onAdDismissed(@NonNull InMobiInterstitial reward) {
            String message = "method: onAdDismissed, reward: " + reward;
            Yodo1MasLog.v((String)Yodo1MasInMobiRewardAdapter.this.TAG, (String)message);
            Yodo1MasInMobiRewardAdapter.this.callbackClose();
        }

        public void onAdClicked(@NonNull InMobiInterstitial inMobiInterstitial, Map<Object, Object> map) {
            Yodo1MasInMobiRewardAdapter.this.callbackClick();
        }

        public void onRewardsUnlocked(@NonNull InMobiInterstitial reward, Map<Object, Object> map) {
            String message = "method: onRewardsUnlocked, reward: " + reward + ", map: " + map;
            Yodo1MasLog.v((String)Yodo1MasInMobiRewardAdapter.this.TAG, (String)message);
            Yodo1MasInMobiRewardAdapter.this.callbackEarned();
        }
    };

    public Yodo1MasInMobiRewardAdapter(List<Yodo1MasAdapterBase.AdId> unitIds) {
        super(unitIds);
    }

    public boolean isRewardAdLoaded() {
        return this.rewardAd != null && this.rewardAd.isReady();
    }

    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);
        String adId = this.getAdUnitId(false);
        if (TextUtils.isEmpty((CharSequence)adId)) {
            return;
        }
        if (this.rewardStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) {
            return;
        }
        String message = "method: loadRewardAdvert, loading reward ad...";
        Yodo1MasLog.v((String)this.TAG, (String)message);
        this.rewardStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        this.rewardAd = new InMobiInterstitial(activity.getApplicationContext(), Long.parseLong(adId), this.rewardListener);
        this.rewardAd.load();
    }

    public void showRewardAdvertFromActivity(@NonNull Activity activity) {
        super.showRewardAdvertFromActivity(activity);
        if (this.isRewardAdLoaded()) {
            String message = "method: showRewardAdvert, show reward ad...";
            Yodo1MasLog.v((String)this.TAG, (String)message);
            this.rewardAd.show();
        }
    }
}

