package com.yodo1.mas.mediation.inmobi;

import android.app.Activity;
import android.text.TextUtils;

import androidx.annotation.NonNull;

import com.inmobi.ads.AdMetaInfo;
import com.inmobi.ads.InMobiAdRequestStatus;
import com.inmobi.ads.InMobiInterstitial;
import com.inmobi.ads.listeners.InterstitialAdEventListener;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;

import java.util.List;
import java.util.Map;

public class Yodo1MasInMobiRewardAdapter extends Yodo1MasRewardAdapterBase {
    private InMobiInterstitial rewardAd;

    public Yodo1MasInMobiRewardAdapter(List<Yodo1MasAdapterBase.AdId> unitIds) {
        super(unitIds);
    }

    @Override
    public boolean isRewardAdLoaded() {
        return rewardAd != null && rewardAd.isReady();
    }

    @Override
    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);

        String adId = getAdUnitId(false);
        if (TextUtils.isEmpty(adId)) return;

        if (rewardStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) return;

        String message = "method: loadRewardAdvert, loading reward ad...";
        Yodo1MasLog.v(TAG, message);
        rewardStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        rewardAd = new InMobiInterstitial(activity.getApplicationContext(), Long.parseLong(adId), rewardListener);
        rewardAd.load();
    }

    @Override
    public void showRewardAdvertFromActivity(@NonNull Activity activity) {
        super.showRewardAdvertFromActivity(activity);
        if (isRewardAdLoaded()) {
            String message = "method: showRewardAdvert, show reward ad...";
            Yodo1MasLog.v(TAG, message);
            rewardAd.show();
        }
    }

    private final InterstitialAdEventListener rewardListener = new InterstitialAdEventListener() {

        @Override
        public void onAdLoadSucceeded(@NonNull InMobiInterstitial inMobiInterstitial, @NonNull AdMetaInfo adMetaInfo) {
            super.onAdLoadSucceeded(inMobiInterstitial, adMetaInfo);
            String message = "method: onAdLoadSucceeded, reward: " + inMobiInterstitial + ", adMetaInfo: " + adMetaInfo;
            Yodo1MasLog.v(TAG, message);
            callbackLoad();
        }

        @Override
        public void onAdLoadFailed(@NonNull InMobiInterstitial reward, @NonNull InMobiAdRequestStatus status) {
            String message = "method: onAdLoadFailed, reward: " + reward + ", status: " + status;
            Yodo1MasLog.v(TAG, message);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            callbackError(error, status.getStatusCode().ordinal(), status.getMessage());
        }

        @Override
        public void onAdDisplayed(@NonNull InMobiInterstitial reward, @NonNull AdMetaInfo info) {
            String message = "method: onAdDisplayed, reward: " + reward + ", metaInfo: " + info;
            Yodo1MasLog.v(TAG, message);
            callbackOpen();
        }

        @Override
        public void onAdDisplayFailed(@NonNull InMobiInterstitial reward) {
            String message = "method: onAdDisplayFailed, reward: " + reward;
            Yodo1MasLog.v(TAG, message);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_SHOW_FAIL, TAG + ":{" + message + "}");
            callbackError(error, 0, message);
        }

        @Override
        public void onAdDismissed(@NonNull InMobiInterstitial reward) {
            String message = "method: onAdDismissed, reward: " + reward;
            Yodo1MasLog.v(TAG, message);
            callbackClose();
        }

        @Override
        public void onAdClicked(@NonNull InMobiInterstitial inMobiInterstitial, Map<Object, Object> map) {
            callbackClick();
        }

        @Override
        public void onRewardsUnlocked(@NonNull InMobiInterstitial reward, Map<Object, Object> map) {
            String message = "method: onRewardsUnlocked, reward: " + reward + ", map: " + map;
            Yodo1MasLog.v(TAG, message);
            callbackEarned();
        }
    };
}
