/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.inmobi;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import com.inmobi.ads.AdMetaInfo;
import com.inmobi.ads.InMobiAdRequestStatus;
import com.inmobi.ads.InMobiBanner;
import com.inmobi.ads.listeners.BannerAdEventListener;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.helper.model.Yodo1MasNetworkPlacement;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import java.util.List;

public class Yodo1MasInMobiBannerAdapter
extends Yodo1MasBannerAdapterBase {
    private final BannerAdEventListener bannerListener = new BannerAdEventListener(){

        public void onAdDisplayed(@NonNull InMobiBanner banner) {
            String message = "method: onAdDisplayed, banner: " + banner;
            Yodo1MasLog.d((String)Yodo1MasInMobiBannerAdapter.this.TAG, (String)message);
            Yodo1MasInMobiBannerAdapter.this.callback(1001, Yodo1MasInMobiBannerAdapter.this.TAG + ":{" + message + "}");
        }

        public void onAdDismissed(@NonNull InMobiBanner banner) {
            String message = "method: onAdDismissed, banner: " + banner;
            Yodo1MasLog.d((String)Yodo1MasInMobiBannerAdapter.this.TAG, (String)message);
            Yodo1MasInMobiBannerAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            Yodo1MasInMobiBannerAdapter.this.callback(1002, Yodo1MasInMobiBannerAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasInMobiBannerAdapter.this.loadBannerAdvert();
        }

        public void onAdLoadSucceeded(@NonNull InMobiBanner banner, @NonNull AdMetaInfo adMetaInfo) {
            String message = "method: onAdLoadSucceeded, banner with bid: " + adMetaInfo.getBid();
            Yodo1MasLog.d((String)Yodo1MasInMobiBannerAdapter.this.TAG, (String)message);
            Yodo1MasInMobiBannerAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.LOADED;
            Yodo1MasInMobiBannerAdapter.this.trackAdRequestSuccessed();
            Yodo1MasInMobiBannerAdapter.this.callback(1003, Yodo1MasInMobiBannerAdapter.this.TAG + ":{" + message + "}");
            double price = adMetaInfo.getBid();
            for (Yodo1MasAdapterBase.AdId adId : Yodo1MasInMobiBannerAdapter.this.bannerAdIds) {
                if (adId == null || adId.object == null) continue;
                Yodo1MasNetworkPlacement placement = (Yodo1MasNetworkPlacement)adId.object;
                if (!TextUtils.equals((CharSequence)placement.price_type, (CharSequence)"bidding")) continue;
                placement.price = price;
            }
            Yodo1MasInMobiBannerAdapter.this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.LOADED;
            Yodo1MasInMobiBannerAdapter.this.callbackAdapterState();
        }

        public void onAdFetchFailed(@NonNull InMobiBanner banner, @NonNull InMobiAdRequestStatus status) {
            String message = "method: onAdFetchFailed, banner: " + banner + ", status: " + status;
            Yodo1MasLog.d((String)Yodo1MasInMobiBannerAdapter.this.TAG, (String)message);
            Yodo1MasInMobiBannerAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            Yodo1MasInMobiBannerAdapter.this.trackAdRequestFailed(status.getStatusCode().toString(), status.getMessage());
            if (Yodo1MasInMobiBannerAdapter.this.isLastPlacement()) {
                Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasInMobiBannerAdapter.this.TAG + ":{" + message + "}");
                Yodo1MasInMobiBannerAdapter.this.callback(error);
                Yodo1MasInMobiBannerAdapter.this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.FAILED;
                Yodo1MasInMobiBannerAdapter.this.callbackAdapterState();
            } else {
                Yodo1MasInMobiBannerAdapter.this.nextBanner();
                Yodo1MasInMobiBannerAdapter.this.loadBannerAdvertDelayed();
            }
        }
    };
    private InMobiBanner bannerAd;

    public Yodo1MasInMobiBannerAdapter(List<Yodo1MasAdapterBase.AdId> adIds) {
        super(adIds);
    }

    public boolean isBannerAdvertLoaded() {
        super.isBannerAdvertLoaded();
        return this.bannerAd != null && this.getBannerAdId() != null && this.bannerState == Yodo1MasAdapterBase.AdvertState.LOADED;
    }

    public void loadBannerAdvert(@NonNull Activity activity) {
        super.loadBannerAdvert(activity);
        if (this.relateAdapter == null || !this.relateAdapter.isInitSDK()) {
            return;
        }
        Yodo1MasAdapterBase.AdId adId = this.getBannerAdId();
        if (adId != null && !TextUtils.isEmpty((CharSequence)adId.adId)) {
            this.bannerAd = new InMobiBanner((Context)activity, Long.parseLong(adId.adId));
            this.bannerAd.setRefreshInterval(60);
            this.bannerAd.setListener(this.bannerListener);
        }
        if (this.bannerAd != null && this.bannerState != Yodo1MasAdapterBase.AdvertState.LOADING) {
            String message = "method: loadBannerAdvert, show banner ad...";
            Yodo1MasLog.d((String)this.TAG, (String)message);
            this.setBannerLayoutParams(activity);
            this.bannerAd.load();
            this.bannerState = Yodo1MasAdapterBase.AdvertState.LOADING;
            this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.LOADING;
            this.logAdIdInfo(adId);
        }
    }

    private void setBannerLayoutParams(Activity activity) {
        int width = this.toPixelUnits(activity, 320);
        int height = this.toPixelUnits(activity, 50);
        RelativeLayout.LayoutParams bannerLayoutParams = new RelativeLayout.LayoutParams(width, height);
        bannerLayoutParams.addRule(12);
        bannerLayoutParams.addRule(14);
        this.bannerAd.setLayoutParams((ViewGroup.LayoutParams)bannerLayoutParams);
    }

    private int toPixelUnits(Activity activity, int dipUnit) {
        float density = activity.getResources().getDisplayMetrics().density;
        return Math.round((float)dipUnit * density);
    }

    public View getBannerView() {
        return this.bannerAd;
    }

    public void dismissBannerAdvert(boolean destroy) {
        super.dismissBannerAdvert(destroy);
        if (this.bannerAd != null && destroy) {
            this.bannerAd.destroy();
            this.bannerAd = null;
            this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.NONE;
        }
    }

    public boolean isSupportMultipleInstance() {
        return false;
    }
}

