/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.ironsource;

import android.app.Activity;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.NonNull;
import com.ironsource.mediationsdk.ISBannerSize;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.IronSourceBannerLayout;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.sdk.BannerListener;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.banner.Yodo1MasBannerAdSize;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import java.util.List;

public class Yodo1MasIronSourceBannerAdapter
extends Yodo1MasBannerAdapterBase {
    private final BannerListener bannerListener = new BannerListener(){

        public void onBannerAdLoaded() {
            String message = "method: onBannerAdLoaded";
            Yodo1MasLog.d((String)Yodo1MasIronSourceBannerAdapter.this.TAG, (String)message);
            Yodo1MasIronSourceBannerAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.LOADED;
            Yodo1MasIronSourceBannerAdapter.this.trackAdRequestSuccessed();
            Yodo1MasIronSourceBannerAdapter.this.callback(1003, Yodo1MasIronSourceBannerAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasIronSourceBannerAdapter.this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.LOADED;
            Yodo1MasIronSourceBannerAdapter.this.callbackAdapterState();
        }

        public void onBannerAdLoadFailed(IronSourceError adError) {
            String message = "method: onBannerAdLoadFailed, error:" + adError.toString();
            Yodo1MasLog.d((String)Yodo1MasIronSourceBannerAdapter.this.TAG, (String)message);
            Yodo1MasIronSourceBannerAdapter.this.trackAdRequestFailed(adError.getErrorCode(), adError.getErrorMessage());
            Yodo1MasIronSourceBannerAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            if (Yodo1MasIronSourceBannerAdapter.this.isLastPlacement()) {
                Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasIronSourceBannerAdapter.this.TAG + ":{" + message + "}");
                Yodo1MasIronSourceBannerAdapter.this.callback(error);
                Yodo1MasIronSourceBannerAdapter.this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.FAILED;
                Yodo1MasIronSourceBannerAdapter.this.callbackAdapterState();
            } else {
                Yodo1MasIronSourceBannerAdapter.this.nextBanner();
                Yodo1MasIronSourceBannerAdapter.this.loadBannerAdvertDelayed();
            }
        }

        public void onBannerAdClicked() {
            String message = "method: onBannerAdClicked";
            Yodo1MasLog.d((String)Yodo1MasIronSourceBannerAdapter.this.TAG, (String)message);
        }

        public void onBannerAdScreenPresented() {
            String message = "method: onBannerAdScreenPresented";
            Yodo1MasLog.d((String)Yodo1MasIronSourceBannerAdapter.this.TAG, (String)message);
            Yodo1MasIronSourceBannerAdapter.this.callback(1001, Yodo1MasIronSourceBannerAdapter.this.TAG + ":{" + message + "}");
        }

        public void onBannerAdScreenDismissed() {
            String message = "method: onBannerAdScreenDismissed";
            Yodo1MasLog.d((String)Yodo1MasIronSourceBannerAdapter.this.TAG, (String)message);
            Yodo1MasIronSourceBannerAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            Yodo1MasIronSourceBannerAdapter.this.callback(1002, Yodo1MasIronSourceBannerAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasIronSourceBannerAdapter.this.loadBannerAdvert();
        }

        public void onBannerAdLeftApplication() {
            String message = "method: onBannerAdLeftApplication";
            Yodo1MasLog.d((String)Yodo1MasIronSourceBannerAdapter.this.TAG, (String)message);
        }
    };
    private IronSourceBannerLayout bannerAd;

    public Yodo1MasIronSourceBannerAdapter(List<Yodo1MasAdapterBase.AdId> adIds) {
        super(adIds);
    }

    public boolean isBannerAdvertLoaded() {
        super.isBannerAdvertLoaded();
        Yodo1MasAdapterBase.AdId adId = this.getBannerAdId();
        return this.bannerAd != null && adId != null && !TextUtils.isEmpty((CharSequence)adId.adId) && this.bannerState == Yodo1MasAdapterBase.AdvertState.LOADED;
    }

    public void loadBannerAdvert(@NonNull Activity activity) {
        super.loadBannerAdvert(activity);
        if (this.relateAdapter == null || !this.relateAdapter.isInitSDK()) {
            return;
        }
        Yodo1MasAdapterBase.AdId adId = this.getBannerAdId();
        if (adId != null && adId.object != null && !this.isPriceValuable(adId)) {
            this.handlePricyNotAbaliable();
            return;
        }
        if (!(adId == null || TextUtils.isEmpty((CharSequence)adId.adId) || this.bannerAd != null && adId.adId.equals(this.bannerAd.getPlacementName()))) {
            ISBannerSize bannerSize = this.getBannerSize();
            this.bannerAd = new IronSourceBannerLayout(activity, bannerSize);
            this.bannerAd.setBannerListener(this.bannerListener);
            this.bannerAd.setPlacementName(adId.adId);
        }
        if (this.bannerAd != null && this.bannerState != Yodo1MasAdapterBase.AdvertState.LOADING) {
            String message = "method: loadBannerAdvert, loading banner ad...";
            Yodo1MasLog.d((String)this.TAG, (String)message);
            IronSource.loadBanner((IronSourceBannerLayout)this.bannerAd);
            this.bannerState = Yodo1MasAdapterBase.AdvertState.LOADING;
            this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.LOADING;
            this.logAdIdInfo(adId);
        }
    }

    private ISBannerSize getBannerSize() {
        Yodo1MasBannerAdSize size = this.bannerConfig.size;
        Yodo1MasLog.d((String)this.TAG, (String)("setBannerSize: size: " + size.name()));
        if (Yodo1MasBannerAdSize.Banner == size) {
            return ISBannerSize.BANNER;
        }
        return ISBannerSize.BANNER;
    }

    public View getBannerView() {
        return this.bannerAd;
    }

    public void dismissBannerAdvert(boolean destroy) {
        super.dismissBannerAdvert(destroy);
        if (this.bannerAd != null && destroy) {
            IronSource.destroyBanner((IronSourceBannerLayout)this.bannerAd);
            this.bannerAd = null;
            this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.NONE;
        }
    }

    public boolean isSupportMultipleInstance() {
        return false;
    }
}

