/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.ironsource;

import android.app.Activity;
import android.text.TextUtils;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.demandOnly.ISDemandOnlyInterstitialListener;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.analytics.model.Yodo1MasAdRequestResultInfo;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.utils.Yodo1MasAdRequestTrackUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Yodo1MasIronSourceInterstitialAdapter
extends Yodo1MasInterstitialAdapterBase {
    private static final Map<String, Yodo1MasIronSourceInterstitialAdapter> map = new HashMap<String, Yodo1MasIronSourceInterstitialAdapter>();
    private final ISDemandOnlyInterstitialListener interstitialListener = new ISDemandOnlyInterstitialListener(){

        public void onInterstitialAdReady(String placementId) {
            String message = "method: onInterstitialAdReady, placementId: " + placementId;
            Yodo1MasLog.d((String)Yodo1MasIronSourceInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasIronSourceInterstitialAdapter instance = Yodo1MasIronSourceInterstitialAdapter.this.getInstanceByPlacementId(placementId);
            if (instance != null) {
                Yodo1MasAdRequestResultInfo adRequestResult = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult((Yodo1Mas.AdType)Yodo1Mas.AdType.Interstitial, (String)Yodo1MasIronSourceInterstitialAdapter.this.advertCode, (String)placementId, (boolean)true, (long)instance.getAdLoadDuration(), null, null);
                instance.callbackLoad(adRequestResult);
            }
        }

        public void onInterstitialAdLoadFailed(String placementId, IronSourceError adError) {
            String message = "method: onInterstitialAdLoadFailed, placementId: " + placementId + ", error: " + adError.toString();
            Yodo1MasLog.d((String)Yodo1MasIronSourceInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasIronSourceInterstitialAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasIronSourceInterstitialAdapter instance = Yodo1MasIronSourceInterstitialAdapter.this.getInstanceByPlacementId(placementId);
            if (instance != null) {
                Yodo1MasAdRequestResultInfo adRequestResult = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult((Yodo1Mas.AdType)Yodo1Mas.AdType.Interstitial, (String)Yodo1MasIronSourceInterstitialAdapter.this.advertCode, (String)placementId, (boolean)false, (long)instance.getAdLoadDuration(), (String)(adError.getErrorCode() + ""), (String)adError.getErrorMessage());
                instance.callbackError(error, adError.getErrorCode(), adError.getErrorMessage(), adRequestResult);
            }
        }

        public void onInterstitialAdOpened(String placementId) {
            String message = "method: onInterstitialAdOpened, placementId: " + placementId;
            Yodo1MasLog.d((String)Yodo1MasIronSourceInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasIronSourceInterstitialAdapter.this.callbackOpen();
        }

        public void onInterstitialAdClosed(String placementId) {
            String message = "method: onInterstitialAdClosed, placementId: " + placementId;
            Yodo1MasLog.d((String)Yodo1MasIronSourceInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasIronSourceInterstitialAdapter.this.callbackClose();
        }

        public void onInterstitialAdShowFailed(String placementId, IronSourceError adError) {
            String message = "method: onInterstitialAdShowFailed, placementId: " + placementId + ", error: " + adError.toString();
            Yodo1MasLog.d((String)Yodo1MasIronSourceInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600201, Yodo1MasIronSourceInterstitialAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasIronSourceInterstitialAdapter.this.callbackError(error, adError.getErrorCode(), adError.getErrorMessage(), null);
        }

        public void onInterstitialAdClicked(String placementId) {
            String message = "method: onInterstitialAdClicked, placementId: " + placementId;
            Yodo1MasLog.d((String)Yodo1MasIronSourceInterstitialAdapter.this.TAG, (String)message);
            Yodo1MasIronSourceInterstitialAdapter.this.callbackClick();
        }
    };

    public Yodo1MasIronSourceInterstitialAdapter(Yodo1MasAdapterBase.AdId unitId) {
        super(unitId);
        IronSource.setISDemandOnlyInterstitialListener((ISDemandOnlyInterstitialListener)this.interstitialListener);
    }

    public boolean isInterstitialAdLoaded() {
        String adId = this.getAdUnitId();
        return !TextUtils.isEmpty((CharSequence)adId) && IronSource.isISDemandOnlyInterstitialReady((String)adId);
    }

    public void loadInterstitialAdvert(Activity activity) {
        super.loadInterstitialAdvert(activity);
        String adId = this.getAdUnitId();
        if (TextUtils.isEmpty((CharSequence)adId)) {
            return;
        }
        if (this.interstitialStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) {
            return;
        }
        String message = "method: loadInterstitialAdvert, load interstitial ad...";
        Yodo1MasLog.d((String)this.TAG, (String)message);
        this.interstitialStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        this.adLoadStartTimeStamp = System.currentTimeMillis();
        map.put(adId, this);
        IronSource.loadISDemandOnlyInterstitial((Activity)activity, (String)adId);
    }

    public void showInterstitialAdvertFromActivity(Activity activity) {
        super.showInterstitialAdvertFromActivity(activity);
        if (this.isInterstitialAdLoaded()) {
            String message = "method: showInterstitialAdvert, show interstitial ad...";
            Yodo1MasLog.d((String)this.TAG, (String)message);
            String adId = this.getAdUnitId();
            IronSource.showISDemandOnlyInterstitial((String)adId);
        }
    }

    private Yodo1MasIronSourceInterstitialAdapter getInstanceByPlacementId(String placementId) {
        if (map != null && map.containsKey(placementId)) {
            return map.get(placementId);
        }
        return null;
    }

    public void destroy() {
        super.destroy();
        Iterator<Map.Entry<String, Yodo1MasIronSourceInterstitialAdapter>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Yodo1MasIronSourceInterstitialAdapter> entry = iterator.next();
            if (!((Object)((Object)this)).equals((Object)entry.getValue())) continue;
            iterator.remove();
        }
    }
}

