/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.ironsource;

import android.app.Activity;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.NonNull;
import com.ironsource.mediationsdk.ISBannerSize;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.IronSourceBannerLayout;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.sdk.BannerListener;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.banner.Yodo1MasBannerAdSize;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import java.util.List;

public class Yodo1MasIronSourceMaxBannerAdapter
extends Yodo1MasBannerAdapterBase {
    private final BannerListener bannerListener = new BannerListener(){

        public void onBannerAdLoaded() {
            String message = "method: onBannerAdLoaded";
            Yodo1MasLog.d((String)Yodo1MasIronSourceMaxBannerAdapter.this.TAG, (String)message);
            Yodo1MasIronSourceMaxBannerAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.LOADED;
            Yodo1MasIronSourceMaxBannerAdapter.this.callback(1003, Yodo1MasIronSourceMaxBannerAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasIronSourceMaxBannerAdapter.this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.LOADED;
            Yodo1MasIronSourceMaxBannerAdapter.this.callbackAdapterState();
        }

        public void onBannerAdLoadFailed(IronSourceError adError) {
            String message = "method: onBannerAdLoadFailed, error: " + adError.toString();
            Yodo1MasLog.d((String)Yodo1MasIronSourceMaxBannerAdapter.this.TAG, (String)message);
            Yodo1MasIronSourceMaxBannerAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasIronSourceMaxBannerAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasIronSourceMaxBannerAdapter.this.callback(error);
            Yodo1MasIronSourceMaxBannerAdapter.this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.FAILED;
            Yodo1MasIronSourceMaxBannerAdapter.this.callbackAdapterState();
            Yodo1MasIronSourceMaxBannerAdapter.this.nextBanner();
            Yodo1MasIronSourceMaxBannerAdapter.this.loadBannerAdvertDelayed();
        }

        public void onBannerAdClicked() {
            String message = "method: onBannerAdClicked";
            Yodo1MasLog.d((String)Yodo1MasIronSourceMaxBannerAdapter.this.TAG, (String)message);
        }

        public void onBannerAdScreenPresented() {
            String message = "method: onBannerAdScreenPresented";
            Yodo1MasLog.d((String)Yodo1MasIronSourceMaxBannerAdapter.this.TAG, (String)message);
            Yodo1MasIronSourceMaxBannerAdapter.this.callback(1001, Yodo1MasIronSourceMaxBannerAdapter.this.TAG + ":{" + message + "}");
        }

        public void onBannerAdScreenDismissed() {
            String message = "method: onBannerAdScreenDismissed";
            Yodo1MasLog.d((String)Yodo1MasIronSourceMaxBannerAdapter.this.TAG, (String)message);
            Yodo1MasIronSourceMaxBannerAdapter.this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            Yodo1MasIronSourceMaxBannerAdapter.this.callback(1002, Yodo1MasIronSourceMaxBannerAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasIronSourceMaxBannerAdapter.this.loadBannerAdvert();
        }

        public void onBannerAdLeftApplication() {
            String message = "method: onBannerAdLeftApplication";
            Yodo1MasLog.d((String)Yodo1MasIronSourceMaxBannerAdapter.this.TAG, (String)message);
        }
    };
    private IronSourceBannerLayout bannerAd;

    public Yodo1MasIronSourceMaxBannerAdapter(List<Yodo1MasAdapterBase.AdId> adIds) {
        super(adIds);
    }

    public boolean isMax() {
        return true;
    }

    public boolean isBannerAdvertLoaded() {
        super.isBannerAdvertLoaded();
        return this.bannerAd != null && this.bannerState == Yodo1MasAdapterBase.AdvertState.LOADED;
    }

    public void loadBannerAdvert(@NonNull Activity activity) {
        super.loadBannerAdvert(activity);
        if (this.relateAdapter != null && !this.relateAdapter.isInitSDK()) {
            return;
        }
        if (this.bannerAd == null) {
            this.bannerAd = new IronSourceBannerLayout(activity, this.getBannerSize());
            this.bannerAd.setBannerListener(this.bannerListener);
        }
        if (this.bannerState != Yodo1MasAdapterBase.AdvertState.LOADING) {
            String message = "method: loadBannerAdvert, loading banner ad...";
            Yodo1MasLog.d((String)this.TAG, (String)message);
            if (!TextUtils.isEmpty((CharSequence)this.bannerConfig.placement)) {
                this.bannerAd.setPlacementName(this.bannerConfig.placement);
            }
            IronSource.loadBanner((IronSourceBannerLayout)this.bannerAd);
            this.bannerState = Yodo1MasAdapterBase.AdvertState.LOADING;
            this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.LOADING;
        }
    }

    private ISBannerSize getBannerSize() {
        Yodo1MasBannerAdSize size = this.bannerConfig.size;
        Yodo1MasLog.d((String)this.TAG, (String)("setBannerSize: size: " + size.name()));
        ISBannerSize bannerSize = ISBannerSize.BANNER;
        if (Yodo1MasBannerAdSize.LargeBanner == size) {
            bannerSize = ISBannerSize.RECTANGLE;
        } else if (Yodo1MasBannerAdSize.IABMediumRectangle == size) {
            bannerSize = ISBannerSize.RECTANGLE;
        } else if (Yodo1MasBannerAdSize.SmartBanner == size) {
            bannerSize = ISBannerSize.SMART;
        } else if (Yodo1MasBannerAdSize.AdaptiveBanner == size) {
            bannerSize = ISBannerSize.BANNER;
            bannerSize.setAdaptive(true);
        }
        return bannerSize;
    }

    public View getBannerView() {
        return this.bannerAd;
    }

    public void dismissBannerAdvert(boolean destroy) {
        super.dismissBannerAdvert(destroy);
        if (this.bannerAd != null && destroy) {
            IronSource.destroyBanner((IronSourceBannerLayout)this.bannerAd);
            this.bannerAd = null;
            this.bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
            this.advertAdapterState = Yodo1MasBannerAdapterBase.AdvertAdapterState.NONE;
        }
    }

    public boolean isSupportMultipleInstance() {
        return false;
    }
}

