/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.ironsource;

import android.app.Activity;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.model.Placement;
import com.ironsource.mediationsdk.sdk.RewardedVideoManualListener;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;

public class Yodo1MasIronSourceMaxRewardAdapter
extends Yodo1MasRewardAdapterBase
implements RewardedVideoManualListener {
    private boolean isRewarded = false;

    public Yodo1MasIronSourceMaxRewardAdapter(Yodo1MasAdapterBase.AdId unitId) {
        super(unitId);
    }

    public boolean isRewardAdLoaded() {
        return IronSource.isRewardedVideoAvailable();
    }

    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);
        if (this.rewardStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) {
            return;
        }
        String message = "method: loadRewardAdvert, loading reward ad...";
        Yodo1MasLog.d((String)this.TAG, (String)message);
        this.rewardStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        this.adLoadStartTimeStamp = System.currentTimeMillis();
        IronSource.loadRewardedVideo();
    }

    public void showRewardAdvertFromActivity(@NonNull Activity activity) {
        super.showRewardAdvertFromActivity(activity);
        if (this.isRewardAdLoaded()) {
            String message = "method: showRewardAdvert, loading reward ad...";
            Yodo1MasLog.d((String)this.TAG, (String)message);
            if (!TextUtils.isEmpty((CharSequence)this.rewardPlacement)) {
                IronSource.showRewardedVideo((String)this.rewardPlacement);
            } else {
                IronSource.showRewardedVideo();
            }
        }
    }

    public void onRewardedVideoAdReady() {
        String message = "method: onRewardedVideoAdReady";
        Yodo1MasLog.d((String)this.TAG, (String)message);
        this.callbackLoad(null);
    }

    public void onRewardedVideoAdLoadFailed(IronSourceError adError) {
        String message = "method: onRewardedVideoAdLoadFailed, error: " + adError.toString();
        Yodo1MasLog.d((String)this.TAG, (String)message);
        Yodo1MasError error = new Yodo1MasError(-600202, this.TAG + ":{" + message + "}");
        this.callbackError(error, adError.getErrorCode(), adError.getErrorMessage(), null);
    }

    public void onRewardedVideoAdOpened() {
        String message = "method: onRewardedVideoAdOpened";
        Yodo1MasLog.d((String)this.TAG, (String)message);
        this.callbackOpen();
    }

    public void onRewardedVideoAdClosed() {
        String message = "method: onRewardedVideoAdClosed";
        Yodo1MasLog.d((String)this.TAG, (String)message);
        if (this.isRewarded) {
            this.callbackEarned();
            this.isRewarded = false;
        }
        this.callbackClose();
    }

    public void onRewardedVideoAvailabilityChanged(boolean b) {
        String message = "method: onRewardedVideoAvailabilityChanged, changed: " + b;
        Yodo1MasLog.d((String)this.TAG, (String)message);
    }

    public void onRewardedVideoAdStarted() {
        String message = "method: onRewardedVideoAdStarted";
        Yodo1MasLog.d((String)this.TAG, (String)message);
    }

    public void onRewardedVideoAdEnded() {
        String message = "method: onRewardedVideoAdEnded";
        Yodo1MasLog.d((String)this.TAG, (String)message);
    }

    public void onRewardedVideoAdRewarded(Placement placement) {
        String message = "method: onRewardedVideoAdRewarded, placement: " + placement.getPlacementName();
        Yodo1MasLog.d((String)this.TAG, (String)message);
        this.isRewarded = true;
    }

    public void onRewardedVideoAdShowFailed(IronSourceError adError) {
        String message = "method: onRewardedVideoAdShowFailed, error: " + adError.toString();
        Yodo1MasLog.d((String)this.TAG, (String)message);
        Yodo1MasError error = new Yodo1MasError(-600201, this.TAG + ":{" + message + "}");
        this.callbackError(error, adError.getErrorCode(), adError.getErrorMessage(), null);
    }

    public void onRewardedVideoAdClicked(Placement placement) {
        String message = "method: onRewardedVideoAdClicked, placement: " + placement.getPlacementName();
        Yodo1MasLog.d((String)this.TAG, (String)message);
        this.callbackClick();
    }
}

