/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.ironsource;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.adunit.adapter.utility.AdInfo;
import com.ironsource.mediationsdk.impressionData.ImpressionData;
import com.ironsource.mediationsdk.impressionData.ImpressionDataListener;
import com.ironsource.mediationsdk.integration.IntegrationHelper;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.model.Placement;
import com.ironsource.mediationsdk.sdk.LevelPlayRewardedVideoManualListener;
import com.yodo1.mas.analytics.Yodo1MasDataAnalytics;
import com.yodo1.mas.appopenad.Yodo1MasAppOpenAdapterBase;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.helper.Yodo1MasHelper;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.mediation.ironsource.Yodo1MasIronSourceMaxBannerAdapter;
import com.yodo1.mas.mediation.ironsource.Yodo1MasIronSourceMaxInterstitialAdapter;
import com.yodo1.mas.mediation.ironsource.Yodo1MasIronSourceMaxRewardAdapter;
import com.yodo1.mas.nativeads.Yodo1MasNativeAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import com.yodo1.mas.rewardedinterstitial.Yodo1MasRewardedInterstitialAdapterBase;

public class Yodo1MasIronSourceMaxAdapter
extends Yodo1MasAdapterBase {
    private Yodo1MasIronSourceMaxRewardAdapter rewardAdapter;
    private final LevelPlayRewardedVideoManualListener rewardedVideoManualListener = new LevelPlayRewardedVideoManualListener(){

        public void onAdOpened(AdInfo adInfo) {
            if (Yodo1MasIronSourceMaxAdapter.this.rewardAdapter != null) {
                Yodo1MasIronSourceMaxAdapter.this.rewardAdapter.onAdOpened(adInfo);
            }
        }

        public void onAdShowFailed(IronSourceError ironSourceError, AdInfo adInfo) {
            if (Yodo1MasIronSourceMaxAdapter.this.rewardAdapter != null) {
                Yodo1MasIronSourceMaxAdapter.this.rewardAdapter.onAdShowFailed(ironSourceError, adInfo);
            }
        }

        public void onAdClicked(Placement placement, AdInfo adInfo) {
            if (Yodo1MasIronSourceMaxAdapter.this.rewardAdapter != null) {
                Yodo1MasIronSourceMaxAdapter.this.rewardAdapter.onAdClicked(placement, adInfo);
            }
        }

        public void onAdRewarded(Placement placement, AdInfo adInfo) {
            if (Yodo1MasIronSourceMaxAdapter.this.rewardAdapter != null) {
                Yodo1MasIronSourceMaxAdapter.this.rewardAdapter.onAdRewarded(placement, adInfo);
            }
        }

        public void onAdClosed(AdInfo adInfo) {
            if (Yodo1MasIronSourceMaxAdapter.this.rewardAdapter != null) {
                Yodo1MasIronSourceMaxAdapter.this.rewardAdapter.onAdClosed(adInfo);
            }
        }

        public void onAdReady(AdInfo adInfo) {
            if (Yodo1MasIronSourceMaxAdapter.this.rewardAdapter != null) {
                Yodo1MasIronSourceMaxAdapter.this.rewardAdapter.onAdReady(adInfo);
            }
        }

        public void onAdLoadFailed(IronSourceError ironSourceError) {
            if (Yodo1MasIronSourceMaxAdapter.this.rewardAdapter != null) {
                Yodo1MasIronSourceMaxAdapter.this.rewardAdapter.onAdLoadFailed(ironSourceError);
            }
        }
    };

    public String getAdvertCode() {
        return "IRONSOURCE";
    }

    public String getSDKVersion() {
        return "8.1.0";
    }

    public String getMediationVersion() {
        return "4.13.1";
    }

    public void initSDK(@NonNull Activity activity, @NonNull Yodo1MasAdapterBase.Config config, @Nullable Yodo1MasAdapterBase.InitCallback callback) {
        super.initSDK(activity, config, callback);
        if (!this.isInitSDK()) {
            if (Yodo1MasHelper.getInstance().isDebug()) {
                IronSource.setLogListener((tag, msg, i) -> {});
                IronSource.setAdaptersDebug((boolean)true);
            }
            if (TextUtils.isEmpty((CharSequence)config.appId)) {
                if (callback != null) {
                    callback.onAdapterInitFailed(this.getAdvertCode(), new Yodo1MasError(-600001, "config.appId is null"));
                }
                return;
            }
            this.init = true;
            IronSource.setLevelPlayRewardedVideoManualListener((LevelPlayRewardedVideoManualListener)this.rewardedVideoManualListener);
            IronSource.addImpressionDataListener((ImpressionDataListener)new ImpressionDataListener(){

                public void onImpressionSuccess(ImpressionData impressionData) {
                    Yodo1MasDataAnalytics.trackAdRevenue((String)"ironSource", (String)impressionData.getAdNetwork(), (String)impressionData.getAdUnit(), (String)impressionData.getInstanceName(), (double)impressionData.getRevenue(), (String)"USD");
                }
            });
            this.updatePrivacy();
            IronSource.init((Context)activity, (String)config.appId, (IronSource.AD_UNIT[])new IronSource.AD_UNIT[]{IronSource.AD_UNIT.REWARDED_VIDEO, IronSource.AD_UNIT.INTERSTITIAL, IronSource.AD_UNIT.BANNER});
            IntegrationHelper.validateIntegration((Context)activity);
            if (callback != null) {
                callback.onAdapterInitSuccessful(this.getAdvertCode());
            }
        } else if (callback != null) {
            callback.onAdapterInitSuccessful(this.getAdvertCode());
        }
    }

    public void updatePrivacy() {
        super.updatePrivacy();
        IronSource.setConsent((boolean)Yodo1MasHelper.getInstance().isGDPRUserConsent());
        IronSource.setMetaData((String)"do_not_sell", (String)Boolean.toString(Yodo1MasHelper.getInstance().isCCPADoNotSell()));
        boolean isAgeRestricted = Yodo1MasHelper.getInstance().isCOPPAAgeRestricted();
        IronSource.setMetaData((String)"is_child_directed", (String)Boolean.toString(isAgeRestricted));
        IronSource.setMetaData((String)"is_deviceid_optout", (String)Boolean.toString(isAgeRestricted));
        boolean isChild = Yodo1MasHelper.getInstance().isCOPPAAgeRestricted();
        String isChildBoolean = isChild ? "true" : "false";
        IronSource.setMetaData((String)"AdMob_TFCD", (String)isChildBoolean);
        IronSource.setMetaData((String)"AdMob_TFUA", (String)isChildBoolean);
        IronSource.setMetaData((String)"AppLovin_AgeRestrictedUser", (String)isChildBoolean);
        if (isChild) {
            IronSource.setMetaData((String)"META_Mixed_Audience", (String)isChildBoolean);
        }
        if (isChild) {
            IronSource.setMetaData((String)"DT_IsChild", (String)isChildBoolean);
        }
        IronSource.setMetaData((String)"InMobi_AgeRestricted", (String)isChildBoolean);
        IronSource.setMetaData((String)"Mintegral_COPPA", (String)isChildBoolean);
        String isChildInt = isChild ? "1" : "0";
        IronSource.setMetaData((String)"Pangle_COPPA", (String)isChildInt);
        IronSource.setMetaData((String)"UnityAds_coppa", (String)isChildBoolean);
        IronSource.setMetaData((String)"Vungle_coppa", (String)isChildBoolean);
    }

    public void onActivityResume(@NonNull Activity activity) {
        super.onActivityResume(activity);
        if (!this.isInitSDK()) {
            return;
        }
        IronSource.onResume((Activity)activity);
    }

    public void onActivityPause(@NonNull Activity activity) {
        super.onActivityPause(activity);
        if (!this.isInitSDK()) {
            return;
        }
        IronSource.onPause((Activity)activity);
    }

    protected Class<? extends Yodo1MasRewardAdapterBase> rewardAdapterClass() {
        return Yodo1MasIronSourceMaxRewardAdapter.class;
    }

    public Yodo1MasRewardAdapterBase getRewardAdapter(Yodo1MasAdapterBase.AdId rewardAdId) {
        Yodo1MasIronSourceMaxRewardAdapter adapter;
        this.rewardAdapter = adapter = (Yodo1MasIronSourceMaxRewardAdapter)super.getRewardAdapter(rewardAdId);
        return adapter;
    }

    protected Class<? extends Yodo1MasInterstitialAdapterBase> interstitialAdapterClass() {
        return Yodo1MasIronSourceMaxInterstitialAdapter.class;
    }

    public Class<? extends Yodo1MasNativeAdapterBase> nativeAdapterClass() {
        return null;
    }

    public Class<? extends Yodo1MasBannerAdapterBase> bannerAdapterClass() {
        return Yodo1MasIronSourceMaxBannerAdapter.class;
    }

    protected Class<? extends Yodo1MasRewardedInterstitialAdapterBase> rewardedInterstitialAdapterClass() {
        return null;
    }

    protected Class<? extends Yodo1MasAppOpenAdapterBase> appOpenAdapterClass() {
        return null;
    }
}

