/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.ironsource;

import android.app.Activity;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.demandOnly.ISDemandOnlyRewardedVideoListener;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.analytics.model.Yodo1MasAdRequestResultInfo;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import com.yodo1.mas.utils.Yodo1MasAdRequestTrackUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Yodo1MasIronSourceRewardAdapter
extends Yodo1MasRewardAdapterBase {
    private static final Map<String, Yodo1MasIronSourceRewardAdapter> map = new HashMap<String, Yodo1MasIronSourceRewardAdapter>();
    private final ISDemandOnlyRewardedVideoListener rewardListener = new ISDemandOnlyRewardedVideoListener(){

        public void onRewardedVideoAdLoadSuccess(String placementId) {
            String message = "method: onRewardedVideoAdLoadSuccess, placementId: " + placementId;
            Yodo1MasLog.d((String)Yodo1MasIronSourceRewardAdapter.this.TAG, (String)message);
            Yodo1MasIronSourceRewardAdapter instance = Yodo1MasIronSourceRewardAdapter.this.getInstanceByPlacementId(placementId);
            if (instance != null) {
                Yodo1MasAdRequestResultInfo adRequestResult = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult((Yodo1Mas.AdType)Yodo1Mas.AdType.Reward, (String)Yodo1MasIronSourceRewardAdapter.this.advertCode, (String)placementId, (boolean)true, (long)instance.getAdLoadDuration(), null, null);
                instance.callbackLoad(adRequestResult);
            }
        }

        public void onRewardedVideoAdLoadFailed(String placementId, IronSourceError adError) {
            String message = "method: onRewardedVideoAdLoadFailed, placementId: " + placementId + ", error: " + adError.toString();
            Yodo1MasLog.d((String)Yodo1MasIronSourceRewardAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600202, Yodo1MasIronSourceRewardAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasIronSourceRewardAdapter instance = Yodo1MasIronSourceRewardAdapter.this.getInstanceByPlacementId(placementId);
            if (instance != null) {
                Yodo1MasAdRequestResultInfo adRequestResult = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult((Yodo1Mas.AdType)Yodo1Mas.AdType.Reward, (String)Yodo1MasIronSourceRewardAdapter.this.advertCode, (String)placementId, (boolean)false, (long)instance.getAdLoadDuration(), (String)(adError.getErrorCode() + ""), (String)adError.getErrorMessage());
                instance.callbackError(error, adError.getErrorCode(), adError.getErrorMessage(), adRequestResult);
            }
        }

        public void onRewardedVideoAdOpened(String placementId) {
            String message = "method: onRewardedVideoAdOpened, placementId: " + placementId;
            Yodo1MasLog.d((String)Yodo1MasIronSourceRewardAdapter.this.TAG, (String)message);
            Yodo1MasIronSourceRewardAdapter.this.callbackOpen();
        }

        public void onRewardedVideoAdClosed(String placementId) {
            String message = "method: onRewardedVideoAdClosed, placementId: " + placementId;
            Yodo1MasLog.d((String)Yodo1MasIronSourceRewardAdapter.this.TAG, (String)message);
            Yodo1MasIronSourceRewardAdapter.this.callbackClose();
        }

        public void onRewardedVideoAdShowFailed(String placementId, IronSourceError adError) {
            String message = "method: onRewardedVideoAdShowFailed, placementId: " + placementId + ", error: " + adError.toString();
            Yodo1MasLog.d((String)Yodo1MasIronSourceRewardAdapter.this.TAG, (String)message);
            Yodo1MasError error = new Yodo1MasError(-600201, Yodo1MasIronSourceRewardAdapter.this.TAG + ":{" + message + "}");
            Yodo1MasIronSourceRewardAdapter.this.callbackError(error, adError.getErrorCode(), adError.getErrorMessage(), null);
        }

        public void onRewardedVideoAdClicked(String placementId) {
            String message = "method: onRewardedVideoAdClicked, placementId: " + placementId;
            Yodo1MasLog.d((String)Yodo1MasIronSourceRewardAdapter.this.TAG, (String)message);
            Yodo1MasIronSourceRewardAdapter.this.callbackClick();
        }

        public void onRewardedVideoAdRewarded(String placementId) {
            String message = "method: onRewardedVideoAdRewarded, placementId: " + placementId;
            Yodo1MasLog.d((String)Yodo1MasIronSourceRewardAdapter.this.TAG, (String)message);
            Yodo1MasIronSourceRewardAdapter.this.callbackEarned();
        }
    };

    public Yodo1MasIronSourceRewardAdapter(Yodo1MasAdapterBase.AdId unitId) {
        super(unitId);
        IronSource.setISDemandOnlyRewardedVideoListener((ISDemandOnlyRewardedVideoListener)this.rewardListener);
    }

    public boolean isRewardAdLoaded() {
        String adId = this.getAdUnitId();
        return !TextUtils.isEmpty((CharSequence)adId) && IronSource.isISDemandOnlyRewardedVideoAvailable((String)adId);
    }

    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);
        String adId = this.getAdUnitId();
        if (TextUtils.isEmpty((CharSequence)adId)) {
            return;
        }
        if (this.rewardStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) {
            return;
        }
        String message = "method: loadRewardAdvert, loading reward ad...";
        Yodo1MasLog.d((String)this.TAG, (String)message);
        this.rewardStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        this.adLoadStartTimeStamp = System.currentTimeMillis();
        map.put(adId, this);
        IronSource.loadISDemandOnlyRewardedVideo((Activity)activity, (String)adId);
    }

    public void showRewardAdvertFromActivity(@NonNull Activity activity) {
        super.showRewardAdvertFromActivity(activity);
        if (this.isRewardAdLoaded()) {
            String message = "method: showRewardAdvert, show reward ad...";
            Yodo1MasLog.d((String)this.TAG, (String)message);
            String adId = this.getAdUnitId();
            IronSource.showISDemandOnlyRewardedVideo((String)adId);
        }
    }

    private Yodo1MasIronSourceRewardAdapter getInstanceByPlacementId(String placementId) {
        if (map != null && map.containsKey(placementId)) {
            return map.get(placementId);
        }
        return null;
    }

    public void destroy() {
        super.destroy();
        Iterator<Map.Entry<String, Yodo1MasIronSourceRewardAdapter>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Yodo1MasIronSourceRewardAdapter> entry = iterator.next();
            if (!((Object)((Object)this)).equals((Object)entry.getValue())) continue;
            iterator.remove();
        }
    }
}

