package com.yodo1.mas.mediation.ironsource;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.integration.IntegrationHelper;
import com.yodo1.mas.appopenad.Yodo1MasAppOpenAdapterBase;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.helper.Yodo1MasHelper;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.nativeads.Yodo1MasNativeAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import com.yodo1.mas.rewardedinterstitial.Yodo1MasRewardedInterstitialAdapterBase;

public class Yodo1MasIronSourceAdapter extends Yodo1MasAdapterBase {

    private static void setIronSourcePrivacy(@NonNull Context context) {
        IronSource.setConsent(Yodo1MasHelper.getInstance().isGDPRUserConsent());
        IronSource.setMetaData("do_not_sell", Boolean.toString(Yodo1MasHelper.getInstance().isCCPADoNotSell()));

        /**
         * Google Play Families compliance, you can find out details from the below link
         * https://developers.is.com/ironsource-mobile/android/regulation-advanced-settings/#step-4
         */
        // Apps directed at a mixed audience
        boolean isAgeRestricted = Yodo1MasHelper.getInstance().isCOPPAAgeRestricted();
        IronSource.setMetaData("is_child_directed", Boolean.toString(isAgeRestricted));
        IronSource.setMetaData("is_deviceid_optout", Boolean.toString(isAgeRestricted));
    }

    @Override
    public String getAdvertCode() {
        return "ironsource";
    }

    @Override
    public String networkName() {
        return "ironSource";
    }

    @Override
    public String getSDKVersion() {
        return BuildConfig.SDK_VERSION_NAME;
    }

    @Override
    public String getMediationVersion() {
        return BuildConfig.MAS_VERSION_NAME;
    }

    @Override
    public void initSDK(@NonNull Activity activity, @NonNull Config config, @Nullable InitCallback callback) {
        super.initSDK(activity, config, callback);
        if (!isInitSDK()) {

            init = true;
            if (Yodo1MasHelper.getInstance().isDebug()) {
                IronSource.setLogListener((tag, msg, i) -> {

                });
                IronSource.setAdaptersDebug(true);
            }

            if (!TextUtils.isEmpty(config.appId)) {
                updatePrivacy();
                IronSource.initISDemandOnly(activity, config.appId, IronSource.AD_UNIT.REWARDED_VIDEO, IronSource.AD_UNIT.INTERSTITIAL, IronSource.AD_UNIT.BANNER);
                if (Yodo1MasHelper.getInstance().isDebug()) {
                    IntegrationHelper.validateIntegration(activity);
                }

                if (callback != null) {
                    callback.onAdapterInitSuccessful(getAdvertCode());
                }
            } else {
                if (callback != null) {
                    callback.onAdapterInitFailed(getAdvertCode(), new Yodo1MasError(Yodo1MasError.CODE_ADVERT_UNINITIALIZED, "config.appId is null"));
                }
            }
        } else {
            if (callback != null) {
                callback.onAdapterInitSuccessful(getAdvertCode());
            }
        }
    }

    @Override
    public void updatePrivacy() {
        super.updatePrivacy();
        setIronSourcePrivacy(applicationContext.getApplicationContext());
    }

    @Override
    public void onActivityResume(@NonNull Activity activity) {
        super.onActivityResume(activity);
        if (!isInitSDK()) {
            return;
        }
        IronSource.onResume(activity);
    }

    @Override
    public void onActivityPause(@NonNull Activity activity) {
        super.onActivityPause(activity);
        if (!isInitSDK()) {
            return;
        }
        IronSource.onPause(activity);
    }

    // Reward
    @Override
    public Class<? extends Yodo1MasRewardAdapterBase> rewardAdapterClass() {
        return Yodo1MasIronSourceRewardAdapter.class;
    }

    // Interstitial
    @Override
    public Class<? extends Yodo1MasInterstitialAdapterBase> interstitialAdapterClass() {
        return Yodo1MasIronSourceInterstitialAdapter.class;
    }

    // Native
    @Override
    public Class<? extends Yodo1MasNativeAdapterBase> nativeAdapterClass() {
        return null;
    }

    // Banner
    @Override
    public Class<? extends Yodo1MasBannerAdapterBase> bannerAdapterClass() {
        return Yodo1MasIronSourceBannerAdapter.class;
    }

    // Rewarded Interstitial
    @Override
    public Class<? extends Yodo1MasRewardedInterstitialAdapterBase> rewardedInterstitialAdapterClass() {
        return null;
    }

    // App Open
    @Override
    public Class<? extends Yodo1MasAppOpenAdapterBase> appOpenAdapterClass() {
        return null;
    }
}
