package com.yodo1.mas.mediation.ironsource;

import android.app.Activity;
import android.text.TextUtils;

import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.demandOnly.ISDemandOnlyInterstitialListener;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.yodo1.mas.Yodo1Mas;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.analytics.model.Yodo1MasAdRequestResultInfo;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.utils.Yodo1MasAdRequestTrackUtil;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Yodo1MasIronSourceInterstitialAdapter extends Yodo1MasInterstitialAdapterBase {

    private static final Map<String, Yodo1MasIronSourceInterstitialAdapter> map = new HashMap<>();

    private final ISDemandOnlyInterstitialListener interstitialListener = new ISDemandOnlyInterstitialListener() {
        @Override
        public void onInterstitialAdReady(String placementId) {
            String message = "method: onInterstitialAdReady, placementId: " + placementId;
            Yodo1MasLog.d(TAG, message);
            Yodo1MasIronSourceInterstitialAdapter instance = getInstanceByPlacementId(placementId);
            if(instance != null) {
                Yodo1MasAdRequestResultInfo adRequestResult
                        = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult(Yodo1Mas.AdType.Interstitial
                        , advertCode, placementId, true,instance.getAdLoadDuration(), null, null);
                instance.callbackLoad(adRequestResult);
            }
        }

        @Override
        public void onInterstitialAdLoadFailed(String placementId, IronSourceError adError) {
            String message = "method: onInterstitialAdLoadFailed, placementId: " + placementId + ", error: " + adError.toString();
            Yodo1MasLog.d(TAG, message);
            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");

            Yodo1MasIronSourceInterstitialAdapter instance = getInstanceByPlacementId(placementId);
            if(instance != null) {
                Yodo1MasAdRequestResultInfo adRequestResult
                        = Yodo1MasAdRequestTrackUtil.getYodo1MediationAdRequestResult(Yodo1Mas.AdType.Interstitial
                        , advertCode, placementId, false, instance.getAdLoadDuration(), adError.getErrorCode()+"", adError.getErrorMessage());
                instance.callbackError(error, adError.getErrorCode(), adError.getErrorMessage(), adRequestResult);
            }
        }

        @Override
        public void onInterstitialAdOpened(String placementId) {
            String message = "method: onInterstitialAdOpened, placementId: " + placementId;
            Yodo1MasLog.d(TAG, message);
            callbackOpen();
        }

        @Override
        public void onInterstitialAdClosed(String placementId) {
            String message = "method: onInterstitialAdClosed, placementId: " + placementId;
            Yodo1MasLog.d(TAG, message);
            callbackClose();
        }

        @Override
        public void onInterstitialAdShowFailed(String placementId, IronSourceError adError) {
            String message = "method: onInterstitialAdShowFailed, placementId: " + placementId + ", error: " + adError.toString();
            Yodo1MasLog.d(TAG, message);

            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_SHOW_FAIL, TAG + ":{" + message + "}");
            callbackError(error, adError.getErrorCode(), adError.getErrorMessage(), null);
        }

        @Override
        public void onInterstitialAdClicked(String placementId) {
            String message = "method: onInterstitialAdClicked, placementId: " + placementId;
            Yodo1MasLog.d(TAG, message);
            callbackClick();
        }
    };

    public Yodo1MasIronSourceInterstitialAdapter(Yodo1MasAdapterBase.AdId unitId) {
        super(unitId);
        IronSource.setISDemandOnlyInterstitialListener(interstitialListener);
    }

    @Override
    public boolean isInterstitialAdLoaded() {
        String adId = getAdUnitId();
        return !TextUtils.isEmpty(adId) && IronSource.isISDemandOnlyInterstitialReady(adId);
    }

    @Override
    public void loadInterstitialAdvert(Activity activity) {
        super.loadInterstitialAdvert(activity);
        String adId = getAdUnitId();
        if (TextUtils.isEmpty(adId)) return;

        if (interstitialStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) return;

        String message = "method: loadInterstitialAdvert, load interstitial ad...";
        Yodo1MasLog.d(TAG, message);
        interstitialStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        adLoadStartTimeStamp = System.currentTimeMillis();
        map.put(adId, this);
        IronSource.loadISDemandOnlyInterstitial(activity, adId);
    }

    @Override
    public void showInterstitialAdvertFromActivity(Activity activity) {
        super.showInterstitialAdvertFromActivity(activity);
        if (isInterstitialAdLoaded()) {
            String message = "method: showInterstitialAdvert, show interstitial ad...";
            Yodo1MasLog.d(TAG, message);
            String adId = getAdUnitId();
            IronSource.showISDemandOnlyInterstitial(adId);
        }
    }

    private Yodo1MasIronSourceInterstitialAdapter getInstanceByPlacementId(String placementId) {
        if(map != null && map.containsKey(placementId)) {
            return map.get(placementId);
        }
        return null;
    }

    @Override
    public void destroy() {
        super.destroy();
        Iterator<Map.Entry<String, Yodo1MasIronSourceInterstitialAdapter>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Yodo1MasIronSourceInterstitialAdapter> entry = iterator.next();
            if(this.equals(entry.getValue())) {
                iterator.remove();
            }
        }
    }
}
