/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.ironsource;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.integration.IntegrationHelper;
import com.yodo1.mas.appopenad.Yodo1MasAppOpenAdapterBase;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.helper.Yodo1MasHelper;
import com.yodo1.mas.interstitial.Yodo1MasInterstitialAdapterBase;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.mediation.ironsource.Yodo1MasIronSourceBannerAdapter;
import com.yodo1.mas.mediation.ironsource.Yodo1MasIronSourceInterstitialAdapter;
import com.yodo1.mas.mediation.ironsource.Yodo1MasIronSourceRewardAdapter;
import com.yodo1.mas.nativeads.Yodo1MasNativeAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;
import com.yodo1.mas.rewardedinterstitial.Yodo1MasRewardedInterstitialAdapterBase;

public class Yodo1MasIronSourceAdapter
extends Yodo1MasAdapterBase {
    private static void setIronSourcePrivacy(@NonNull Context context) {
        IronSource.setConsent((boolean)Yodo1MasHelper.getInstance().isGDPRUserConsent());
        IronSource.setMetaData((String)"do_not_sell", (String)Boolean.toString(Yodo1MasHelper.getInstance().isCCPADoNotSell()));
        boolean isAgeRestricted = Yodo1MasHelper.getInstance().isCOPPAAgeRestricted();
        IronSource.setMetaData((String)"is_child_directed", (String)Boolean.toString(isAgeRestricted));
        IronSource.setMetaData((String)"is_deviceid_optout", (String)Boolean.toString(isAgeRestricted));
    }

    public String getAdvertCode() {
        return "ironsource";
    }

    public String networkName() {
        return "ironSource";
    }

    public String getSDKVersion() {
        return "8.3.0";
    }

    public String getMediationVersion() {
        return "4.14.2";
    }

    public void initSDK(@NonNull Activity activity, @NonNull Yodo1MasAdapterBase.Config config, @Nullable Yodo1MasAdapterBase.InitCallback callback) {
        super.initSDK(activity, config, callback);
        if (!this.isInitSDK()) {
            this.init = true;
            if (Yodo1MasHelper.getInstance().isDebug()) {
                IronSource.setLogListener((tag, msg, i) -> {});
                IronSource.setAdaptersDebug((boolean)true);
            }
            if (!TextUtils.isEmpty((CharSequence)config.appId)) {
                this.updatePrivacy();
                IronSource.initISDemandOnly((Context)activity, (String)config.appId, (IronSource.AD_UNIT[])new IronSource.AD_UNIT[]{IronSource.AD_UNIT.REWARDED_VIDEO, IronSource.AD_UNIT.INTERSTITIAL, IronSource.AD_UNIT.BANNER});
                if (Yodo1MasHelper.getInstance().isDebug()) {
                    IntegrationHelper.validateIntegration((Context)activity);
                }
                if (callback != null) {
                    callback.onAdapterInitSuccessful(this.getAdvertCode());
                }
            } else if (callback != null) {
                callback.onAdapterInitFailed(this.getAdvertCode(), new Yodo1MasError(-600001, "config.appId is null"));
            }
        } else if (callback != null) {
            callback.onAdapterInitSuccessful(this.getAdvertCode());
        }
    }

    public void updatePrivacy() {
        super.updatePrivacy();
        Yodo1MasIronSourceAdapter.setIronSourcePrivacy(this.applicationContext.getApplicationContext());
    }

    public void onActivityResume(@NonNull Activity activity) {
        super.onActivityResume(activity);
        if (!this.isInitSDK()) {
            return;
        }
        IronSource.onResume((Activity)activity);
    }

    public void onActivityPause(@NonNull Activity activity) {
        super.onActivityPause(activity);
        if (!this.isInitSDK()) {
            return;
        }
        IronSource.onPause((Activity)activity);
    }

    public Class<? extends Yodo1MasRewardAdapterBase> rewardAdapterClass() {
        return Yodo1MasIronSourceRewardAdapter.class;
    }

    public Class<? extends Yodo1MasInterstitialAdapterBase> interstitialAdapterClass() {
        return Yodo1MasIronSourceInterstitialAdapter.class;
    }

    public Class<? extends Yodo1MasNativeAdapterBase> nativeAdapterClass() {
        return null;
    }

    public Class<? extends Yodo1MasBannerAdapterBase> bannerAdapterClass() {
        return Yodo1MasIronSourceBannerAdapter.class;
    }

    public Class<? extends Yodo1MasRewardedInterstitialAdapterBase> rewardedInterstitialAdapterClass() {
        return null;
    }

    public Class<? extends Yodo1MasAppOpenAdapterBase> appOpenAdapterClass() {
        return null;
    }
}

