/*
 * Decompiled with CFR 0.152.
 */
package com.yodo1.mas.mediation.ironsource;

import android.app.Activity;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.adunit.adapter.utility.AdInfo;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.model.Placement;
import com.ironsource.mediationsdk.sdk.LevelPlayRewardedVideoManualListener;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;
import com.yodo1.mas.reward.Yodo1MasRewardAdapterBase;

public class Yodo1MasIronSourceMaxRewardAdapter
extends Yodo1MasRewardAdapterBase
implements LevelPlayRewardedVideoManualListener {
    private boolean isRewarded = false;

    public Yodo1MasIronSourceMaxRewardAdapter(Yodo1MasAdapterBase.AdId unitId) {
        super(unitId);
    }

    public boolean isRewardAdLoaded() {
        return IronSource.isRewardedVideoAvailable();
    }

    public void loadRewardAdvert(@NonNull Activity activity) {
        super.loadRewardAdvert(activity);
        if (this.rewardStatus == Yodo1MasAdapterBase.AdvertStatus.LOADING) {
            return;
        }
        String message = "method: loadRewardAdvert, loading reward ad...";
        Yodo1MasLog.d((String)this.TAG, (String)message);
        this.rewardStatus = Yodo1MasAdapterBase.AdvertStatus.LOADING;
        this.adLoadStartTimeStamp = System.currentTimeMillis();
        IronSource.loadRewardedVideo();
    }

    public void showRewardAdvertFromActivity(@NonNull Activity activity) {
        super.showRewardAdvertFromActivity(activity);
        if (this.isRewardAdLoaded()) {
            String message = "method: showRewardAdvert, loading reward ad...";
            Yodo1MasLog.d((String)this.TAG, (String)message);
            if (!TextUtils.isEmpty((CharSequence)this.placement)) {
                IronSource.showRewardedVideo((String)this.placement);
            } else {
                IronSource.showRewardedVideo();
            }
        }
    }

    public void onAdReady(AdInfo adInfo) {
        String message = "method: onAdReady";
        Yodo1MasLog.d((String)this.TAG, (String)message);
        this.callbackLoad(null);
    }

    public void onAdLoadFailed(IronSourceError ironSourceError) {
        String message = "method: onAdLoadFailed, errorCode: " + ironSourceError.getErrorCode() + " errorMessage: " + ironSourceError.getErrorMessage();
        Yodo1MasLog.d((String)this.TAG, (String)message);
        Yodo1MasError error = new Yodo1MasError(-600202, this.TAG + ":{" + message + "}");
        this.callbackError(error, ironSourceError.getErrorCode(), ironSourceError.getErrorMessage(), null);
    }

    public void onAdOpened(AdInfo adInfo) {
        String message = "method: onAdOpened";
        Yodo1MasLog.d((String)this.TAG, (String)message);
        this.callbackOpen();
    }

    public void onAdShowFailed(IronSourceError ironSourceError, AdInfo adInfo) {
        String message = "method: onAdShowFailed, errorCode: " + ironSourceError.getErrorCode() + " errorMessage: " + ironSourceError.getErrorMessage();
        Yodo1MasLog.d((String)this.TAG, (String)message);
        Yodo1MasError error = new Yodo1MasError(-600201, this.TAG + ":{" + message + "}");
        this.callbackError(error, ironSourceError.getErrorCode(), ironSourceError.getErrorMessage(), null);
    }

    public void onAdClicked(Placement placement, AdInfo adInfo) {
        String message = "method: onAdClicked, placement: " + placement.getPlacementName();
        Yodo1MasLog.d((String)this.TAG, (String)message);
        this.callbackClick();
    }

    public void onAdRewarded(Placement placement, AdInfo adInfo) {
        String message = "method: onAdRewarded, placement: " + placement.getPlacementName();
        Yodo1MasLog.d((String)this.TAG, (String)message);
        this.isRewarded = true;
    }

    public void onAdClosed(AdInfo adInfo) {
        String message = "method: onAdClosed";
        Yodo1MasLog.d((String)this.TAG, (String)message);
        if (this.isRewarded) {
            this.callbackEarned();
            this.isRewarded = false;
        }
        this.callbackClose();
    }
}

