package com.yodo1.mas.mediation.ironsource;

import android.app.Activity;
import android.text.TextUtils;
import android.view.View;

import androidx.annotation.NonNull;

import com.ironsource.mediationsdk.ISBannerSize;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.IronSourceBannerLayout;
import com.ironsource.mediationsdk.adunit.adapter.utility.AdInfo;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.sdk.LevelPlayBannerListener;
import com.yodo1.mas.Yodo1MasLog;
import com.yodo1.mas.banner.Yodo1MasBannerAdSize;
import com.yodo1.mas.banner.Yodo1MasBannerAdapterBase;
import com.yodo1.mas.error.Yodo1MasError;
import com.yodo1.mas.event.Yodo1MasAdEvent;
import com.yodo1.mas.mediation.Yodo1MasAdapterBase;

import java.util.List;

public class Yodo1MasIronSourceMaxBannerAdapter extends Yodo1MasBannerAdapterBase {

    private final LevelPlayBannerListener bannerListener = new LevelPlayBannerListener() {
        @Override
        public void onAdLoaded(AdInfo adInfo) {
            String message = "method: onAdLoaded";
            Yodo1MasLog.d(TAG, message);
            bannerState = Yodo1MasAdapterBase.AdvertState.LOADED;
            callback(Yodo1MasAdEvent.CODE_LOADED, TAG + ":{" + message + "}");
            advertAdapterState = AdvertAdapterState.LOADED;
            callbackAdapterState();
        }

        @Override
        public void onAdLoadFailed(IronSourceError ironSourceError) {
            String message = "method: onAdLoadFailed, errorCode: " + ironSourceError.getErrorCode() + " errorMessage: " + ironSourceError.getErrorMessage();
            Yodo1MasLog.d(TAG, message);
            bannerState = Yodo1MasAdapterBase.AdvertState.NONE;

            Yodo1MasError error = new Yodo1MasError(Yodo1MasError.CODE_ADVERT_LOAD_FAIL, TAG + ":{" + message + "}");
            callback(error);

            advertAdapterState = AdvertAdapterState.FAILED;
            callbackAdapterState();
            nextBanner();
            loadBannerAdvertDelayed();
        }

        @Override
        public void onAdClicked(AdInfo adInfo) {
            String message = "method: onAdClicked";
            Yodo1MasLog.d(TAG, message);
        }

        @Override
        public void onAdLeftApplication(AdInfo adInfo) {
            String message = "method: onAdLeftApplication";
            Yodo1MasLog.d(TAG, message);
        }

        @Override
        public void onAdScreenPresented(AdInfo adInfo) {
            String message = "method: onAdScreenPresented";
            Yodo1MasLog.d(TAG, message);
            callback(Yodo1MasAdEvent.CODE_OPENED, TAG + ":{" + message + "}");
        }

        @Override
        public void onAdScreenDismissed(AdInfo adInfo) {
            String message = "method: onAdScreenDismissed";
            Yodo1MasLog.d(TAG, message);
            bannerState = Yodo1MasAdapterBase.AdvertState.NONE;

            callback(Yodo1MasAdEvent.CODE_CLOSED, TAG + ":{" + message + "}");
            loadBannerAdvert();
        }
    };
    private IronSourceBannerLayout bannerAd;

    public Yodo1MasIronSourceMaxBannerAdapter(List<Yodo1MasAdapterBase.AdId> adIds) {
        super(adIds);
    }

    @Override
    public boolean isMax() {
        return true;
    }

    @Override
    public boolean isBannerAdvertLoaded() {
        super.isBannerAdvertLoaded();
        return bannerAd != null && bannerState == Yodo1MasAdapterBase.AdvertState.LOADED;
    }

    @Override
    public void loadBannerAdvert(@NonNull Activity activity) {
        super.loadBannerAdvert(activity);
        if (relateAdapter != null && !relateAdapter.isInitSDK()) {
            return;
        }

        if (bannerAd == null) {
            bannerAd = new IronSourceBannerLayout(activity, getBannerSize());
            bannerAd.setLevelPlayBannerListener(bannerListener);
        }

        if (bannerState != Yodo1MasAdapterBase.AdvertState.LOADING) {
            String message = "method: loadBannerAdvert, loading banner ad...";
            Yodo1MasLog.d(TAG, message);

            if (!TextUtils.isEmpty(placement)) {
                bannerAd.setPlacementName(placement);
            }
            IronSource.loadBanner(bannerAd);
            bannerState = Yodo1MasAdapterBase.AdvertState.LOADING;
            advertAdapterState = AdvertAdapterState.LOADING;
        }
    }

    private ISBannerSize getBannerSize() {
        Yodo1MasBannerAdSize size = bannerConfig.size;
        Yodo1MasLog.d(TAG, "setBannerSize: size: " + size.name());
        ISBannerSize bannerSize = ISBannerSize.BANNER;
        if (Yodo1MasBannerAdSize.LargeBanner == size) {
            bannerSize = ISBannerSize.RECTANGLE;
        } else if (Yodo1MasBannerAdSize.IABMediumRectangle == size) {
            bannerSize = ISBannerSize.RECTANGLE;
        } else if (Yodo1MasBannerAdSize.SmartBanner == size) {
            bannerSize = ISBannerSize.SMART;
        } else if (Yodo1MasBannerAdSize.AdaptiveBanner == size) {
            bannerSize = ISBannerSize.BANNER;
            bannerSize.setAdaptive(true);
        }
        return bannerSize;
    }

    @Override
    public View getBannerView() {
        return bannerAd;
    }

    @Override
    public void dismissBannerAdvert(boolean destroy) {
        super.dismissBannerAdvert(destroy);
        if (bannerAd != null) {
            if (destroy) {
                IronSource.destroyBanner(bannerAd);
                bannerAd = null;
                bannerState = Yodo1MasAdapterBase.AdvertState.NONE;
                advertAdapterState = AdvertAdapterState.NONE;
            }
        }
    }

    @Override
    public boolean isSupportMultipleInstance() {
        return false;
    }
}
